/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractCharClass;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractLineTerminator;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAheadFSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAltGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAltQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAtomicFSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAtomicJointSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TBackReferenceSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TBehindFSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCIBackReferenceSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCICharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCIDecomposedCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCISequenceSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharClass;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCompositeGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCompositeQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCompositeRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TDecomposedCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TDotAllQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TDotAllSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TDotQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TDotSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TEOISet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TEOLSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TEmptySet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TFSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TFinalSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.THangulDecomposedCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.THighSurrogateCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TJointSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLeafQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLeafSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLexer;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLowHighSurrogateRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLowSurrogateCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMatcher;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMultiLineEOLSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TMultiLineSOLSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TNegativeLookAhead;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TNegativeLookBehind;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TNonCapFSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TNonCapJointSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPatternSyntaxException;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPosAltGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPosCompositeGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPosPlusGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPositiveLookAhead;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPositiveLookBehind;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPossessiveAltQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPossessiveCompositeQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPossessiveGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPossessiveQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TPreviousMatch;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TQuantifier;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRelAltGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TRelCompositeGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TReluctantAltQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TReluctantCompositeQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TReluctantGroupQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TReluctantQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSOLSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSequenceSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSingleSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCIBackReferenceSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCICharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCIDecomposedCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCIRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCISequenceSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCISupplCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUCISupplRangeSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUEOLSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUMultiLineEOLSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TUnifiedQuantifierSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TWordBoundary;
import java.io.Serializable;
import java.util.ArrayList;

public final class TPattern
implements Serializable {
    private static final long serialVersionUID = 5073258162644648461L;
    static final boolean _DEBUG_ = false;
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int LITERAL = 16;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    static final int BACK_REF_NUMBER = 10;
    static final int flagsBitMask = 255;
    private transient TLexer lexemes;
    private int flags;
    private transient TFSet[] backRefs = new TFSet[10];
    private transient boolean needsBackRefReplacement;
    private transient int globalGroupIndex = -1;
    private transient int compCount = -1;
    private transient int consCount = -1;
    transient TAbstractSet start;

    public TMatcher matcher(CharSequence input) {
        return new TMatcher(this, input);
    }

    public String[] split(CharSequence inputSeq, int limit) {
        ArrayList<String> res = new ArrayList<String>();
        TMatcher mat = this.matcher(inputSeq);
        int index = 0;
        int curPos = 0;
        if (inputSeq.length() == 0) {
            return new String[]{""};
        }
        while (mat.find() && (index + 1 < limit || limit <= 0)) {
            res.add(inputSeq.subSequence(curPos, mat.start()).toString());
            curPos = mat.end();
            ++index;
        }
        res.add(inputSeq.subSequence(curPos, inputSeq.length()).toString());
        ++index;
        if (limit == 0) {
            while (--index >= 0 && ((String)res.get(index)).toString().length() == 0) {
                res.remove(index);
            }
        }
        return res.toArray(new String[index >= 0 ? index : 0]);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public String pattern() {
        return this.lexemes.toString();
    }

    public String toString() {
        return this.pattern();
    }

    public int flags() {
        return this.flags;
    }

    public static TPattern compile(String pattern, int flags) throws TPatternSyntaxException {
        if (pattern == null) {
            throw new NullPointerException("Patter is null");
        }
        if (flags != 0 && (flags | 0xFF) != 255) {
            throw new IllegalArgumentException("");
        }
        TAbstractSet.counter = 1;
        return new TPattern().compileImpl(pattern, flags);
    }

    private TPattern compileImpl(String pattern, int flags) throws TPatternSyntaxException {
        this.lexemes = new TLexer(pattern, flags);
        this.flags = flags;
        this.start = this.processExpression(-1, this.flags, null);
        if (!this.lexemes.isEmpty()) {
            throw new TPatternSyntaxException("", this.lexemes.toString(), this.lexemes.getIndex());
        }
        this.finalizeCompile();
        return this;
    }

    private TAbstractSet processAlternations(TAbstractSet last) {
        TCharClass auxRange = new TCharClass(this.hasFlag(2), this.hasFlag(64));
        while (!this.lexemes.isEmpty() && this.lexemes.isLetter() && (this.lexemes.lookAhead() == 0 || this.lexemes.lookAhead() == -536870788 || this.lexemes.lookAhead() == -536870871)) {
            auxRange.add(this.lexemes.next());
            if (this.lexemes.peek() != -536870788) continue;
            this.lexemes.next();
        }
        TAbstractSet rangeSet = this.processRangeSet(auxRange);
        rangeSet.setNext(last);
        return rangeSet;
    }

    private TAbstractSet processExpression(int ch, int newFlags, TAbstractSet last) {
        TFSet fSet;
        ArrayList<TAbstractSet> children = new ArrayList<TAbstractSet>();
        int saveFlags = this.flags;
        boolean saveChangedFlags = false;
        if (newFlags != this.flags) {
            this.flags = newFlags;
        }
        switch (ch) {
            case -1073741784: {
                fSet = new TNonCapFSet(++this.consCount);
                break;
            }
            case -536870872: 
            case -268435416: {
                fSet = new TAheadFSet();
                break;
            }
            case -134217688: 
            case -67108824: {
                fSet = new TBehindFSet(++this.consCount);
                break;
            }
            case -33554392: {
                fSet = new TAtomicFSet(++this.consCount);
                break;
            }
            default: {
                ++this.globalGroupIndex;
                if (last == null) {
                    fSet = new TFinalSet();
                    saveChangedFlags = true;
                } else {
                    fSet = new TFSet(this.globalGroupIndex);
                }
                if (this.globalGroupIndex <= -1 || this.globalGroupIndex >= 10) break;
                this.backRefs[this.globalGroupIndex] = fSet;
            }
        }
        do {
            TAbstractSet child;
            if (this.lexemes.isLetter() && this.lexemes.lookAhead() == -536870788) {
                child = this.processAlternations(fSet);
            } else if (this.lexemes.peek() == -536870788) {
                child = new TEmptySet(fSet);
                this.lexemes.next();
            } else {
                child = this.processSubExpression(fSet);
                if (this.lexemes.peek() == -536870788) {
                    this.lexemes.next();
                }
            }
            if (child == null) continue;
            children.add(child);
        } while (!this.lexemes.isEmpty() && this.lexemes.peek() != -536870871);
        if (this.lexemes.back() == -536870788) {
            children.add(new TEmptySet(fSet));
        }
        if (this.flags != saveFlags && !saveChangedFlags) {
            this.flags = saveFlags;
            this.lexemes.restoreFlags(this.flags);
        }
        switch (ch) {
            case -1073741784: {
                return new TNonCapJointSet(children, fSet);
            }
            case -536870872: {
                return new TPositiveLookAhead(children, fSet);
            }
            case -268435416: {
                return new TNegativeLookAhead(children, fSet);
            }
            case -134217688: {
                return new TPositiveLookBehind(children, fSet);
            }
            case -67108824: {
                return new TNegativeLookBehind(children, fSet);
            }
            case -33554392: {
                return new TAtomicJointSet(children, fSet);
            }
        }
        switch (children.size()) {
            case 0: {
                return new TEmptySet(fSet);
            }
            case 1: {
                return new TSingleSet(children.get(0), fSet);
            }
        }
        return new TJointSet(children, fSet);
    }

    private TAbstractSet processSequence() {
        StringBuffer substring = new StringBuffer();
        while (!this.lexemes.isEmpty() && this.lexemes.isLetter() && !this.lexemes.isHighSurrogate() && !this.lexemes.isLowSurrogate() && (!this.lexemes.isNextSpecial() && this.lexemes.lookAhead() == 0 || !this.lexemes.isNextSpecial() && TLexer.isLetter(this.lexemes.lookAhead()) || this.lexemes.lookAhead() == -536870871 || (this.lexemes.lookAhead() & 0x8000FFFF) == -2147483608 || this.lexemes.lookAhead() == -536870788 || this.lexemes.lookAhead() == -536870876)) {
            int ch = this.lexemes.next();
            if (Character.isSupplementaryCodePoint(ch)) {
                substring.append(Character.toChars(ch));
                continue;
            }
            substring.append((char)ch);
        }
        if (!this.hasFlag(2)) {
            return new TSequenceSet(substring);
        }
        if (!this.hasFlag(64)) {
            return new TCISequenceSet(substring);
        }
        return new TUCISequenceSet(substring);
    }

    private TAbstractSet processDecomposedChar() {
        int[] codePoints = new int[4];
        int readCodePoints = 0;
        int curSymb = -1;
        int curSymbIndex = -1;
        if (!this.lexemes.isEmpty() && this.lexemes.isLetter()) {
            codePoints[readCodePoints] = curSymb = this.lexemes.next();
            curSymbIndex = curSymb - 4352;
        }
        if (curSymbIndex >= 0 && curSymbIndex < 19) {
            char[] codePointsHangul = new char[3];
            codePointsHangul[readCodePoints++] = (char)curSymb;
            curSymb = this.lexemes.peek();
            curSymbIndex = curSymb - 4449;
            if (curSymbIndex >= 0 && curSymbIndex < 21) {
                codePointsHangul[readCodePoints++] = (char)curSymb;
                this.lexemes.next();
                curSymb = this.lexemes.peek();
                curSymbIndex = curSymb - 4519;
                if (curSymbIndex >= 0 && curSymbIndex < 28) {
                    codePointsHangul[readCodePoints++] = (char)curSymb;
                    this.lexemes.next();
                    return new THangulDecomposedCharSet(codePointsHangul, 3);
                }
                return new THangulDecomposedCharSet(codePointsHangul, 2);
            }
            if (!this.hasFlag(2)) {
                return new TCharSet(codePointsHangul[0]);
            }
            if (!this.hasFlag(64)) {
                return new TCICharSet(codePointsHangul[0]);
            }
            return new TUCICharSet(codePointsHangul[0]);
        }
        ++readCodePoints;
        while (readCodePoints < 4 && !this.lexemes.isEmpty() && this.lexemes.isLetter()) {
            codePoints[readCodePoints++] = this.lexemes.next();
        }
        if (readCodePoints == 1 && !TLexer.hasSingleCodepointDecomposition(codePoints[0])) {
            return this.processCharSet(codePoints[0]);
        }
        if (!this.hasFlag(2)) {
            return new TDecomposedCharSet(codePoints, readCodePoints);
        }
        if (!this.hasFlag(64)) {
            return new TCIDecomposedCharSet(codePoints, readCodePoints);
        }
        return new TUCIDecomposedCharSet(codePoints, readCodePoints);
    }

    private TAbstractSet processSubExpression(TAbstractSet last) {
        TAbstractSet term;
        TAbstractSet cur;
        if (this.lexemes.isLetter() && !this.lexemes.isNextSpecial() && TLexer.isLetter(this.lexemes.lookAhead())) {
            if (this.hasFlag(128)) {
                cur = this.processDecomposedChar();
                if (!(this.lexemes.isEmpty() || this.lexemes.peek() == -536870871 && !(last instanceof TFinalSet) || this.lexemes.peek() == -536870788 || this.lexemes.isLetter())) {
                    cur = this.processQuantifier(last, cur);
                }
            } else if (this.lexemes.isHighSurrogate() || this.lexemes.isLowSurrogate()) {
                term = this.processTerminal(last);
                cur = this.processQuantifier(last, term);
            } else {
                cur = this.processSequence();
            }
        } else if (this.lexemes.peek() == -536870871) {
            if (last instanceof TFinalSet) {
                throw new TPatternSyntaxException("", this.lexemes.toString(), this.lexemes.getIndex());
            }
            cur = new TEmptySet(last);
        } else {
            term = this.processTerminal(last);
            cur = this.processQuantifier(last, term);
        }
        if (!this.lexemes.isEmpty() && (this.lexemes.peek() != -536870871 || last instanceof TFinalSet) && this.lexemes.peek() != -536870788) {
            TAbstractSet next = this.processSubExpression(last);
            if (!(!(cur instanceof TLeafQuantifierSet) || cur instanceof TCompositeQuantifierSet || cur instanceof TGroupQuantifierSet || cur instanceof TAltQuantifierSet || next.first(((TLeafQuantifierSet)cur).getInnerSet()))) {
                cur = new TUnifiedQuantifierSet((TLeafQuantifierSet)cur);
            }
            if ((char)next.getType() == '+') {
                cur.setNext(((TLeafQuantifierSet)next).getInnerSet());
            } else {
                cur.setNext(next);
            }
        } else if (cur != null) {
            cur.setNext(last);
        } else {
            return null;
        }
        if ((char)cur.getType() == '+') {
            return ((TQuantifierSet)cur).getInnerSet();
        }
        return cur;
    }

    private TAbstractSet processQuantifier(TAbstractSet last, TAbstractSet term) {
        int quant = this.lexemes.peek();
        if (term != null && !(term instanceof TLeafSet)) {
            switch (quant) {
                case -536870870: 
                case -536870869: {
                    this.lexemes.next();
                    TQuantifierSet q = term.getType() == -2147483602 ? (!this.hasFlag(32) ? new TDotQuantifierSet(term, last, quant, TAbstractLineTerminator.getInstance(this.flags)) : new TDotAllQuantifierSet(term, last, quant)) : new TGroupQuantifierSet(term, last, quant);
                    term.setNext(q);
                    return q;
                }
                case -1073741782: 
                case -1073741781: {
                    this.lexemes.next();
                    TReluctantGroupQuantifierSet q = new TReluctantGroupQuantifierSet(term, last, quant);
                    term.setNext(q);
                    return q;
                }
                case -2147483605: {
                    this.lexemes.next();
                    return new TPosPlusGroupQuantifierSet(term, last, -2147483606);
                }
                case -2147483606: {
                    this.lexemes.next();
                    return new TPossessiveGroupQuantifierSet(term, last, quant);
                }
                case -536870849: {
                    this.lexemes.next();
                    TAltGroupQuantifierSet q = new TAltGroupQuantifierSet(term, last, -536870849);
                    term.setNext(last);
                    return q;
                }
                case -2147483585: {
                    this.lexemes.next();
                    return new TPosAltGroupQuantifierSet(term, last, -536870849);
                }
                case -1073741761: {
                    this.lexemes.next();
                    TRelAltGroupQuantifierSet q = new TRelAltGroupQuantifierSet(term, last, -536870849);
                    term.setNext(last);
                    return q;
                }
                case -536870789: {
                    TCompositeGroupQuantifierSet q = new TCompositeGroupQuantifierSet((TQuantifier)this.lexemes.nextSpecial(), term, last, -536870849, ++this.compCount);
                    term.setNext(q);
                    return q;
                }
                case -2147483525: {
                    return new TPosCompositeGroupQuantifierSet((TQuantifier)this.lexemes.nextSpecial(), term, last, -536870849, ++this.compCount);
                }
                case -1073741701: {
                    TRelCompositeGroupQuantifierSet q = new TRelCompositeGroupQuantifierSet((TQuantifier)this.lexemes.nextSpecial(), term, last, -536870849, ++this.compCount);
                    term.setNext(q);
                    return q;
                }
            }
            return term;
        }
        TLeafSet leaf = null;
        if (term != null) {
            leaf = (TLeafSet)term;
        }
        switch (quant) {
            case -536870870: 
            case -536870869: {
                this.lexemes.next();
                TLeafQuantifierSet q = new TLeafQuantifierSet(leaf, last, quant);
                leaf.setNext(q);
                return q;
            }
            case -1073741782: 
            case -1073741781: {
                this.lexemes.next();
                TReluctantQuantifierSet q = new TReluctantQuantifierSet(leaf, last, quant);
                leaf.setNext(q);
                return q;
            }
            case -2147483606: 
            case -2147483605: {
                this.lexemes.next();
                TPossessiveQuantifierSet q = new TPossessiveQuantifierSet(leaf, last, quant);
                leaf.setNext(q);
                return q;
            }
            case -536870849: {
                this.lexemes.next();
                return new TAltQuantifierSet(leaf, last, -536870849);
            }
            case -2147483585: {
                this.lexemes.next();
                return new TPossessiveAltQuantifierSet(leaf, last, -2147483585);
            }
            case -1073741761: {
                this.lexemes.next();
                return new TReluctantAltQuantifierSet(leaf, last, -1073741761);
            }
            case -536870789: {
                return new TCompositeQuantifierSet((TQuantifier)this.lexemes.nextSpecial(), leaf, last, -536870789);
            }
            case -2147483525: {
                return new TPossessiveCompositeQuantifierSet((TQuantifier)this.lexemes.nextSpecial(), leaf, last, -2147483525);
            }
            case -1073741701: {
                return new TReluctantCompositeQuantifierSet((TQuantifier)this.lexemes.nextSpecial(), leaf, last, -1073741701);
            }
        }
        return term;
    }

    private TAbstractSet processTerminal(TAbstractSet last) {
        int ch;
        TAbstractSet term = null;
        do {
            if (((ch = this.lexemes.peek()) & 0x8000FFFF) == -2147483608) {
                this.lexemes.next();
                int newFlags = (ch & 0xFF0000) >> 16;
                if ((ch &= 0xFF00FFFF) == -16777176) {
                    this.flags = newFlags;
                    continue;
                }
                newFlags = ch == -1073741784 ? newFlags : this.flags;
                term = this.processExpression(ch, newFlags, last);
                if (this.lexemes.peek() != -536870871) {
                    throw new TPatternSyntaxException("", this.lexemes.toString(), this.lexemes.getIndex());
                }
                this.lexemes.next();
                continue;
            }
            switch (ch) {
                case -536870821: {
                    this.lexemes.next();
                    boolean negative = false;
                    if (this.lexemes.peek() == -536870818) {
                        negative = true;
                        this.lexemes.next();
                    }
                    term = this.processRange(negative, last);
                    if (this.lexemes.peek() != -536870819) {
                        throw new TPatternSyntaxException("", this.lexemes.toString(), this.lexemes.getIndex());
                    }
                    this.lexemes.setMode(1);
                    this.lexemes.next();
                    break;
                }
                case -536870866: {
                    this.lexemes.next();
                    if (!this.hasFlag(32)) {
                        term = new TDotSet(TAbstractLineTerminator.getInstance(this.flags));
                        break;
                    }
                    term = new TDotAllSet();
                    break;
                }
                case -536870818: {
                    this.lexemes.next();
                    ++this.consCount;
                    if (!this.hasFlag(8)) {
                        term = new TSOLSet();
                        break;
                    }
                    term = new TMultiLineSOLSet(TAbstractLineTerminator.getInstance(this.flags));
                    break;
                }
                case -536870876: {
                    this.lexemes.next();
                    ++this.consCount;
                    if (!this.hasFlag(8)) {
                        if (!this.hasFlag(1)) {
                            term = new TEOLSet(this.consCount);
                            break;
                        }
                        term = new TUEOLSet(this.consCount);
                        break;
                    }
                    if (!this.hasFlag(1)) {
                        term = new TMultiLineEOLSet(this.consCount);
                        break;
                    }
                    term = new TUMultiLineEOLSet(this.consCount);
                    break;
                }
                case -2147483550: {
                    this.lexemes.next();
                    term = new TWordBoundary(true);
                    break;
                }
                case -2147483582: {
                    this.lexemes.next();
                    term = new TWordBoundary(false);
                    break;
                }
                case -2147483526: {
                    this.lexemes.next();
                    term = new TEOISet();
                    break;
                }
                case -2147483558: {
                    this.lexemes.next();
                    term = new TEOLSet(++this.consCount);
                    break;
                }
                case -2147483583: {
                    this.lexemes.next();
                    term = new TSOLSet();
                    break;
                }
                case -2147483577: {
                    this.lexemes.next();
                    term = new TPreviousMatch();
                    break;
                }
                case -2147483599: 
                case -2147483598: 
                case -2147483597: 
                case -2147483596: 
                case -2147483595: 
                case -2147483594: 
                case -2147483593: 
                case -2147483592: 
                case -2147483591: {
                    int number = (ch & Integer.MAX_VALUE) - 48;
                    if (this.globalGroupIndex >= number) {
                        this.lexemes.next();
                        ++this.consCount;
                        term = !this.hasFlag(2) ? new TBackReferenceSet(number, this.consCount) : (!this.hasFlag(64) ? new TCIBackReferenceSet(number, this.consCount) : new TUCIBackReferenceSet(number, this.consCount));
                        this.backRefs[number].isBackReferenced = true;
                        this.needsBackRefReplacement = true;
                        break;
                    }
                    throw new TPatternSyntaxException("", this.lexemes.toString(), this.lexemes.getIndex());
                }
                case 0: {
                    TAbstractCharClass cc = (TAbstractCharClass)this.lexemes.peekSpecial();
                    if (cc != null) {
                        term = this.processRangeSet(cc);
                    } else if (!this.lexemes.isEmpty()) {
                        term = new TCharSet((char)ch);
                    } else {
                        term = new TEmptySet(last);
                        break;
                    }
                    this.lexemes.next();
                    break;
                }
                default: {
                    if (ch >= 0 && !this.lexemes.isSpecial()) {
                        term = this.processCharSet(ch);
                        this.lexemes.next();
                        break;
                    }
                    if (ch == -536870788) {
                        term = new TEmptySet(last);
                        break;
                    }
                    if (ch == -536870871) {
                        if (last instanceof TFinalSet) {
                            throw new TPatternSyntaxException("", this.lexemes.toString(), this.lexemes.getIndex());
                        }
                        term = new TEmptySet(last);
                        break;
                    }
                    throw new TPatternSyntaxException(this.lexemes.isSpecial() ? this.lexemes.peekSpecial().toString() : Character.toString((char)ch), this.lexemes.toString(), this.lexemes.getIndex());
                }
            }
        } while (ch == -16777176);
        return term;
    }

    private TAbstractSet processRange(boolean negative, TAbstractSet last) {
        TCharClass res = this.processRangeExpression(negative);
        TAbstractSet rangeSet = this.processRangeSet(res);
        rangeSet.setNext(last);
        return rangeSet;
    }

    private TCharClass processRangeExpression(boolean alt) {
        TCharClass res = new TCharClass(alt, this.hasFlag(2), this.hasFlag(64));
        int buffer = -1;
        boolean intersection = false;
        boolean notClosed = false;
        boolean firstInClass = true;
        while (!this.lexemes.isEmpty()) {
            boolean bl = notClosed = this.lexemes.peek() != -536870819 || firstInClass;
            if (!notClosed) break;
            switch (this.lexemes.peek()) {
                case -536870819: {
                    if (buffer >= 0) {
                        res.add(buffer);
                    }
                    buffer = 93;
                    this.lexemes.next();
                    break;
                }
                case -536870821: {
                    if (buffer >= 0) {
                        res.add(buffer);
                        buffer = -1;
                    }
                    this.lexemes.next();
                    boolean negative = false;
                    if (this.lexemes.peek() == -536870818) {
                        this.lexemes.next();
                        negative = true;
                    }
                    if (intersection) {
                        res.intersection(this.processRangeExpression(negative));
                    } else {
                        res.union(this.processRangeExpression(negative));
                    }
                    intersection = false;
                    this.lexemes.next();
                    break;
                }
                case -536870874: {
                    if (buffer >= 0) {
                        res.add(buffer);
                    }
                    buffer = this.lexemes.next();
                    if (this.lexemes.peek() == -536870874) {
                        if (this.lexemes.lookAhead() == -536870821) {
                            this.lexemes.next();
                            intersection = true;
                            buffer = -1;
                            break;
                        }
                        this.lexemes.next();
                        if (firstInClass) {
                            res = this.processRangeExpression(false);
                            break;
                        }
                        if (this.lexemes.peek() == -536870819) break;
                        res.intersection(this.processRangeExpression(false));
                        break;
                    }
                    buffer = 38;
                    break;
                }
                case -536870867: {
                    if (firstInClass || this.lexemes.lookAhead() == -536870819 || this.lexemes.lookAhead() == -536870821 || buffer < 0) {
                        if (buffer >= 0) {
                            res.add(buffer);
                        }
                        buffer = 45;
                        this.lexemes.next();
                        break;
                    }
                    this.lexemes.next();
                    int cur = this.lexemes.peek();
                    if (!(this.lexemes.isSpecial() || cur < 0 && this.lexemes.lookAhead() != -536870819 && this.lexemes.lookAhead() != -536870821 && buffer >= 0)) {
                        try {
                            if (!TLexer.isLetter(cur)) {
                                cur &= 0xFFFF;
                            }
                            res.add(buffer, cur);
                        }
                        catch (Exception e) {
                            throw new TPatternSyntaxException("", this.pattern(), this.lexemes.getIndex());
                        }
                        this.lexemes.next();
                        buffer = -1;
                        break;
                    }
                    throw new TPatternSyntaxException("", this.pattern(), this.lexemes.getIndex());
                }
                case -536870818: {
                    if (buffer >= 0) {
                        res.add(buffer);
                    }
                    buffer = 94;
                    this.lexemes.next();
                    break;
                }
                case 0: {
                    TAbstractCharClass cs;
                    if (buffer >= 0) {
                        res.add(buffer);
                    }
                    if ((cs = (TAbstractCharClass)this.lexemes.peekSpecial()) != null) {
                        res.add(cs);
                        buffer = -1;
                    } else {
                        buffer = 0;
                    }
                    this.lexemes.next();
                    break;
                }
                default: {
                    if (buffer >= 0) {
                        res.add(buffer);
                    }
                    buffer = this.lexemes.next();
                }
            }
            firstInClass = false;
        }
        if (notClosed) {
            throw new TPatternSyntaxException("", this.pattern(), this.lexemes.getIndex() - 1);
        }
        if (buffer >= 0) {
            res.add(buffer);
        }
        return res;
    }

    private TAbstractSet processCharSet(int ch) {
        boolean isSupplCodePoint = Character.isSupplementaryCodePoint(ch);
        if (this.hasFlag(2)) {
            if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                return new TCICharSet((char)ch);
            }
            if (this.hasFlag(64) && ch > 128) {
                if (isSupplCodePoint) {
                    return new TUCISupplCharSet(ch);
                }
                if (TLexer.isLowSurrogate(ch)) {
                    return new TLowSurrogateCharSet((char)ch);
                }
                if (TLexer.isHighSurrogate(ch)) {
                    return new THighSurrogateCharSet((char)ch);
                }
                return new TUCICharSet((char)ch);
            }
        }
        if (isSupplCodePoint) {
            return new TSupplCharSet(ch);
        }
        if (TLexer.isLowSurrogate(ch)) {
            return new TLowSurrogateCharSet((char)ch);
        }
        if (TLexer.isHighSurrogate(ch)) {
            return new THighSurrogateCharSet((char)ch);
        }
        return new TCharSet((char)ch);
    }

    private TAbstractSet processRangeSet(TAbstractCharClass charClass) {
        if (charClass.hasLowHighSurrogates()) {
            TAbstractCharClass surrogates = charClass.getSurrogates();
            TLowHighSurrogateRangeSet lowHighSurrRangeSet = new TLowHighSurrogateRangeSet(surrogates);
            if (charClass.mayContainSupplCodepoints()) {
                if (!charClass.hasUCI()) {
                    return new TCompositeRangeSet(new TSupplRangeSet(charClass.getWithoutSurrogates()), lowHighSurrRangeSet);
                }
                return new TCompositeRangeSet(new TUCISupplRangeSet(charClass.getWithoutSurrogates()), lowHighSurrRangeSet);
            }
            if (!charClass.hasUCI()) {
                return new TCompositeRangeSet(new TRangeSet(charClass.getWithoutSurrogates()), lowHighSurrRangeSet);
            }
            return new TCompositeRangeSet(new TUCIRangeSet(charClass.getWithoutSurrogates()), lowHighSurrRangeSet);
        }
        if (charClass.mayContainSupplCodepoints()) {
            if (!charClass.hasUCI()) {
                return new TSupplRangeSet(charClass);
            }
            return new TUCISupplRangeSet(charClass);
        }
        if (!charClass.hasUCI()) {
            return new TRangeSet(charClass);
        }
        return new TUCIRangeSet(charClass);
    }

    public static TPattern compile(String pattern) {
        return TPattern.compile(pattern, 0);
    }

    private void finalizeCompile() {
        if (this.needsBackRefReplacement) {
            this.start.processSecondPass();
        }
    }

    public static boolean matches(String regex, CharSequence input) {
        return TPattern.compile(regex).matcher(input).matches();
    }

    public static String quote(String s) {
        int k;
        StringBuilder sb = new StringBuilder().append("\\Q");
        int apos = 0;
        while ((k = s.indexOf("\\E", apos)) >= 0) {
            sb.append(s.substring(apos, k + 2)).append("\\\\E\\Q");
            apos = k + 2;
        }
        return sb.append(s.substring(apos)).append("\\E").toString();
    }

    int groupCount() {
        return this.globalGroupIndex;
    }

    int compCount() {
        return this.compCount + 1;
    }

    int consCount() {
        return this.consCount + 1;
    }

    static char getSupplement(char ch) {
        char res = ch;
        if (ch >= 'a' && ch <= 'z') {
            res = (char)(res - 32);
        } else if (ch >= 'A' && ch <= 'Z') {
            res = (char)(res + 32);
        }
        return res;
    }

    private boolean hasFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    private TPattern() {
    }
}

