/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.zip;

import com.antgroup.antchain.myjava.classlib.java.util.zip.TChecksum;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TCheckedInputStream
extends FilterInputStream {
    private final TChecksum check;

    public TCheckedInputStream(InputStream is, TChecksum csum) {
        super(is);
        this.check = csum;
    }

    @Override
    public int read() throws IOException {
        int x = this.in.read();
        if (x != -1) {
            this.check.update(x);
        }
        return x;
    }

    @Override
    public int read(byte[] buf, int off, int nbytes) throws IOException {
        int x = this.in.read(buf, off, nbytes);
        if (x != -1) {
            this.check.update(buf, off, x);
        }
        return x;
    }

    public TChecksum getChecksum() {
        return this.check;
    }

    @Override
    public long skip(long nbytes) throws IOException {
        long skipped;
        int x;
        if (nbytes < 1L) {
            return 0L;
        }
        byte[] b = new byte[(int)Math.min(nbytes, 2048L)];
        for (skipped = 0L; skipped != nbytes; skipped += (long)x) {
            int v = (int)(nbytes - skipped);
            x = this.in.read(b, 0, v > b.length ? b.length : v);
            if (x == -1) {
                return skipped;
            }
            this.check.update(b, 0, x);
        }
        return skipped;
    }
}

