/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TBufferOverflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TBufferUnderflowException;
import com.antgroup.antchain.myjava.classlib.java.nio.TDoubleBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TReadOnlyBufferException;

abstract class TDoubleBufferImpl
extends TDoubleBuffer {
    private static void cpdBegin() {
    }

    public TDoubleBufferImpl(int capacity, int position, int limit) {
        super(capacity, position, limit);
    }

    @Override
    public TDoubleBuffer slice() {
        return this.duplicate(this.position, this.limit - this.position, 0, this.limit - this.position, this.isReadOnly());
    }

    @Override
    public TDoubleBuffer duplicate() {
        return this.duplicate(0, this.capacity, this.position, this.limit, this.isReadOnly());
    }

    @Override
    public TDoubleBuffer asReadOnlyBuffer() {
        return this.duplicate(0, this.capacity, this.position, this.limit, true);
    }

    abstract TDoubleBuffer duplicate(int var1, int var2, int var3, int var4, boolean var5);

    @Override
    public double get() {
        if (this.position >= this.limit) {
            throw new TBufferUnderflowException();
        }
        return this.getElement(this.position++);
    }

    @Override
    public TDoubleBuffer put(double b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (this.position >= this.limit) {
            throw new TBufferOverflowException();
        }
        this.putElement(this.position++, b);
        return this;
    }

    @Override
    public double get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        return this.getElement(index);
    }

    @Override
    public TDoubleBuffer put(int index, double b) {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside of range [0;" + this.limit + ")");
        }
        this.putElement(index, b);
        return this;
    }

    @Override
    public TDoubleBuffer compact() {
        if (this.isReadOnly()) {
            throw new TReadOnlyBufferException();
        }
        int sz = this.remaining();
        if (this.position > 0) {
            int src = this.position;
            for (int i = 0; i < sz; ++i) {
                this.putElement(i, this.getElement(src++));
            }
        }
        this.position = sz;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly();
    }

    abstract boolean readOnly();

    private static void cpdEnd() {
    }
}

