/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.lang.TComparable;
import com.antgroup.antchain.myjava.classlib.java.util.function.TFunction;
import com.antgroup.antchain.myjava.classlib.java.util.function.TToDoubleFunction;
import com.antgroup.antchain.myjava.classlib.java.util.function.TToIntFunction;
import com.antgroup.antchain.myjava.classlib.java.util.function.TToLongFunction;

@FunctionalInterface
public interface TComparator<T> {
    public int compare(T var1, T var2);

    default public TComparator<T> reversed() {
        return (a, b) -> this.compare(b, a);
    }

    default public TComparator<T> thenComparing(TComparator<? super T> other) {
        return (a, b) -> {
            int r = this.compare(a, b);
            if (r == 0) {
                r = other.compare(a, b);
            }
            return r;
        };
    }

    default public <U> TComparator<T> thenComparing(TFunction<? super T, ? extends U> keyExtractor, TComparator<? super U> keyComparator) {
        return this.thenComparing(TComparator.comparing(keyExtractor, keyComparator));
    }

    default public <U extends Comparable<? super U>> TComparator<T> thenComparing(TFunction<? super T, ? extends U> keyExtractor) {
        return (a, b) -> {
            int r = this.compare(a, b);
            if (r == 0) {
                Comparable k = (Comparable)keyExtractor.apply(a);
                Comparable m = (Comparable)keyExtractor.apply(b);
                r = k != null ? k.compareTo(m) : -m.compareTo(k);
            }
            return r;
        };
    }

    default public TComparator<T> thenComparingInt(TToIntFunction<? super T> keyExtractor) {
        return (a, b) -> {
            int r = this.compare(a, b);
            if (r == 0) {
                r = Integer.compare(keyExtractor.applyAsInt(a), keyExtractor.applyAsInt(b));
            }
            return r;
        };
    }

    default public TComparator<T> thenComparingLong(TToLongFunction<? super T> keyExtractor) {
        return (a, b) -> {
            int r = this.compare(a, b);
            if (r == 0) {
                r = Long.compare(keyExtractor.applyAsLong(a), keyExtractor.applyAsLong(b));
            }
            return r;
        };
    }

    default public TComparator<T> thenComparingDouble(TToDoubleFunction<? super T> keyExtractor) {
        return (a, b) -> {
            int r = this.compare(a, b);
            if (r == 0) {
                r = Double.compare(keyExtractor.applyAsDouble(a), keyExtractor.applyAsDouble(b));
            }
            return r;
        };
    }

    public static <T, U> TComparator<T> comparing(TFunction<? super T, ? extends U> keyExtractor, TComparator<? super U> keyComparator) {
        return (a, b) -> keyComparator.compare((Object)keyExtractor.apply(a), (Object)keyExtractor.apply(b));
    }

    public static <T, U extends TComparable<? super U>> TComparator<T> comparing(TFunction<? super T, ? extends U> keyExtractor) {
        return (a, b) -> {
            TComparable k = (TComparable)keyExtractor.apply(a);
            TComparable m = (TComparable)keyExtractor.apply(b);
            return k != null ? k.compareTo(m) : -m.compareTo(k);
        };
    }

    public static <T extends TComparable<? super T>> TComparator<T> naturalOrder() {
        return (o1, o2) -> o1 != null ? o1.compareTo(o2) : o2.compareTo(o1);
    }

    public static <T extends TComparable<? super T>> TComparator<T> reverseOrder() {
        return (o1, o2) -> o2 != null ? o2.compareTo(o1) : o1.compareTo(o2);
    }

    public static <T> TComparator<T> nullsFirst(TComparator<? super T> comparator) {
        return (a, b) -> a == null && b == null ? 0 : (a == null ? -1 : (b == null ? 1 : comparator.compare(a, b)));
    }

    public static <T> TComparator<T> nullsLast(TComparator<? super T> comparator) {
        return (a, b) -> a == null && b == null ? 0 : (a == null ? 1 : (b == null ? -1 : comparator.compare(a, b)));
    }

    public static <T> TComparator<T> comparingInt(TToIntFunction<? super T> keyExtractor) {
        return (a, b) -> Integer.compare(keyExtractor.applyAsInt(a), keyExtractor.applyAsInt(b));
    }

    public static <T> TComparator<T> comparingLong(TToLongFunction<? super T> keyExtractor) {
        return (a, b) -> Long.compare(keyExtractor.applyAsLong(a), keyExtractor.applyAsLong(b));
    }

    public static <T> TComparator<T> comparingDouble(TToDoubleFunction<? super T> keyExtractor) {
        return (a, b) -> Double.compare(keyExtractor.applyAsDouble(a), keyExtractor.applyAsDouble(b));
    }
}

