/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.io.TSerializable;
import com.antgroup.antchain.myjava.classlib.java.lang.TCloneNotSupportedException;
import com.antgroup.antchain.myjava.classlib.java.lang.TCloneable;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalArgumentException;
import com.antgroup.antchain.myjava.classlib.java.lang.TIllegalStateException;
import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.util.TAbstractCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TAbstractMap;
import com.antgroup.antchain.myjava.classlib.java.util.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TConcurrentModificationException;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TMap;
import com.antgroup.antchain.myjava.classlib.java.util.TMapEntry;
import com.antgroup.antchain.myjava.classlib.java.util.TNoSuchElementException;
import com.antgroup.antchain.myjava.classlib.java.util.TSet;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.Rename;
import java.util.Arrays;
import java.util.ConcurrentModificationException;

@NoMetadata
public class TIdentityHashMap<K, V>
extends TAbstractMap<K, V>
implements TCloneable,
TSerializable {
    transient int elementCount;
    transient HashEntry<K, V>[] elementData;
    transient int modCount;
    private static final int DEFAULT_SIZE = 16;
    final float loadFactor;
    int threshold;

    private static void cpdBegin() {
    }

    HashEntry<K, V>[] newElementArray(int s) {
        return new HashEntry[s];
    }

    public TIdentityHashMap() {
        this(16);
    }

    public TIdentityHashMap(int capacity) {
        this(capacity, 0.75f);
    }

    public TIdentityHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new TIllegalArgumentException();
        }
        capacity = TIdentityHashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = loadFactor;
        this.computeThreshold();
    }

    public TIdentityHashMap(TMap<? extends K, ? extends V> map) {
        this(TIdentityHashMap.calculateCapacity(map.size()));
        super.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    @Rename(value="clone")
    public TObject clone0() {
        try {
            TIdentityHashMap map = (TIdentityHashMap)super.clone();
            map.elementCount = 0;
            map.elementData = this.newElementArray(this.elementData.length);
            map.putAll(this);
            return map;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    private void computeThreshold() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        HashEntry<K, V> m = this.getEntry(key);
        return m != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (int i = 0; i < this.elementData.length; ++i) {
                HashEntry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    if (TIdentityHashMap.areSameValues(value, entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (int i = 0; i < this.elementData.length; ++i) {
                HashEntry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return new HashMapEntrySet(this);
    }

    @Override
    public V get(Object key) {
        HashEntry<K, V> m = this.getEntry(key);
        if (m != null) {
            return (V)m.value;
        }
        return null;
    }

    final HashEntry<K, V> getEntry(Object key) {
        HashEntry<K, V> m;
        if (key == null) {
            m = this.findNullKeyEntry();
        } else {
            int hash = TIdentityHashMap.computeHashCode(key);
            int index = hash & this.elementData.length - 1;
            m = this.findNonNullKeyEntry(key, index, hash);
        }
        return m;
    }

    final HashEntry<K, V> findNonNullKeyEntry(Object key, int index, int keyHash) {
        HashEntry<K, V> m = this.elementData[index];
        while (!(m == null || m.origKeyHash == keyHash && TIdentityHashMap.areSameKeys(key, m.key))) {
            m = m.next;
        }
        return m;
    }

    final HashEntry<K, V> findNullKeyEntry() {
        HashEntry<K, V> m = this.elementData[0];
        while (m != null && m.key != null) {
            m = m.next;
        }
        return m;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public TSet<K> keySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new TAbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return TIdentityHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return TIdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    TIdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    HashEntry entry = TIdentityHashMap.this.removeEntry(key);
                    return entry != null;
                }

                @Override
                public TIterator<K> iterator() {
                    return new KeyIterator(TIdentityHashMap.this);
                }
            };
        }
        return this.cachedKeySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    V putImpl(K key, V value) {
        HashEntry<Object, V> entry;
        if (key == null) {
            entry = this.findNullKeyEntry();
            if (entry == null) {
                ++this.modCount;
                entry = this.createHashedEntry(null, 0, 0);
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
            }
        } else {
            int hash = TIdentityHashMap.computeHashCode(key);
            int index = hash & this.elementData.length - 1;
            entry = this.findNonNullKeyEntry(key, index, hash);
            if (entry == null) {
                ++this.modCount;
                entry = this.createHashedEntry(key, index, hash);
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
            }
        }
        Object result = entry.value;
        entry.value = value;
        return (V)result;
    }

    HashEntry<K, V> createEntry(K key, int index, V value) {
        HashEntry<K, V> entry = new HashEntry<K, V>(key, value);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    HashEntry<K, V> createHashedEntry(K key, int index, int hash) {
        HashEntry<K, int> entry = new HashEntry<K, int>(key, hash);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    private void putAllImpl(TMap<? extends K, ? extends V> map) {
        int capacity = this.elementCount + map.size();
        if (capacity > this.threshold) {
            this.rehash(capacity);
        }
        TIterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    void rehash(int capacity) {
        int length = TIdentityHashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        HashEntry<K, V>[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            HashEntry<K, V> entry = this.elementData[i];
            this.elementData[i] = null;
            while (entry != null) {
                int index = entry.origKeyHash & length - 1;
                HashEntry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeThreshold();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(Object key) {
        HashEntry<K, V> entry = this.removeEntry(key);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    final void removeEntry(HashEntry<K, V> entry) {
        int index = entry.origKeyHash & this.elementData.length - 1;
        HashEntry<K, V> m = this.elementData[index];
        if (m == entry) {
            this.elementData[index] = entry.next;
        } else {
            while (m.next != entry) {
                m = m.next;
            }
            m.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
    }

    final HashEntry<K, V> removeEntry(Object key) {
        HashEntry<K, V> entry;
        int index = 0;
        HashEntry<K, V> last = null;
        if (key != null) {
            int hash = TIdentityHashMap.computeHashCode(key);
            index = hash & this.elementData.length - 1;
            entry = this.elementData[index];
            while (!(entry == null || entry.origKeyHash == hash && TIdentityHashMap.areSameKeys(key, entry.key))) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new TAbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return TIdentityHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return TIdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    TIdentityHashMap.this.clear();
                }

                @Override
                public TIterator<V> iterator() {
                    return new ValueIterator(TIdentityHashMap.this);
                }
            };
        }
        return this.cachedValues;
    }

    static int computeHashCode(Object key) {
        return System.identityHashCode(key);
    }

    static boolean areSameKeys(Object key1, Object key2) {
        return key1 == key2;
    }

    static boolean areSameValues(Object value1, Object value2) {
        return value1 == value2;
    }

    private static void cpdEnd() {
    }

    static class HashMapEntrySet<K, V>
    extends TAbstractSet<TMap.Entry<K, V>> {
        private final TIdentityHashMap<K, V> associatedMap;

        public HashMapEntrySet(TIdentityHashMap<K, V> hm) {
            this.associatedMap = hm;
        }

        TIdentityHashMap<K, V> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            TMap.Entry oEntry;
            HashEntry<K, V> entry;
            if (object instanceof TMap.Entry && HashMapEntrySet.valuesEq(entry = this.associatedMap.getEntry((oEntry = (TMap.Entry)object).getKey()), oEntry)) {
                this.associatedMap.removeEntry((Object)entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof TMap.Entry) {
                TMap.Entry oEntry = (TMap.Entry)object;
                HashEntry<K, V> entry = this.associatedMap.getEntry(oEntry.getKey());
                return HashMapEntrySet.valuesEq(entry, oEntry);
            }
            return false;
        }

        private static boolean valuesEq(TMap.Entry<?, ?> entry, TMap.Entry<?, ?> oEntry) {
            return entry != null && (entry.getValue() == null ? oEntry.getValue() == null : TIdentityHashMap.areSameValues(entry.getValue(), oEntry.getValue()));
        }

        @Override
        public TIterator<TMap.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.associatedMap);
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<V> {
        ValueIterator(TIdentityHashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<K> {
        KeyIterator(TIdentityHashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<TMap.Entry<K, V>> {
        EntryIterator(TIdentityHashMap<K, V> map) {
            super(map);
        }

        @Override
        public TMap.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class AbstractMapIterator<K, V> {
        private int position;
        int expectedModCount;
        HashEntry<K, V> futureEntry;
        HashEntry<K, V> currentEntry;
        HashEntry<K, V> prevEntry;
        final TIdentityHashMap<K, V> associatedMap;

        AbstractMapIterator(TIdentityHashMap<K, V> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new TConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new TNoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new TIllegalStateException();
            }
            if (this.prevEntry == null) {
                int index = this.currentEntry.origKeyHash & this.associatedMap.elementData.length - 1;
                this.associatedMap.elementData[index] = this.associatedMap.elementData[index].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }

    @NoMetadata
    static class HashEntry<K, V>
    extends TMapEntry<K, V> {
        final int origKeyHash;
        HashEntry<K, V> next;

        HashEntry(K theKey, int hash) {
            super(theKey, null);
            this.origKeyHash = hash;
        }

        HashEntry(K theKey, V theValue) {
            super(theKey, theValue);
            this.origKeyHash = theKey == null ? 0 : TIdentityHashMap.computeHashCode(theKey);
        }

        @Override
        public Object clone() {
            HashEntry entry = (HashEntry)super.clone();
            if (this.next != null) {
                entry.next = (HashEntry)this.next.clone();
            }
            return entry;
        }
    }
}

