/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl.tz;

import com.antgroup.antchain.myjava.classlib.impl.tz.AliasDateTimeZone;
import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZone;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public final class DateTimeZoneProvider {
    private static Map<String, DateTimeZone> cache = new HashMap<String, DateTimeZone>();

    private DateTimeZoneProvider() {
    }

    public static DateTimeZone getTimeZone(String id) {
        if (!cache.containsKey(id)) {
            cache.put(id, DateTimeZoneProvider.createTimeZone(id));
        }
        return cache.get(id);
    }

    private static DateTimeZone createTimeZone(String id) {
        throw new RuntimeException("can't create timezone");
    }

    public static String[] getIds() {
        return new String[0];
    }

    public static DateTimeZone detectTimezone() {
        List zones = new ArrayList<Score>();
        long time = System.currentTimeMillis();
        int offset = -DateTimeZoneProvider.getNativeOffset(System.currentTimeMillis());
        for (String id : DateTimeZoneProvider.getIds()) {
            int tzOffset;
            DateTimeZone tz = DateTimeZoneProvider.getTimeZone(id);
            if (tz instanceof AliasDateTimeZone || Math.abs((tzOffset = tz.getOffset(time) / 60000) - offset) > 120 || tz.previousTransition(time) == time) continue;
            zones.add(new Score(tz));
        }
        ArrayList<Score> scoreTable = new ArrayList<Score>();
        scoreTable.addAll(zones);
        HashMap<Long, List> zoneMap = new HashMap<Long, List>();
        PriorityQueue<Long> queue = new PriorityQueue<Long>(zones.size(), new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o2.compareTo(o1);
            }
        });
        HashSet<Long> timeInQueue = new HashSet<Long>();
        long last = time;
        queue.add(time);
        zoneMap.put(time, new ArrayList(zones));
        while (!queue.isEmpty() && scoreTable.size() > 1) {
            time = (Long)queue.remove();
            timeInQueue.remove(time);
            zones = (List)zoneMap.remove(time);
            offset = -DateTimeZoneProvider.getNativeOffset(time);
            for (Score score : zones) {
                long prev = score.tz.previousTransition(time);
                if (prev == time) {
                    if (scoreTable.get(0) == score) {
                        return score.tz;
                    }
                    scoreTable.remove(score);
                    continue;
                }
                int tzOffset = score.tz.getOffset(time) / 60000;
                if (Math.abs(tzOffset - offset) > 120) {
                    scoreTable.remove(score);
                    continue;
                }
                List prevZones = zoneMap.computeIfAbsent(prev, k -> new ArrayList());
                prevZones.add(score);
                if (!timeInQueue.add(prev)) continue;
                queue.add(prev);
            }
            if (scoreTable.size() == 1 || ((Score)scoreTable.get((int)0)).tz.previousTransition(time) == time) {
                return ((Score)scoreTable.get((int)0)).tz;
            }
            if (scoreTable.size() > 1 && ((Score)scoreTable.get((int)0)).value + 2880 < ((Score)scoreTable.get((int)1)).value) {
                return ((Score)scoreTable.get((int)0)).tz;
            }
            for (int i = scoreTable.size() - 1; i >= 0; --i) {
                int j;
                Score score;
                score = (Score)scoreTable.get(i);
                int tzOffset = score.tz.getOffset(time) / 60000;
                if (tzOffset != offset) {
                    score.value += (int)((last - time) / 60000L) * Math.abs(tzOffset - offset) / 30;
                }
                for (j = i + 1; j < scoreTable.size() && score.value > ((Score)scoreTable.get((int)j)).value; ++j) {
                    scoreTable.set(j - 1, (Score)scoreTable.get(j));
                }
                scoreTable.set(j - 1, score);
            }
            last = time;
        }
        return ((Score)scoreTable.get((int)0)).tz;
    }

    private static int getNativeOffset(double instant) {
        return 0;
    }

    static class Score {
        DateTimeZone tz;
        int value;

        public Score(DateTimeZone tz) {
            this.tz = tz;
        }
    }
}

