/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.impl.tz;

import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.classlib.impl.tz.DateTimeZoneProvider;
import com.antgroup.antchain.myjava.model.MethodReference;
import java.util.Properties;

public class DateTimeZoneProviderIntrinsic
implements WasmIntrinsic {
    private Properties properties;

    public DateTimeZoneProviderIntrinsic(Properties properties) {
        this.properties = properties;
    }

    public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
        if (!methodReference.getClassName().equals(DateTimeZoneProvider.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "timeZoneDetectionEnabled": {
                return true;
            }
        }
        return false;
    }

    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "timeZoneDetectionEnabled": {
                boolean enabled = this.properties.getProperty("java.util.TimeZone.autodetect", "false").equals("true");
                return new WasmInt32Constant(enabled ? 1 : 0);
            }
        }
        throw new AssertionError();
    }
}

