/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.lang;

import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.DependencyPlugin;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MemberReader;
import com.antgroup.antchain.myjava.model.ValueType;
import java.io.IOException;

public class ClassGenerator
implements DependencyPlugin {
    private static final FieldReference platformClassField = new FieldReference(Class.class.getName(), "platformClass");

    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "newEmptyInstance": {
                method.getVariable(0).getClassValueNode().connect(method.getResult());
                break;
            }
            case "getSuperclass": {
                this.reachGetSuperclass(agent, method);
                break;
            }
            case "getInterfaces": {
                this.reachGetInterfaces(agent, method);
                break;
            }
            case "getComponentType": {
                this.reachGetComponentType(agent, method);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void reachGetSuperclass(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(type -> {
            String className = type.getName();
            if (className.startsWith("[")) {
                return;
            }
            ClassReader cls = agent.getClassSource().get(className);
            if (cls != null && cls.getParent() != null) {
                method.getResult().getClassValueNode().propagate(agent.getType(cls.getParent()));
            }
        });
    }

    private void reachGetInterfaces(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(type -> {
            String className = type.getName();
            if (className.startsWith("[")) {
                return;
            }
            ClassReader cls = agent.getClassSource().get(className);
            if (cls != null) {
                for (String iface : cls.getInterfaces()) {
                    method.getResult().getClassValueNode().propagate(agent.getType(iface));
                }
            }
        });
    }

    private void reachGetComponentType(DependencyAgent agent, MethodDependency method) {
        method.getVariable(0).getClassValueNode().addConsumer(t -> {
            if (!t.getName().startsWith("[")) {
                return;
            }
            String typeName = t.getName().substring(1);
            if (typeName.charAt(0) == 'L') {
                typeName = ((ValueType.Object)ValueType.parse((String)typeName)).getClassName();
            }
            method.getResult().getClassValueNode().propagate(agent.getType(typeName));
        });
    }

    private static interface MemberRenderer<T extends MemberReader> {
        public void render(T var1) throws IOException;
    }

    private static interface Fragment {
        public void render() throws IOException;
    }
}

