/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.math;

import com.antgroup.antchain.myjava.classlib.java.math.TBigInteger;

class TElementary {
    private static void cpdBegin() {
    }

    private TElementary() {
    }

    static int compareArrays(int[] a, int[] b, int size) {
        int i;
        for (i = size - 1; i >= 0 && a[i] == b[i]; --i) {
        }
        return i < 0 ? 0 : (((long)a[i] & 0xFFFFFFFFL) < ((long)b[i] & 0xFFFFFFFFL) ? -1 : 1);
    }

    static TBigInteger add(TBigInteger op1, TBigInteger op2) {
        int[] resDigits;
        int resSign;
        int op1Sign = op1.sign;
        int op2Sign = op2.sign;
        if (op1Sign == 0) {
            return op2;
        }
        if (op2Sign == 0) {
            return op1;
        }
        int op1Len = op1.numberLength;
        int op2Len = op2.numberLength;
        if (op1Len + op2Len == 2) {
            long a = (long)op1.digits[0] & 0xFFFFFFFFL;
            long b = (long)op2.digits[0] & 0xFFFFFFFFL;
            if (op1Sign == op2Sign) {
                long res = a + b;
                int valueLo = (int)res;
                int valueHi = (int)(res >>> 32);
                return valueHi == 0 ? new TBigInteger(op1Sign, valueLo) : new TBigInteger(op1Sign, 2, new int[]{valueLo, valueHi});
            }
            return TBigInteger.valueOf(op1Sign < 0 ? b - a : a - b);
        }
        if (op1Sign == op2Sign) {
            resSign = op1Sign;
            resDigits = op1Len >= op2Len ? TElementary.add(op1.digits, op1Len, op2.digits, op2Len) : TElementary.add(op2.digits, op2Len, op1.digits, op1Len);
        } else {
            int cmp;
            int n = op1Len != op2Len ? (op1Len > op2Len ? 1 : -1) : (cmp = TElementary.compareArrays(op1.digits, op2.digits, op1Len));
            if (cmp == 0) {
                return TBigInteger.ZERO;
            }
            if (cmp == 1) {
                resSign = op1Sign;
                resDigits = TElementary.subtract(op1.digits, op1Len, op2.digits, op2Len);
            } else {
                resSign = op2Sign;
                resDigits = TElementary.subtract(op2.digits, op2Len, op1.digits, op1Len);
            }
        }
        TBigInteger res = new TBigInteger(resSign, resDigits.length, resDigits);
        res.cutOffLeadingZeroes();
        return res;
    }

    private static void add(int[] res, int[] a, int aSize, int[] b, int bSize) {
        int i;
        long carry = ((long)a[0] & 0xFFFFFFFFL) + ((long)b[0] & 0xFFFFFFFFL);
        res[0] = (int)carry;
        carry >>= 32;
        if (aSize >= bSize) {
            for (i = 1; i < bSize; ++i) {
                res[i] = (int)(carry += ((long)a[i] & 0xFFFFFFFFL) + ((long)b[i] & 0xFFFFFFFFL));
                carry >>= 32;
            }
            while (i < aSize) {
                res[i] = (int)(carry += (long)a[i] & 0xFFFFFFFFL);
                carry >>= 32;
                ++i;
            }
        } else {
            for (i = 1; i < aSize; ++i) {
                res[i] = (int)(carry += ((long)a[i] & 0xFFFFFFFFL) + ((long)b[i] & 0xFFFFFFFFL));
                carry >>= 32;
            }
            while (i < bSize) {
                res[i] = (int)(carry += (long)b[i] & 0xFFFFFFFFL);
                carry >>= 32;
                ++i;
            }
        }
        if (carry != 0L) {
            res[i] = (int)carry;
        }
    }

    static TBigInteger subtract(TBigInteger op1, TBigInteger op2) {
        int[] resDigits;
        int resSign;
        int cmp;
        int op1Sign = op1.sign;
        int op2Sign = op2.sign;
        if (op2Sign == 0) {
            return op1;
        }
        if (op1Sign == 0) {
            return op2.negate();
        }
        int op1Len = op1.numberLength;
        int op2Len = op2.numberLength;
        if (op1Len + op2Len == 2) {
            long a = (long)op1.digits[0] & 0xFFFFFFFFL;
            long b = (long)op2.digits[0] & 0xFFFFFFFFL;
            if (op1Sign < 0) {
                a = -a;
            }
            if (op2Sign < 0) {
                b = -b;
            }
            return TBigInteger.valueOf(a - b);
        }
        int n = op1Len != op2Len ? (op1Len > op2Len ? 1 : -1) : (cmp = TElementary.compareArrays(op1.digits, op2.digits, op1Len));
        if (cmp == -1) {
            resSign = -op2Sign;
            resDigits = op1Sign == op2Sign ? TElementary.subtract(op2.digits, op2Len, op1.digits, op1Len) : TElementary.add(op2.digits, op2Len, op1.digits, op1Len);
        } else {
            resSign = op1Sign;
            if (op1Sign == op2Sign) {
                if (cmp == 0) {
                    return TBigInteger.ZERO;
                }
                resDigits = TElementary.subtract(op1.digits, op1Len, op2.digits, op2Len);
            } else {
                resDigits = TElementary.add(op1.digits, op1Len, op2.digits, op2Len);
            }
        }
        TBigInteger res = new TBigInteger(resSign, resDigits.length, resDigits);
        res.cutOffLeadingZeroes();
        return res;
    }

    private static void subtract(int[] res, int[] a, int aSize, int[] b, int bSize) {
        int i;
        long borrow = 0L;
        for (i = 0; i < bSize; ++i) {
            res[i] = (int)(borrow += ((long)a[i] & 0xFFFFFFFFL) - ((long)b[i] & 0xFFFFFFFFL));
            borrow >>= 32;
        }
        while (i < aSize) {
            res[i] = (int)(borrow += (long)a[i] & 0xFFFFFFFFL);
            borrow >>= 32;
            ++i;
        }
    }

    private static int[] add(int[] a, int aSize, int[] b, int bSize) {
        int[] res = new int[aSize + 1];
        TElementary.add(res, a, aSize, b, bSize);
        return res;
    }

    static void inplaceAdd(TBigInteger op1, TBigInteger op2) {
        TElementary.add(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
        op1.numberLength = Math.min(Math.max(op1.numberLength, op2.numberLength) + 1, op1.digits.length);
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    static int inplaceAdd(int[] a, int aSize, int addend) {
        long carry = (long)addend & 0xFFFFFFFFL;
        for (int i = 0; carry != 0L && i < aSize; carry >>= 32, ++i) {
            a[i] = (int)(carry += (long)a[i] & 0xFFFFFFFFL);
        }
        return (int)carry;
    }

    static void inplaceAdd(TBigInteger op1, int addend) {
        int carry = TElementary.inplaceAdd(op1.digits, op1.numberLength, addend);
        if (carry == 1) {
            op1.digits[op1.numberLength] = 1;
            ++op1.numberLength;
        }
        op1.unCache();
    }

    static void inplaceSubtract(TBigInteger op1, TBigInteger op2) {
        TElementary.subtract(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    private static void inverseSubtract(int[] res, int[] a, int aSize, int[] b, int bSize) {
        long borrow = 0L;
        if (aSize < bSize) {
            int i;
            for (i = 0; i < aSize; ++i) {
                res[i] = (int)(borrow += ((long)b[i] & 0xFFFFFFFFL) - ((long)a[i] & 0xFFFFFFFFL));
                borrow >>= 32;
            }
            while (i < bSize) {
                res[i] = (int)(borrow += (long)b[i] & 0xFFFFFFFFL);
                borrow >>= 32;
                ++i;
            }
        } else {
            int i;
            for (i = 0; i < bSize; ++i) {
                res[i] = (int)(borrow += ((long)b[i] & 0xFFFFFFFFL) - ((long)a[i] & 0xFFFFFFFFL));
                borrow >>= 32;
            }
            while (i < aSize) {
                res[i] = (int)(borrow -= (long)a[i] & 0xFFFFFFFFL);
                borrow >>= 32;
                ++i;
            }
        }
    }

    private static int[] subtract(int[] a, int aSize, int[] b, int bSize) {
        int[] res = new int[aSize];
        TElementary.subtract(res, a, aSize, b, bSize);
        return res;
    }

    static void completeInPlaceSubtract(TBigInteger op1, TBigInteger op2) {
        int resultSign = op1.compareTo(op2);
        if (op1.sign == 0) {
            System.arraycopy(op2.digits, 0, op1.digits, 0, op2.numberLength);
            op1.sign = -op2.sign;
        } else if (op1.sign != op2.sign) {
            TElementary.add(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
            op1.sign = resultSign;
        } else {
            int sign = TElementary.unsignedArraysCompare(op1.digits, op2.digits, op1.numberLength, op2.numberLength);
            if (sign > 0) {
                TElementary.subtract(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
            } else {
                TElementary.inverseSubtract(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
                op1.sign = -op1.sign;
            }
        }
        op1.numberLength = Math.max(op1.numberLength, op2.numberLength) + 1;
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    static void completeInPlaceAdd(TBigInteger op1, TBigInteger op2) {
        if (op1.sign == 0) {
            System.arraycopy(op2.digits, 0, op1.digits, 0, op2.numberLength);
        } else {
            if (op2.sign == 0) {
                return;
            }
            if (op1.sign == op2.sign) {
                TElementary.add(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
            } else {
                int sign = TElementary.unsignedArraysCompare(op1.digits, op2.digits, op1.numberLength, op2.numberLength);
                if (sign > 0) {
                    TElementary.subtract(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
                } else {
                    TElementary.inverseSubtract(op1.digits, op1.digits, op1.numberLength, op2.digits, op2.numberLength);
                    op1.sign = -op1.sign;
                }
            }
        }
        op1.numberLength = Math.max(op1.numberLength, op2.numberLength) + 1;
        op1.cutOffLeadingZeroes();
        op1.unCache();
    }

    private static int unsignedArraysCompare(int[] a, int[] b, int aSize, int bSize) {
        int i;
        if (aSize > bSize) {
            return 1;
        }
        if (aSize < bSize) {
            return -1;
        }
        for (i = aSize - 1; i >= 0 && a[i] == b[i]; --i) {
        }
        return i < 0 ? 0 : (((long)a[i] & 0xFFFFFFFFL) < ((long)b[i] & 0xFFFFFFFFL) ? -1 : 1);
    }

    private static void cpdEnd() {
    }
}

