/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio;

import com.antgroup.antchain.myjava.classlib.java.nio.TByteBufferImpl;
import com.antgroup.antchain.myjava.classlib.java.nio.TByteOrder;
import com.antgroup.antchain.myjava.classlib.java.nio.TDoubleBuffer;
import com.antgroup.antchain.myjava.classlib.java.nio.TDoubleBufferImpl;

class TDoubleBufferOverByteBuffer
extends TDoubleBufferImpl {
    private TByteBufferImpl byteByffer;
    TByteOrder byteOrder = TByteOrder.BIG_ENDIAN;
    boolean readOnly;
    private int start;

    private static void cpdBegin() {
    }

    public TDoubleBufferOverByteBuffer(int start, int capacity, TByteBufferImpl byteBuffer, int position, int limit, boolean readOnly) {
        super(capacity, position, limit);
        this.start = start;
        this.byteByffer = byteBuffer;
        this.readOnly = readOnly;
    }

    @Override
    TDoubleBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        TDoubleBufferOverByteBuffer result = new TDoubleBufferOverByteBuffer(this.start + start * 8, capacity, this.byteByffer, position, limit, readOnly);
        result.byteOrder = this.byteOrder;
        return result;
    }

    @Override
    double getElement(int index) {
        long value = this.byteOrder == TByteOrder.BIG_ENDIAN ? ((long)this.byteByffer.array[this.start + index * 8] & 0xFFL) << 56 | ((long)this.byteByffer.array[this.start + index * 8 + 1] & 0xFFL) << 48 | ((long)this.byteByffer.array[this.start + index * 8 + 2] & 0xFFL) << 40 | ((long)this.byteByffer.array[this.start + index * 8 + 3] & 0xFFL) << 32 | ((long)this.byteByffer.array[this.start + index * 8 + 4] & 0xFFL) << 24 | ((long)this.byteByffer.array[this.start + index * 8 + 5] & 0xFFL) << 16 | ((long)this.byteByffer.array[this.start + index * 8 + 6] & 0xFFL) << 8 | (long)(this.byteByffer.array[this.start + index * 8 + 7] & 0xFF) : (long)(this.byteByffer.array[this.start + index * 8] & 0xFF) | ((long)this.byteByffer.array[this.start + index * 8 + 1] & 0xFFL) << 8 | ((long)this.byteByffer.array[this.start + index * 8 + 2] & 0xFFL) << 16 | ((long)this.byteByffer.array[this.start + index * 8 + 3] & 0xFFL) << 24 | ((long)this.byteByffer.array[this.start + index * 8 + 4] & 0xFFL) << 32 | ((long)this.byteByffer.array[this.start + index * 8 + 5] & 0xFFL) << 40 | ((long)this.byteByffer.array[this.start + index * 8 + 6] & 0xFFL) << 48 | ((long)this.byteByffer.array[this.start + index * 8 + 7] & 0xFFL) << 56;
        return Double.longBitsToDouble(value);
    }

    @Override
    void putElement(int index, double d) {
        long value = Double.doubleToLongBits(d);
        if (this.byteOrder == TByteOrder.BIG_ENDIAN) {
            this.byteByffer.array[this.start + index * 8] = (byte)(value >> 56);
            this.byteByffer.array[this.start + index * 8 + 1] = (byte)(value >> 48);
            this.byteByffer.array[this.start + index * 8 + 2] = (byte)(value >> 40);
            this.byteByffer.array[this.start + index * 8 + 3] = (byte)(value >> 32);
            this.byteByffer.array[this.start + index * 8 + 4] = (byte)(value >> 24);
            this.byteByffer.array[this.start + index * 8 + 5] = (byte)(value >> 16);
            this.byteByffer.array[this.start + index * 8 + 6] = (byte)(value >> 8);
            this.byteByffer.array[this.start + index * 8 + 7] = (byte)value;
        } else {
            this.byteByffer.array[this.start + index * 8] = (byte)value;
            this.byteByffer.array[this.start + index * 8 + 1] = (byte)(value >> 8);
            this.byteByffer.array[this.start + index * 8 + 2] = (byte)(value >> 16);
            this.byteByffer.array[this.start + index * 8 + 3] = (byte)(value >> 24);
            this.byteByffer.array[this.start + index * 8 + 4] = (byte)(value >> 32);
            this.byteByffer.array[this.start + index * 8 + 5] = (byte)(value >> 40);
            this.byteByffer.array[this.start + index * 8 + 6] = (byte)(value >> 48);
            this.byteByffer.array[this.start + index * 8 + 7] = (byte)(value >> 56);
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    double[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public TByteOrder order() {
        return this.byteOrder;
    }

    private static void cpdEnd() {
    }
}

