/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.lang.TObject;
import com.antgroup.antchain.myjava.classlib.java.lang.TUnsupportedOperationException;
import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import java.lang.reflect.Array;

public abstract class TAbstractCollection<E>
extends TObject
implements TCollection<E> {
    protected TAbstractCollection() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e == null ? o == null : e.equals(o))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int i = 0;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            arr[i++] = iter.next();
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i;
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else {
            for (i = size; i < a.length; ++i) {
                a[i] = null;
            }
        }
        i = 0;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i++] = iter.next();
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new TUnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e == null ? o == null : e.equals(o))) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(TCollection<?> c) {
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(TCollection<? extends E> c) {
        boolean changed = false;
        TIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.add(iter.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(TCollection<?> c) {
        boolean changed = false;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!c.contains(e)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(TCollection<?> c) {
        boolean changed = false;
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (c.contains(e)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        TIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public String toString() {
        Object e;
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        TIterator iter = this.iterator();
        if (iter.hasNext()) {
            e = iter.next();
            sb.append((Object)(e == this ? "(this Collection)" : e));
        }
        while (iter.hasNext()) {
            e = iter.next();
            sb.append(", ").append((Object)(e == this ? "(this Collection)" : e));
        }
        sb.append(']');
        return sb.toString();
    }
}

