/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.nio.charset.impl;

import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCharset;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.TCoderResult;
import com.antgroup.antchain.myjava.classlib.java.nio.charset.impl.TBufferedEncoder;

public class TUTF16Encoder
extends TBufferedEncoder {
    private boolean bom;
    private boolean littleEndian;

    private static void cpdBegin() {
    }

    public TUTF16Encoder(TCharset cs, boolean bom, boolean littleEndian) {
        super(cs, 2.0f, 4.0f);
        this.bom = bom;
        this.littleEndian = littleEndian;
    }

    @Override
    protected TCoderResult arrayEncode(char[] inArray, int inPos, int inSize, byte[] outArray, int outPos, int outSize, TBufferedEncoder.Controller controller) {
        if (this.bom) {
            if (outPos + 2 > outSize) {
                return controller.hasMoreOutput() ? null : TCoderResult.OVERFLOW;
            }
            this.bom = false;
            if (this.littleEndian) {
                outArray[outPos++] = -1;
                outArray[outPos++] = -2;
            } else {
                outArray[outPos++] = -2;
                outArray[outPos++] = -1;
            }
        }
        return this.littleEndian ? this.arrayEncodeLE(inArray, inPos, inSize, outArray, outPos, outSize, controller) : this.arrayEncodeBE(inArray, inPos, inSize, outArray, outPos, outSize, controller);
    }

    private TCoderResult arrayEncodeLE(char[] inArray, int inPos, int inSize, byte[] outArray, int outPos, int outSize, TBufferedEncoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            char c;
            if (Character.isHighSurrogate(c = inArray[inPos++])) {
                char next;
                if (inPos == inSize) {
                    --inPos;
                    if (controller.hasMoreInput(2)) break;
                    result = TCoderResult.UNDERFLOW;
                    break;
                }
                if (Character.isLowSurrogate(next = inArray[inPos++])) {
                    if (outPos + 4 <= outSize) {
                        outArray[outPos++] = (byte)(c & 0xFF);
                        outArray[outPos++] = (byte)(c >> 8);
                        outArray[outPos++] = (byte)(next & 0xFF);
                        outArray[outPos++] = (byte)(next >> 8);
                        continue;
                    }
                    inPos -= 2;
                    if (controller.hasMoreOutput(4)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                inPos -= 2;
                result = TCoderResult.malformedForLength(1);
                break;
            }
            if (Character.isLowSurrogate(c)) {
                --inPos;
                result = TCoderResult.malformedForLength(1);
                break;
            }
            if (outPos + 2 <= outSize) {
                outArray[outPos++] = (byte)(c & 0xFF);
                outArray[outPos++] = (byte)(c >> 8);
                continue;
            }
            --inPos;
            if (controller.hasMoreOutput(2)) break;
            result = TCoderResult.OVERFLOW;
            break;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }

    private TCoderResult arrayEncodeBE(char[] inArray, int inPos, int inSize, byte[] outArray, int outPos, int outSize, TBufferedEncoder.Controller controller) {
        TCoderResult result = null;
        while (inPos < inSize && outPos < outSize) {
            char c;
            if (Character.isHighSurrogate(c = inArray[inPos++])) {
                char next;
                if (inPos == inSize) {
                    --inPos;
                    if (controller.hasMoreInput(2)) break;
                    result = TCoderResult.UNDERFLOW;
                    break;
                }
                if (Character.isLowSurrogate(next = inArray[inPos++])) {
                    if (outPos + 4 <= outSize) {
                        outArray[outPos++] = (byte)(c >> 8);
                        outArray[outPos++] = (byte)(c & 0xFF);
                        outArray[outPos++] = (byte)(next >> 8);
                        outArray[outPos++] = (byte)(next & 0xFF);
                        continue;
                    }
                    inPos -= 2;
                    if (controller.hasMoreOutput(4)) break;
                    result = TCoderResult.OVERFLOW;
                    break;
                }
                inPos -= 2;
                result = TCoderResult.malformedForLength(1);
                break;
            }
            if (Character.isLowSurrogate(c)) {
                --inPos;
                result = TCoderResult.malformedForLength(1);
                break;
            }
            if (outPos + 2 <= outSize) {
                outArray[outPos++] = (byte)(c >> 8);
                outArray[outPos++] = (byte)(c & 0xFF);
                continue;
            }
            --inPos;
            if (controller.hasMoreOutput(2)) break;
            result = TCoderResult.OVERFLOW;
            break;
        }
        controller.setInPosition(inPos);
        controller.setOutPosition(outPos);
        return result;
    }

    private static void cpdEnd() {
    }
}

