/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.TCalendar;
import com.antgroup.antchain.myjava.classlib.java.util.TDate;
import com.antgroup.antchain.myjava.classlib.java.util.TLocale;
import com.antgroup.antchain.myjava.classlib.java.util.TTimeZone;

public class TGregorianCalendar
extends TCalendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long defaultGregorianCutover = -12219292800000L;
    private long gregorianCutover = -12219292800000L;
    private transient int changeYear = 1582;
    private transient int julianSkew = (this.changeYear - 2000) / 400 + this.julianError() - (this.changeYear - 2000) / 100;
    static byte[] daysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] daysInYear = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static int[] maximums = new int[]{1, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
    private static int[] minimums = new int[]{0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
    private static int[] leastMaximums = new int[]{1, 292269054, 11, 50, 3, 28, 355, 7, 3, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
    private boolean isCached;
    private int[] cachedFields = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private long nextMidnightMillis;
    private long lastMidnightMillis;
    private int currentYearSkew = 10;
    private int lastYearSkew;

    public TGregorianCalendar() {
        this(TLocale.getDefault());
    }

    public TGregorianCalendar(int year, int month, int day) {
        this.set(year, month, day);
    }

    public TGregorianCalendar(int year, int month, int day, int hour, int minute) {
        this.set(year, month, day, hour, minute);
    }

    public TGregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        this.set(year, month, day, hour, minute, second);
    }

    TGregorianCalendar(long milliseconds) {
        this(false);
        this.setTimeInMillis(milliseconds);
    }

    public TGregorianCalendar(TLocale locale) {
        this(TTimeZone.getDefault(), locale);
    }

    public TGregorianCalendar(TTimeZone zone) {
        this(zone, TLocale.getDefault());
    }

    public TGregorianCalendar(TTimeZone timezone, TLocale locale) {
        super(timezone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    TGregorianCalendar(boolean ignored) {
        super(TTimeZone.getDefault());
        this.setFirstDayOfWeek(1);
        this.setMinimalDaysInFirstWeek(1);
    }

    @Override
    public void add(int field, int value) {
        if (value == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.isCached = false;
        if (field == 0) {
            this.complete();
            if (this.fields[0] == 1) {
                if (value >= 0) {
                    return;
                }
                this.set(0, 0);
            } else {
                if (value <= 0) {
                    return;
                }
                this.set(0, 1);
            }
            this.complete();
            return;
        }
        if (field == 1 || field == 2) {
            this.complete();
            if (field == 2) {
                int month = this.fields[2] + value;
                if (month < 0) {
                    value = (month - 11) / 12;
                    month = 12 + month % 12;
                } else {
                    value = month / 12;
                }
                this.set(2, month % 12);
            }
            this.set(1, this.fields[1] + value);
            int days = this.daysInMonth(this.isLeapYear(this.fields[1]), this.fields[2]);
            if (this.fields[5] > days) {
                this.set(5, days);
            }
            this.complete();
            return;
        }
        long multiplier = 0L;
        this.getTimeInMillis();
        switch (field) {
            case 14: {
                this.time += (long)value;
                break;
            }
            case 13: {
                this.time += (long)value * 1000L;
                break;
            }
            case 12: {
                this.time += (long)value * 60000L;
                break;
            }
            case 10: 
            case 11: {
                this.time += (long)value * 3600000L;
                break;
            }
            case 9: {
                multiplier = 43200000L;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                multiplier = 86400000L;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                multiplier = 604800000L;
            }
        }
        if (multiplier > 0L) {
            int offset = this.getTimeZoneOffset(this.time);
            this.time += (long)value * multiplier;
            int newOffset = this.getTimeZoneOffset(this.time);
            if (newOffset != offset) {
                this.time += (long)(offset - newOffset);
            }
        }
        this.areFieldsSet = false;
        this.complete();
    }

    @Override
    public Object clone() {
        TGregorianCalendar thisClone = (TGregorianCalendar)super.clone();
        thisClone.cachedFields = (int[])this.cachedFields.clone();
        return thisClone;
    }

    private void fullFieldsCalc(long timeVal, int millis, int zoneOffset) {
        int dayOfYear;
        long days = timeVal / 86400000L;
        if (millis < 0) {
            millis += 86400000;
            --days;
        }
        millis += zoneOffset;
        while (millis < 0) {
            millis += 86400000;
            --days;
        }
        while (millis >= 86400000) {
            millis -= 86400000;
            ++days;
        }
        this.fields[6] = dayOfYear = this.computeYearAndDay(days, timeVal + (long)zoneOffset);
        if (this.fields[1] == this.changeYear && this.gregorianCutover <= timeVal + (long)zoneOffset) {
            dayOfYear += this.currentYearSkew;
        }
        int month = dayOfYear / 32;
        boolean leapYear = this.isLeapYear(this.fields[1]);
        int date = dayOfYear - this.daysInYear(leapYear, month);
        if (date > this.daysInMonth(leapYear, month)) {
            date -= this.daysInMonth(leapYear, month);
            ++month;
        }
        this.fields[7] = this.mod7(days - 3L) + 1;
        int dstOffset = this.getTimeZoneOffset(timeVal);
        if (this.fields[1] > 0) {
            dstOffset -= zoneOffset;
        }
        this.fields[16] = dstOffset;
        if (dstOffset != 0) {
            long oldDays = days--;
            if ((millis += dstOffset) < 0) {
                millis += 86400000;
            } else if (millis >= 86400000) {
                millis -= 86400000;
                ++days;
            }
            if (oldDays != days) {
                this.fields[6] = dayOfYear = this.computeYearAndDay(days, timeVal - (long)zoneOffset + (long)dstOffset);
                if (this.fields[1] == this.changeYear && this.gregorianCutover <= timeVal - (long)zoneOffset + (long)dstOffset) {
                    dayOfYear += this.currentYearSkew;
                }
                month = dayOfYear / 32;
                leapYear = this.isLeapYear(this.fields[1]);
                date = dayOfYear - this.daysInYear(leapYear, month);
                if (date > this.daysInMonth(leapYear, month)) {
                    date -= this.daysInMonth(leapYear, month);
                    ++month;
                }
                this.fields[7] = this.mod7(days - 3L) + 1;
            }
        }
        this.fields[14] = millis % 1000;
        this.fields[13] = (millis /= 1000) % 60;
        this.fields[12] = (millis /= 60) % 60;
        this.fields[11] = (millis /= 60) % 24;
        this.fields[9] = this.fields[11] > 11 ? 1 : 0;
        this.fields[10] = this.fields[11] % 12;
        if (this.fields[1] <= 0) {
            this.fields[0] = 0;
            this.fields[1] = -this.fields[1] + 1;
        } else {
            this.fields[0] = 1;
        }
        this.fields[2] = month;
        this.fields[5] = date;
        this.fields[8] = (date - 1) / 7 + 1;
    }

    private void cachedFieldsCheckAndGet(long timeVal, long newTimeMillis, long newTimeMillisAdjusted, int millis, int zoneOffset) {
        int dstOffset = this.fields[16];
        if (!this.isCached || newTimeMillis >= this.nextMidnightMillis || newTimeMillis <= this.lastMidnightMillis || this.cachedFields[4] != zoneOffset || dstOffset == 0 && newTimeMillisAdjusted >= this.nextMidnightMillis || dstOffset != 0 && newTimeMillisAdjusted <= this.lastMidnightMillis) {
            this.fullFieldsCalc(timeVal, millis, zoneOffset);
            this.isCached = false;
        } else {
            this.fields[1] = this.cachedFields[0];
            this.fields[2] = this.cachedFields[1];
            this.fields[5] = this.cachedFields[2];
            this.fields[7] = this.cachedFields[3];
            this.fields[0] = this.cachedFields[5];
            this.fields[3] = this.cachedFields[6];
            this.fields[4] = this.cachedFields[7];
            this.fields[6] = this.cachedFields[8];
            this.fields[8] = this.cachedFields[9];
        }
    }

    int getTimeZoneOffset(long localTime) {
        return this.getTimeZone().getOffset(localTime);
    }

    @Override
    protected void computeFields() {
        int millis;
        int zoneOffset = this.getTimeZoneOffset(this.time);
        if (!this.isSet[15]) {
            this.fields[15] = zoneOffset;
        }
        int savedMillis = millis = (int)(this.time % 86400000L);
        int dstOffset = this.fields[16];
        int offset = zoneOffset + dstOffset;
        long newTime = this.time + (long)offset;
        if (this.time > 0L && newTime < 0L && offset > 0) {
            newTime = Long.MAX_VALUE;
        } else if (this.time < 0L && newTime > 0L && offset < 0) {
            newTime = Long.MIN_VALUE;
        }
        if (this.isCached) {
            if (millis < 0) {
                millis += 86400000;
            }
            millis += zoneOffset;
            if ((millis += dstOffset) < 0) {
                millis += 86400000;
            } else if (millis >= 86400000) {
                millis -= 86400000;
            }
            this.fields[14] = millis % 1000;
            this.fields[13] = (millis /= 1000) % 60;
            this.fields[12] = (millis /= 60) % 60;
            this.fields[11] = (millis /= 60) % 24;
            millis /= 24;
            this.fields[9] = this.fields[11] > 11 ? 1 : 0;
            this.fields[10] = this.fields[11] % 12;
            long newTimeAdjusted = newTime;
            if (newTime > 0L && newTimeAdjusted < 0L && dstOffset == 0) {
                newTimeAdjusted = Long.MAX_VALUE;
            } else if (newTime < 0L && newTimeAdjusted > 0L && dstOffset != 0) {
                newTimeAdjusted = Long.MIN_VALUE;
            }
            this.cachedFieldsCheckAndGet(this.time, newTime, newTimeAdjusted, savedMillis, zoneOffset);
        } else {
            this.fullFieldsCalc(this.time, savedMillis, zoneOffset);
        }
        for (int i = 0; i < 17; ++i) {
            this.isSet[i] = true;
        }
        if (!this.isCached && newTime != Long.MAX_VALUE && newTime != Long.MIN_VALUE) {
            int cacheMillis = 0;
            this.cachedFields[0] = this.fields[1];
            this.cachedFields[1] = this.fields[2];
            this.cachedFields[2] = this.fields[5];
            this.cachedFields[3] = this.fields[7];
            this.cachedFields[4] = zoneOffset;
            this.cachedFields[5] = this.fields[0];
            this.cachedFields[6] = this.fields[3];
            this.cachedFields[7] = this.fields[4];
            this.cachedFields[8] = this.fields[6];
            this.cachedFields[9] = this.fields[8];
            cacheMillis += (23 - this.fields[11]) * 60 * 60 * 1000;
            cacheMillis += (59 - this.fields[12]) * 60 * 1000;
            this.nextMidnightMillis = newTime + (long)(cacheMillis += (59 - this.fields[13]) * 1000);
            cacheMillis = this.fields[11] * 60 * 60 * 1000;
            cacheMillis += this.fields[12] * 60 * 1000;
            this.lastMidnightMillis = newTime - (long)(cacheMillis += this.fields[13] * 1000);
            this.isCached = true;
        }
    }

    @Override
    protected void computeTime() {
        long days;
        boolean useMonth;
        int year;
        if (!this.isLenient()) {
            if (this.isSet[11] ? this.fields[11] < 0 || this.fields[11] > 23 : this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[12] && (this.fields[12] < 0 || this.fields[12] > 59)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[13] && (this.fields[13] < 0 || this.fields[13] > 59)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[14] && (this.fields[14] < 0 || this.fields[14] > 999)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[3] && (this.fields[3] < 1 || this.fields[3] > 53)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[7] && (this.fields[7] < 1 || this.fields[7] > 7)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[8] && (this.fields[8] < 1 || this.fields[8] > 6)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[4] && (this.fields[4] < 1 || this.fields[4] > 6)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[9] && this.fields[9] != 0 && this.fields[9] != 1) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
                throw new IllegalArgumentException();
            }
            if (this.isSet[1]) {
                if (this.isSet[0] && this.fields[0] == 0 && (this.fields[1] < 1 || this.fields[1] > 292269054)) {
                    throw new IllegalArgumentException();
                }
                if (this.fields[1] < 1 || this.fields[1] > 292278994) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.isSet[2] && (this.fields[2] < 0 || this.fields[2] > 11)) {
                throw new IllegalArgumentException();
            }
        }
        long hour = 0L;
        if (this.isSet[11] && this.lastTimeFieldSet != 10) {
            hour = this.fields[11];
        } else if (this.isSet[10]) {
            hour = this.fields[9] * 12 + this.fields[10];
        }
        long timeVal = hour * 3600000L;
        if (this.isSet[12]) {
            timeVal += (long)this.fields[12] * 60000L;
        }
        if (this.isSet[13]) {
            timeVal += (long)this.fields[13] * 1000L;
        }
        if (this.isSet[14]) {
            timeVal += (long)this.fields[14];
        }
        int n = year = this.isSet[1] ? this.fields[1] : 1970;
        if (this.isSet[0]) {
            if (this.fields[0] != 0 && this.fields[0] != 1) {
                throw new IllegalArgumentException();
            }
            if (this.fields[0] == 0) {
                year = 1 - year;
            }
        }
        boolean weekMonthSet = this.isSet[4] || this.isSet[8];
        boolean bl = useMonth = (this.isSet[5] || this.isSet[2] || weekMonthSet) && this.lastDateFieldSet != 6;
        if (useMonth && (this.lastDateFieldSet == 7 || this.lastDateFieldSet == 3)) {
            if (this.isSet[3] && this.isSet[7]) {
                useMonth = this.lastDateFieldSet != 3 && weekMonthSet && this.isSet[7];
            } else if (this.isSet[6]) {
                boolean bl2 = useMonth = this.isSet[5] && this.isSet[2];
            }
        }
        if (useMonth) {
            int month = this.fields[2];
            year += month / 12;
            if ((month %= 12) < 0) {
                --year;
                month += 12;
            }
            boolean leapYear = this.isLeapYear(year);
            days = this.daysFromBaseYear(year) + (long)this.daysInYear(leapYear, month);
            boolean useDate = this.isSet[5];
            if (useDate && (this.lastDateFieldSet == 7 || this.lastDateFieldSet == 4 || this.lastDateFieldSet == 8)) {
                boolean bl3 = useDate = !this.isSet[7] || !weekMonthSet;
            }
            if (useDate) {
                if (!(this.isLenient() || this.fields[5] >= 1 && this.fields[5] <= this.daysInMonth(leapYear, month))) {
                    throw new IllegalArgumentException();
                }
                days += (long)(this.fields[5] - 1);
            } else {
                int dayOfWeek = this.isSet[7] ? this.fields[7] - 1 : this.getFirstDayOfWeek() - 1;
                if (this.isSet[4] && this.lastDateFieldSet != 8) {
                    int skew = this.mod7(days - 3L - (long)(this.getFirstDayOfWeek() - 1));
                    days += (long)((this.fields[4] - 1) * 7 + this.mod7((long)(skew + dayOfWeek) - (days - 2L)) - skew);
                } else if (this.isSet[8]) {
                    days = this.fields[8] >= 0 ? (days += (long)(this.mod7((long)dayOfWeek - (days - 3L)) + (this.fields[8] - 1) * 7)) : (days += (long)(this.daysInMonth(leapYear, month) + this.mod7((long)dayOfWeek - (days + (long)this.daysInMonth(leapYear, month) - 3L)) + this.fields[8] * 7));
                } else if (this.isSet[7]) {
                    int skew = this.mod7(days - 3L - (long)(this.getFirstDayOfWeek() - 1));
                    days += (long)this.mod7(this.mod7((long)(skew + dayOfWeek) - (days - 3L)) - skew);
                }
            }
        } else {
            boolean useWeekYear;
            boolean bl4 = useWeekYear = this.isSet[3] && this.lastDateFieldSet != 6;
            if (useWeekYear && this.isSet[6]) {
                useWeekYear = this.isSet[7];
            }
            days = this.daysFromBaseYear(year);
            if (useWeekYear) {
                int dayOfWeek = this.isSet[7] ? this.fields[7] - 1 : this.getFirstDayOfWeek() - 1;
                int skew = this.mod7(days - 3L - (long)(this.getFirstDayOfWeek() - 1));
                days += (long)((this.fields[3] - 1) * 7 + this.mod7((long)(skew + dayOfWeek) - (days - 3L)) - skew);
                if (7 - skew < this.getMinimalDaysInFirstWeek()) {
                    days += 7L;
                }
            } else if (this.isSet[6]) {
                if (!(this.isLenient() || this.fields[6] >= 1 && this.fields[6] <= 365 + (this.isLeapYear(year) ? 1 : 0))) {
                    throw new IllegalArgumentException();
                }
                days += (long)(this.fields[6] - 1);
            } else if (this.isSet[7]) {
                days += (long)this.mod7((long)(this.fields[7] - 1) - (days - 3L));
            }
        }
        this.lastDateFieldSet = 0;
        if (year == this.changeYear && (timeVal += days * 86400000L) >= this.gregorianCutover + (long)this.julianError() * 86400000L) {
            timeVal -= (long)this.julianError() * 86400000L;
        }
        this.time = timeVal - (long)this.getTimeZoneOffset(timeVal);
    }

    private int computeYearAndDay(long dayCount, long localTime) {
        int approxYears;
        int year = 1970;
        long days = dayCount;
        if (localTime < this.gregorianCutover) {
            days -= (long)this.julianSkew;
        }
        while ((approxYears = (int)(days / 365L)) != 0) {
            days = dayCount - this.daysFromBaseYear(year += approxYears);
        }
        if (days < 0L) {
            days += (long)this.daysInYear(--year);
        }
        this.fields[1] = year;
        return (int)days + 1;
    }

    private long daysFromBaseYear(int iyear) {
        long year = iyear;
        if (year >= 1970L) {
            long days = (year - 1970L) * 365L + (year - 1969L) / 4L;
            days = year > (long)this.changeYear ? (days -= (year - 1901L) / 100L - (year - 1601L) / 400L) : (year == (long)this.changeYear ? (days += (long)this.currentYearSkew) : (year == (long)(this.changeYear - 1) ? (days += (long)this.lastYearSkew) : (days += (long)this.julianSkew)));
            return days;
        }
        if (year <= (long)this.changeYear) {
            return (year - 1970L) * 365L + (year - 1972L) / 4L + (long)this.julianSkew;
        }
        return (year - 1970L) * 365L + (year - 1972L) / 4L - (year - 2000L) / 100L + (year - 2000L) / 400L;
    }

    private int daysInMonth() {
        return this.daysInMonth(this.isLeapYear(this.fields[1]), this.fields[2]);
    }

    private int daysInMonth(boolean leapYear, int month) {
        if (leapYear && month == 1) {
            return daysInMonth[month] + 1;
        }
        return daysInMonth[month];
    }

    private int daysInYear(int year) {
        int daysInYear;
        int n = daysInYear = this.isLeapYear(year) ? 366 : 365;
        if (year == this.changeYear) {
            daysInYear -= this.currentYearSkew;
        }
        if (year == this.changeYear - 1) {
            daysInYear -= this.lastYearSkew;
        }
        return daysInYear;
    }

    private int daysInYear(boolean leapYear, int month) {
        if (leapYear && month > 1) {
            return daysInYear[month] + 1;
        }
        return daysInYear[month];
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.gregorianCutover == ((TGregorianCalendar)object).gregorianCutover;
    }

    @Override
    public int getActualMaximum(int field) {
        int value = maximums[field];
        if (value == leastMaximums[field]) {
            return value;
        }
        switch (field) {
            case 3: 
            case 4: {
                this.isCached = false;
            }
        }
        this.complete();
        long orgTime = this.time;
        int result = 0;
        switch (field) {
            case 3: {
                this.set(5, 31);
                this.set(2, 11);
                result = this.get(3);
                if (result == 1) {
                    this.set(5, 24);
                    result = this.get(3);
                }
                this.areFieldsSet = false;
                break;
            }
            case 4: {
                this.set(5, this.daysInMonth());
                result = this.get(4);
                this.areFieldsSet = false;
                break;
            }
            case 5: {
                return this.daysInMonth();
            }
            case 6: {
                return this.daysInYear(this.fields[1]);
            }
            case 8: {
                result = this.get(8) + (this.daysInMonth() - this.get(5)) / 7;
                break;
            }
            case 1: {
                TGregorianCalendar clone = (TGregorianCalendar)this.clone();
                if (this.get(0) == 1) {
                    clone.setTimeInMillis(Long.MAX_VALUE);
                } else {
                    clone.setTimeInMillis(Long.MIN_VALUE);
                }
                result = clone.get(1);
                clone.set(1, this.get(1));
                if (!clone.before(this)) break;
                --result;
                break;
            }
            case 16: {
                result = this.getMaximum(16);
            }
        }
        this.time = orgTime;
        return result;
    }

    @Override
    public int getActualMinimum(int field) {
        return this.getMinimum(field);
    }

    @Override
    public int getGreatestMinimum(int field) {
        return minimums[field];
    }

    public final TDate getGregorianChange() {
        return new TDate(this.gregorianCutover);
    }

    @Override
    public int getLeastMaximum(int field) {
        if (this.gregorianCutover != -12219292800000L && field == 3) {
            long currentTimeInMillis = this.time;
            this.setTimeInMillis(this.gregorianCutover);
            int actual = this.getActualMaximum(field);
            this.setTimeInMillis(currentTimeInMillis);
            return actual;
        }
        return leastMaximums[field];
    }

    @Override
    public int getMaximum(int field) {
        return maximums[field];
    }

    @Override
    public int getMinimum(int field) {
        return minimums[field];
    }

    @Override
    public int hashCode() {
        return super.hashCode() + ((int)(this.gregorianCutover >>> 32) ^ (int)this.gregorianCutover);
    }

    public boolean isLeapYear(int year) {
        if (year > this.changeYear) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    private int julianError() {
        return this.changeYear / 100 - this.changeYear / 400 - 2;
    }

    private int mod(int value, int mod) {
        int rem = value % mod;
        if (value < 0 && rem < 0) {
            return rem + mod;
        }
        return rem;
    }

    private int mod7(long num1) {
        int rem = (int)(num1 % 7L);
        if (num1 < 0L && rem < 0) {
            return rem + 7;
        }
        return rem;
    }

    @Override
    public void roll(int field, int value) {
        if (value == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.isCached = false;
        this.complete();
        int max = -1;
        switch (field) {
            case 1: {
                max = maximums[field];
                break;
            }
            case 3: {
                int days = this.daysInYear(this.fields[1]);
                int day = 6;
                int mod = this.mod7(this.fields[7] - this.fields[day] - (this.getFirstDayOfWeek() - 1));
                int maxWeeks = (days - 1 + mod) / 7 + 1;
                int newWeek = this.mod(this.fields[field] - 1 + value, maxWeeks) + 1;
                if (newWeek == maxWeeks) {
                    int addDays = (newWeek - this.fields[field]) * 7;
                    if (this.fields[day] > addDays && this.fields[day] + addDays > days) {
                        this.set(field, 1);
                        break;
                    }
                    this.set(field, newWeek - 1);
                    break;
                }
                if (newWeek == 1) {
                    int week = (this.fields[day] - (this.fields[day] - 1) / 7 * 7 - 1 + mod) / 7 + 1;
                    if (week > 1) {
                        this.set(field, 1);
                        break;
                    }
                    this.set(field, newWeek);
                    break;
                }
                this.set(field, newWeek);
                break;
            }
            case 4: {
                int days = this.daysInMonth();
                int day = 5;
                int mod = this.mod7(this.fields[7] - this.fields[day] - (this.getFirstDayOfWeek() - 1));
                int maxWeeks = (days - 1 + mod) / 7 + 1;
                int newWeek = this.mod(this.fields[field] - 1 + value, maxWeeks) + 1;
                if (newWeek == maxWeeks) {
                    if (this.fields[day] + (newWeek - this.fields[field]) * 7 > days) {
                        this.set(day, days);
                        break;
                    }
                    this.set(field, newWeek);
                    break;
                }
                if (newWeek == 1) {
                    int week = (this.fields[day] - (this.fields[day] - 1) / 7 * 7 - 1 + mod) / 7 + 1;
                    if (week > 1) {
                        this.set(day, 1);
                        break;
                    }
                    this.set(field, newWeek);
                    break;
                }
                this.set(field, newWeek);
                break;
            }
            case 5: {
                max = this.daysInMonth();
                break;
            }
            case 6: {
                max = this.daysInYear(this.fields[1]);
                break;
            }
            case 7: {
                max = maximums[field];
                this.lastDateFieldSet = 4;
                break;
            }
            case 8: {
                max = (this.fields[5] + (this.daysInMonth() - this.fields[5]) / 7 * 7 - 1) / 7 + 1;
                break;
            }
            case 0: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.set(field, this.mod(this.fields[field] + value, maximums[field] + 1));
                if (field == 2 && this.fields[5] > this.daysInMonth()) {
                    this.set(5, this.daysInMonth());
                    break;
                }
                if (field != 9) break;
                this.lastTimeFieldSet = 10;
            }
        }
        if (max != -1) {
            this.set(field, this.mod(this.fields[field] - 1 + value, max) + 1);
        }
        this.complete();
    }

    @Override
    public void roll(int field, boolean increment) {
        this.roll(field, increment ? 1 : -1);
    }

    public void setGregorianChange(TDate date) {
        this.gregorianCutover = date.getTime();
        TGregorianCalendar cal = new TGregorianCalendar();
        cal.setTime(date);
        this.changeYear = cal.get(1);
        if (cal.get(0) == 0) {
            this.changeYear = 1 - this.changeYear;
        }
        this.julianSkew = (this.changeYear - 2000) / 400 + this.julianError() - (this.changeYear - 2000) / 100;
        this.isCached = false;
        int dayOfYear = cal.get(6);
        if (dayOfYear < this.julianSkew) {
            this.currentYearSkew = dayOfYear - 1;
            this.lastYearSkew = this.julianSkew - dayOfYear + 1;
        } else {
            this.lastYearSkew = 0;
            this.currentYearSkew = this.julianSkew;
        }
    }

    @Override
    public void setFirstDayOfWeek(int value) {
        super.setFirstDayOfWeek(value);
        this.isCached = false;
    }

    @Override
    public void setMinimalDaysInFirstWeek(int value) {
        super.setMinimalDaysInFirstWeek(value);
        this.isCached = false;
    }
}

