/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.TCollection;
import com.antgroup.antchain.myjava.classlib.java.util.TCollections;
import com.antgroup.antchain.myjava.classlib.java.util.TComparator;
import com.antgroup.antchain.myjava.classlib.java.util.TIterator;
import com.antgroup.antchain.myjava.classlib.java.util.TObjects;
import com.antgroup.antchain.myjava.classlib.java.util.TSet;
import com.antgroup.antchain.myjava.classlib.java.util.TTemplateCollections;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

@NoMetadata
public interface TMap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(Object var1);

    default public V getOrDefault(K key, V defaultValue) {
        return this.containsKey(key) ? this.get(key) : defaultValue;
    }

    public V put(K var1, V var2);

    public V remove(Object var1);

    default public boolean remove(Object key, Object value) {
        if (this.containsKey(key) && Objects.equals(this.get(key), value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public void putAll(TMap<? extends K, ? extends V> var1);

    public void clear();

    public TSet<K> keySet();

    public TCollection<V> values();

    public TSet<Entry<K, V>> entrySet();

    default public boolean replace(K key, V value, V newValue) {
        if (this.containsKey(key) && TObjects.equals(this.get(key), value)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    default public V replace(K key, V value) {
        if (this.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }

    default public V putIfAbsent(K key, V value) {
        V v = this.get(key);
        if (v == null) {
            v = this.put(key, value);
        }
        return v;
    }

    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V v = this.get(key);
        if (v == null) {
            V newValue = mappingFunction.apply(key);
            if (newValue != null) {
                this.put(key, newValue);
            }
            return newValue;
        }
        return v;
    }

    default public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V v = this.get(key);
        if (v != null) {
            V oldValue = v;
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                this.put(key, newValue);
            } else {
                this.remove(key);
            }
            return newValue;
        }
        return null;
    }

    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V oldValue = this.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (oldValue != null) {
            if (newValue != null) {
                this.put(key, newValue);
            } else {
                this.remove(key);
            }
        } else if (newValue != null) {
            this.put(key, newValue);
        }
        return newValue;
    }

    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        V oldValue = this.get(key);
        V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (newValue == null) {
            this.remove(key);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        TIterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V> TMap<K, V> of() {
        return TCollections.emptyMap();
    }

    public static <K, V> TMap<K, V> of(K k1, V v1) {
        return new TTemplateCollections.SingleEntryMap<K, V>(k1, v1);
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2) {
        return new TTemplateCollections.TwoEntriesMap<K, V>(k1, v1, k2, v2);
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4), TMap.entry(k5, v5));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4), TMap.entry(k5, v5), TMap.entry(k6, v6));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4), TMap.entry(k5, v5), TMap.entry(k6, v6), TMap.entry(k7, v7));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4), TMap.entry(k5, v5), TMap.entry(k6, v6), TMap.entry(k7, v7), TMap.entry(k8, v8));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4), TMap.entry(k5, v5), TMap.entry(k6, v6), TMap.entry(k7, v7), TMap.entry(k8, v8), TMap.entry(k9, v9));
    }

    public static <K, V> TMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return new TTemplateCollections.NEtriesMap(TMap.entry(k1, v1), TMap.entry(k2, v2), TMap.entry(k3, v3), TMap.entry(k4, v4), TMap.entry(k5, v5), TMap.entry(k6, v6), TMap.entry(k7, v7), TMap.entry(k8, v8), TMap.entry(k9, v9), TMap.entry(k10, v10));
    }

    @SafeVarargs
    public static <K, V> TMap<K, V> ofEntries(Entry<K, V> ... entries) {
        return new TTemplateCollections.NEtriesMap<K, V>(entries);
    }

    public static <K, V> Entry<K, V> entry(K k, V v) {
        return new TTemplateCollections.ImmutableEntry<K, V>(Objects.requireNonNull(k), Objects.requireNonNull(v));
    }

    @NoMetadata
    public static interface Entry<K1, V1> {
        public K1 getKey();

        public V1 getValue();

        public V1 setValue(V1 var1);

        public static <K extends Comparable<? super K>, V> TComparator<Entry<K, V>> comparingByKey() {
            return (a, b) -> ((Comparable)a.getKey()).compareTo(b.getKey());
        }

        public static <K, V extends Comparable<? super V>> TComparator<Entry<K, V>> comparingByValue() {
            return (a, b) -> ((Comparable)a.getValue()).compareTo(b.getValue());
        }

        public static <K, V> TComparator<Entry<K, V>> comparingByKey(TComparator<? super K> comp) {
            return (a, b) -> comp.compare((Object)a.getKey(), (Object)b.getKey());
        }

        public static <K, V> TComparator<Entry<K, V>> comparingByValue(TComparator<? super V> comp) {
            return (a, b) -> comp.compare((Object)a.getValue(), (Object)b.getValue());
        }
    }
}

