/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util;

import com.antgroup.antchain.myjava.classlib.java.util.TSpliterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public class TSpliterators {
    private TSpliterators() {
    }

    public static <T> TSpliterator<T> spliterator(final Object[] array, final int additionalCharacteristics) {
        return new TSpliterator<T>(){
            private int index;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.index >= array.length) {
                    return false;
                }
                Object e = array[this.index++];
                action.accept(e);
                return true;
            }

            @Override
            public TSpliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return array.length - this.index;
            }

            @Override
            public int characteristics() {
                return additionalCharacteristics | 0x40;
            }
        };
    }

    public static <T> TSpliterator<T> spliterator(Collection<? extends T> c, int characteristics) {
        return TSpliterators.spliterator(c.iterator(), (long)c.size(), characteristics);
    }

    public static TSpliterator.OfInt spliterator(int[] array, int additionalCharacteristics) {
        return TSpliterators.spliterator(array, 0, array.length, additionalCharacteristics);
    }

    public static TSpliterator.OfInt spliterator(final int[] array, final int fromIndex, final int toIndex, int additionalCharacteristics) {
        return new TSpliterator.OfInt(){
            int index;
            {
                this.index = fromIndex;
            }

            @Override
            public TSpliterator.OfInt trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (this.index < toIndex) {
                    action.accept(array[this.index++]);
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return toIndex - this.index;
            }

            @Override
            public int characteristics() {
                return 64;
            }
        };
    }

    public static <T> TSpliterator<T> spliterator(final Iterator<? extends T> iterator, final long size, final int characteristics) {
        return new TSpliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return size;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static <T> TSpliterator<T> spliteratorUnknownSize(final Iterator<? extends T> iterator, final int characteristics) {
        return new TSpliterator<T>(){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static TSpliterator.OfInt spliterator(final PrimitiveIterator.OfInt iterator, final long size, final int characteristics) {
        return new TSpliterator.OfInt(){

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator.OfInt trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return size;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static TSpliterator.OfInt spliteratorUnknownSize(final PrimitiveIterator.OfInt iterator, final int characteristics) {
        return new TSpliterator.OfInt(){

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator.OfInt trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static TSpliterator.OfLong spliterator(final PrimitiveIterator.OfLong iterator, final long size, final int characteristics) {
        return new TSpliterator.OfLong(){

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator.OfLong trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return size;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static TSpliterator.OfLong spliteratorUnknownSize(final PrimitiveIterator.OfLong iterator, final int characteristics) {
        return new TSpliterator.OfLong(){

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator.OfLong trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static TSpliterator.OfDouble spliterator(final PrimitiveIterator.OfDouble iterator, final long size, final int characteristics) {
        return new TSpliterator.OfDouble(){

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator.OfDouble trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return size;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }

    public static TSpliterator.OfDouble spliteratorUnknownSize(final PrimitiveIterator.OfDouble iterator, final int characteristics) {
        return new TSpliterator.OfDouble(){

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (iterator.hasNext()) {
                    action.accept(iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public TSpliterator.OfDouble trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return characteristics;
            }
        };
    }
}

