/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.classlib.java.util.regex;

import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractCharClass;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TAbstractSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TLeafSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplCharSet;
import com.antgroup.antchain.myjava.classlib.java.util.regex.TSupplRangeSet;

class TRangeSet
extends TLeafSet {
    private TAbstractCharClass chars;
    private boolean alt;

    public TRangeSet(TAbstractCharClass cs, TAbstractSet next) {
        super(next);
        this.chars = cs.getInstance();
        this.alt = cs.alt;
    }

    public TRangeSet(TAbstractCharClass cc) {
        this.chars = cc.getInstance();
        this.alt = cc.alt;
    }

    @Override
    public int accepts(int strIndex, CharSequence testString) {
        return this.chars.contains(testString.charAt(strIndex)) ? 1 : -1;
    }

    @Override
    protected String getName() {
        return "range:" + (this.alt ? "^ " : " ") + this.chars.toString();
    }

    @Override
    public boolean first(TAbstractSet set) {
        if (set instanceof TCharSet) {
            return TAbstractCharClass.intersects(this.chars, (int)((TCharSet)set).getChar());
        }
        if (set instanceof TRangeSet) {
            return TAbstractCharClass.intersects(this.chars, ((TRangeSet)set).chars);
        }
        if (set instanceof TSupplRangeSet) {
            return TAbstractCharClass.intersects(this.chars, ((TSupplRangeSet)set).getChars());
        }
        return !(set instanceof TSupplCharSet);
    }

    protected TAbstractCharClass getChars() {
        return this.chars;
    }
}

