/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerialContext;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

@NoMetadata
public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        List list = (List)object;
        if (list.size() == 0) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer.context;
        serializer.setContext(context, object, fieldName, 0);
        ObjectSerializer itemSerializer = null;
        try {
            out.append('[');
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object item = list.get(i);
                if (i != 0) {
                    out.append(',');
                }
                if (item == null) {
                    out.append("null");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeInt((Integer)item);
                    continue;
                }
                if (clazz == Long.class) {
                    long val = (Long)item;
                    out.writeLong(val);
                    continue;
                }
                if ((SerializerFeature.DisableCircularReferenceDetect.mask & features) != 0) {
                    itemSerializer = serializer.getObjectWriter(item.getClass());
                    itemSerializer.write(serializer, item, i, null, features);
                    continue;
                }
                if (!out.disableCircularReferenceDetect) {
                    SerialContext itemContext;
                    serializer.context = itemContext = new SerialContext(context, object, fieldName, 0, 0);
                }
                if (serializer.containsReference(item)) {
                    serializer.writeReference(item);
                    continue;
                }
                itemSerializer = serializer.getObjectWriter(item.getClass());
                itemSerializer.write(serializer, item, i, null, features);
            }
            out.append(']');
        }
        finally {
            serializer.context = context;
        }
    }
}

