/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

@NoMetadata
public class LongCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static LongCodec instance = new LongCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            long value = (Long)object;
            out.writeLong(value);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Long longObject;
        JSONScanner lexer = parser.lexer;
        try {
            int token = lexer.token();
            if (token == 2) {
                long longValue = lexer.longValue();
                lexer.nextToken(16);
                longObject = longValue;
            } else if (token == 3) {
                BigDecimal number = lexer.decimalValue();
                longObject = TypeUtils.longValue(number);
                lexer.nextToken(16);
            } else {
                if (token == 12) {
                    JSONObject jsonObject = new JSONObject();
                    parser.parseObject(jsonObject);
                    longObject = TypeUtils.castToLong(jsonObject);
                } else {
                    Object value = parser.parse();
                    longObject = TypeUtils.castToLong(value);
                }
                if (longObject == null) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            throw new JSONException("parseLong error, field : " + fieldName, ex);
        }
        return (T)longObject;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

