/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.util;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.PropertyNamingStrategy;
import com.antgroup.antchain.myjson.annotation.JSONField;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.FieldInfo;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@NoMetadata
public class JavaBeanInfo {
    public final Class<?> clazz;
    public final Class<?> builderClass;
    public final Constructor<?> defaultConstructor;
    public final Constructor<?> creatorConstructor;
    public final Method factoryMethod;
    public final Method buildMethod;
    public final int defaultConstructorParameterSize;
    public final FieldInfo[] fields;
    public final FieldInfo[] sortedFields;
    public final int parserFeatures;
    public final String typeName;
    public final String typeKey;
    public String[] orders;
    public Type[] creatorConstructorParameterTypes;
    public String[] creatorConstructorParameters;

    public JavaBeanInfo(Class<?> clazz, Class<?> builderClass, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, Method buildMethod, List<FieldInfo> fieldList) {
        this.clazz = clazz;
        this.builderClass = builderClass;
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.parserFeatures = 0;
        this.buildMethod = buildMethod;
        this.typeName = clazz.getName();
        this.typeKey = null;
        this.orders = null;
        this.fields = new FieldInfo[fieldList.size()];
        fieldList.toArray(this.fields);
        Object[] sortedFields = new FieldInfo[this.fields.length];
        System.arraycopy(this.fields, 0, sortedFields, 0, this.fields.length);
        Arrays.sort(sortedFields);
        if (Arrays.equals(this.fields, sortedFields)) {
            sortedFields = this.fields;
        }
        this.sortedFields = sortedFields;
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : (factoryMethod != null ? factoryMethod.getParameterTypes().length : 0);
        if (creatorConstructor != null) {
            boolean match;
            this.creatorConstructorParameterTypes = creatorConstructor.getParameterTypes();
            if (this.creatorConstructorParameterTypes.length != this.fields.length) {
                match = false;
            } else {
                match = true;
                for (int i = 0; i < this.creatorConstructorParameterTypes.length; ++i) {
                    if (this.creatorConstructorParameterTypes[i] == this.fields[i].fieldClass) continue;
                    match = false;
                    break;
                }
            }
            if (!match) {
                throw new NullPointerException();
            }
        }
    }

    private static FieldInfo getField(List<FieldInfo> fieldList, String propertyName) {
        for (FieldInfo item : fieldList) {
            if (item.name.equals(propertyName)) {
                return item;
            }
            Field field = item.field;
            if (field == null || item.getAnnotation() == null || !field.getName().equals(propertyName)) continue;
            return item;
        }
        return null;
    }

    static boolean add(List<FieldInfo> fieldList, FieldInfo field) {
        for (int i = fieldList.size() - 1; i >= 0; --i) {
            FieldInfo item = fieldList.get(i);
            if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
            if (item.fieldClass.isAssignableFrom(field.fieldClass)) {
                fieldList.set(i, field);
                return true;
            }
            int result = item.compareTo(field);
            if (result < 0) {
                fieldList.set(i, field);
                return true;
            }
            return false;
        }
        fieldList.add(field);
        return true;
    }

    private static Map<TypeVariable, Type> buildGenericInfo(Class<?> clazz) {
        Class<?> childClass = clazz;
        Class<?> currentClass = clazz.getSuperclass();
        if (currentClass == null) {
            return null;
        }
        HashMap typeVarMap = null;
        while (currentClass != null && currentClass != Object.class) {
            if (childClass.getGenericSuperclass() instanceof ParameterizedType) {
                Type[] childGenericParentActualTypeArgs = ((ParameterizedType)childClass.getGenericSuperclass()).getActualTypeArguments();
                TypeVariable<Class<?>>[] currentTypeParameters = currentClass.getTypeParameters();
                for (int i = 0; i < childGenericParentActualTypeArgs.length; ++i) {
                    if (typeVarMap == null) {
                        typeVarMap = new HashMap();
                    }
                    if (typeVarMap.containsKey(childGenericParentActualTypeArgs[i])) {
                        Type actualArg = (Type)typeVarMap.get(childGenericParentActualTypeArgs[i]);
                        typeVarMap.put(currentTypeParameters[i], actualArg);
                        continue;
                    }
                    typeVarMap.put(currentTypeParameters[i], childGenericParentActualTypeArgs[i]);
                }
            }
            childClass = currentClass;
            currentClass = currentClass.getSuperclass();
        }
        return typeVarMap;
    }

    public static JavaBeanInfo build(Class<?> clazz, Type type, PropertyNamingStrategy propertyNamingStrategy) {
        Class builderClass = null;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> defaultConstructor = null;
        defaultConstructor = builderClass == null ? JavaBeanInfo.getDefaultConstructor(clazz, constructors) : JavaBeanInfo.getDefaultConstructor(builderClass, builderClass.getDeclaredConstructors());
        Method buildMethod = null;
        Method factoryMethod = null;
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields = currentClass.getDeclaredFields();
            JavaBeanInfo.computeFields(clazz, type, propertyNamingStrategy, fieldList, fields);
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(defaultConstructor);
        }
        return new JavaBeanInfo(clazz, builderClass, defaultConstructor, null, factoryMethod, buildMethod, fieldList);
    }

    private static void computeFields(Class<?> clazz, Type type, PropertyNamingStrategy propertyNamingStrategy, List<FieldInfo> fieldList, Field[] fields) {
        Map<TypeVariable, Type> genericInfo = JavaBeanInfo.buildGenericInfo(clazz);
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if ((modifiers & 8) != 0) continue;
            if ((modifiers & 0x10) != 0) {
                boolean supportReadOnly;
                Class<?> fieldType = field.getType();
                boolean bl = supportReadOnly = Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType);
                if (!supportReadOnly) continue;
            }
            boolean contains = false;
            for (FieldInfo item : fieldList) {
                if (!item.name.equals(field.getName())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String propertyName = field.getName();
            JSONField fieldAnnotation = TypeUtils.getAnnotation(field, JSONField.class);
            if (fieldAnnotation != null) {
                if (!fieldAnnotation.deserialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            JavaBeanInfo.add(fieldList, new FieldInfo(propertyName, null, field, clazz, type, ordinal, serialzeFeatures, null, fieldAnnotation, null, genericInfo));
        }
    }

    static Constructor<?> getDefaultConstructor(Class<?> clazz, Constructor<?>[] constructors) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            for (Constructor<?> constructor : constructors) {
                Class<?>[] types = constructor.getParameterTypes();
                if (types.length != 1 || !types[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }
}

