/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.parser;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONArray;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.JSONRegister;
import com.antgroup.antchain.myjson.PropertyNamingStrategy;
import com.antgroup.antchain.myjson.TypeReference;
import com.antgroup.antchain.myjson.parser.SymbolTable;
import com.antgroup.antchain.myjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.DefaultFieldDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.FieldDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.JavaBeanDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.JavaObjectDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.MapDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.NumberDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.BigDecimalCodec;
import com.antgroup.antchain.myjson.serializer.BigIntegerCodec;
import com.antgroup.antchain.myjson.serializer.BooleanCodec;
import com.antgroup.antchain.myjson.serializer.CharArrayCodec;
import com.antgroup.antchain.myjson.serializer.CharacterCodec;
import com.antgroup.antchain.myjson.serializer.CollectionCodec;
import com.antgroup.antchain.myjson.serializer.FloatCodec;
import com.antgroup.antchain.myjson.serializer.IntegerCodec;
import com.antgroup.antchain.myjson.serializer.LongCodec;
import com.antgroup.antchain.myjson.serializer.MiscCodec;
import com.antgroup.antchain.myjson.serializer.ObjectArrayCodec;
import com.antgroup.antchain.myjson.serializer.StringCodec;
import com.antgroup.antchain.myjson.util.FieldInfo;
import com.antgroup.antchain.myjson.util.JavaBeanInfo;
import com.antgroup.antchain.myjson.util.ParameterizedTypeImpl;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NoMetadata
public class ParserConfig {
    public static ParserConfig global = new ParserConfig();
    private final Map<String, ObjectDeserializer> deserializers = new HashMap<String, ObjectDeserializer>();
    private final Map<String, Class<?>> typeMapping = new HashMap(16);
    public final SymbolTable symbolTable = new SymbolTable(4096);
    public PropertyNamingStrategy propertyNamingStrategy;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    private ParserConfig() {
        this.initDeserializers();
    }

    private void initDeserializers() {
        this.putDeserializer((Type)((Object)JSONObject.class), MapDeserializer.instance);
        this.putDeserializer((Type)((Object)JSONArray.class), CollectionCodec.instance);
        this.putDeserializer((Type)((Object)Map.class), MapDeserializer.instance);
        this.putDeserializer((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.putDeserializer((Type)((Object)Collection.class), CollectionCodec.instance);
        this.putDeserializer((Type)((Object)List.class), CollectionCodec.instance);
        this.putDeserializer((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.putDeserializer((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.putDeserializer((Type)((Object)String.class), StringCodec.instance);
        this.putDeserializer(Character.TYPE, CharacterCodec.instance);
        this.putDeserializer((Type)((Object)Character.class), CharacterCodec.instance);
        this.putDeserializer(Byte.TYPE, NumberDeserializer.instance);
        this.putDeserializer((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.putDeserializer(Short.TYPE, NumberDeserializer.instance);
        this.putDeserializer((Type)((Object)Short.class), NumberDeserializer.instance);
        this.putDeserializer(Integer.TYPE, IntegerCodec.instance);
        this.putDeserializer((Type)((Object)Integer.class), IntegerCodec.instance);
        this.putDeserializer(Long.TYPE, LongCodec.instance);
        this.putDeserializer((Type)((Object)Long.class), LongCodec.instance);
        this.putDeserializer((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.putDeserializer((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.putDeserializer(Float.TYPE, FloatCodec.instance);
        this.putDeserializer((Type)((Object)Float.class), FloatCodec.instance);
        this.putDeserializer(Double.TYPE, NumberDeserializer.instance);
        this.putDeserializer((Type)((Object)Double.class), NumberDeserializer.instance);
        this.putDeserializer(Boolean.TYPE, BooleanCodec.instance);
        this.putDeserializer((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.putDeserializer((Type)((Object)Class.class), MiscCodec.instance);
        this.putDeserializer((Type)((Object)char[].class), new CharArrayCodec());
        this.putDeserializer((Type)((Object)Number.class), NumberDeserializer.instance);
        this.putDeserializer((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
    }

    public Map<String, ObjectDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        WildcardType wildcardType;
        Type[] upperBounds;
        ObjectDeserializer deserializer = this.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        if (type instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)type).getUpperBounds()).length == 1) {
            Type upperBoundType = upperBounds[0];
            return this.getDeserializer(upperBoundType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        ObjectDeserializer deserializer = this.get(type);
        if (deserializer == null && type instanceof ParameterizedTypeImpl) {
            Type innerType = TypeReference.intern((ParameterizedTypeImpl)((Object)type));
            deserializer = this.get(innerType);
        }
        if (deserializer != null) {
            return deserializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((deserializer = this.get(type)) != null) {
            return deserializer;
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            deserializer = this.get(clazz);
        }
        if (deserializer != null) {
            return deserializer;
        }
        String className = clazz.getName();
        className = className.replace('$', '.');
        if (clazz == Map.Entry.class) {
            deserializer = MiscCodec.instance;
            this.putDeserializer(clazz, deserializer);
        }
        JSONRegister.registerClass(clazz);
        if (deserializer == null) {
            deserializer = this.get(type);
        }
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = clazz.isArray() ? ObjectArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : this.createJavaBeanDeserializer(clazz, type))));
        this.putDeserializer(type, deserializer);
        return deserializer;
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        return new JavaBeanDeserializer(this, clazz, type);
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, JavaBeanInfo beanInfo, FieldInfo fieldInfo) {
        Class<?> clazz = beanInfo.clazz;
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.putDeserializerByTypeName(type.getTypeName(), deserializer);
    }

    public void putDeserializerByTypeName(String typeName, ObjectDeserializer deserializer) {
        this.deserializers.put(typeName, deserializer);
    }

    public ObjectDeserializer get(Type type) {
        return this.deserializers.get(type.getTypeName());
    }

    public boolean isPrimitive(Class<?> clazz) {
        return ParserConfig.isPrimitive2(clazz);
    }

    public static boolean isPrimitive2(Class<?> clazz) {
        Boolean primitive = clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz.isEnum();
        return primitive != null ? primitive : false;
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> fieldCacheMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (fieldCacheMap.containsKey(fieldName)) continue;
            fieldCacheMap.put(fieldName, field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            ParserConfig.parserAllFieldToCache(clazz.getSuperclass(), fieldCacheMap);
        }
    }

    public static Field getFieldFromCache(String fieldName, Map<String, Field> fieldCacheMap) {
        Field field = fieldCacheMap.get(fieldName);
        if (field == null) {
            field = fieldCacheMap.get("_" + fieldName);
        }
        if (field == null) {
            field = fieldCacheMap.get("m_" + fieldName);
        }
        if (field == null) {
            char c0 = fieldName.charAt(0);
            if (c0 >= 'a' && c0 <= 'z') {
                char[] chars = fieldName.toCharArray();
                chars[0] = (char)(chars[0] - 32);
                String fieldNameX = new String(chars);
                field = fieldCacheMap.get(fieldNameX);
            }
            if (fieldName.length() > 2) {
                char c1 = fieldName.charAt(1);
                if (c0 >= 'a' && c0 <= 'z' && c1 >= 'A' && c1 <= 'Z') {
                    for (Map.Entry<String, Field> entry : fieldCacheMap.entrySet()) {
                        if (!fieldName.equalsIgnoreCase(entry.getKey())) continue;
                        field = entry.getValue();
                        break;
                    }
                }
            }
        }
        return field;
    }

    public void clearDeserializers() {
        this.deserializers.clear();
        this.initDeserializers();
    }

    public void register(String typeName, Class type) {
        this.typeMapping.putIfAbsent(typeName, type);
    }
}

