/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.parser.deserializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSON;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.JSONValidator;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.Feature;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.JSONToken;
import com.antgroup.antchain.myjson.parser.ParseContext;
import com.antgroup.antchain.myjson.parser.ParserConfig;
import com.antgroup.antchain.myjson.parser.deserializer.FieldDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.util.FieldInfo;
import com.antgroup.antchain.myjson.util.JavaBeanInfo;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@NoMetadata
public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final FieldDeserializer[] fieldDeserializers;
    protected final FieldDeserializer[] sortedFieldDeserializers;
    protected final Class<?> clazz;
    public final JavaBeanInfo beanInfo;
    private final Map<String, FieldDeserializer> alterNameFieldDeserializers;
    private final Map<String, FieldDeserializer> fieldDeserializerMap;

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) {
        this(config, JavaBeanInfo.build(clazz, type, config.propertyNamingStrategy));
    }

    public JavaBeanDeserializer(ParserConfig config, JavaBeanInfo beanInfo) {
        FieldDeserializer fieldDeserializer;
        this.clazz = beanInfo.clazz;
        this.beanInfo = beanInfo;
        Object alterNameFieldDeserializers = null;
        this.sortedFieldDeserializers = new FieldDeserializer[beanInfo.sortedFields.length];
        this.fieldDeserializerMap = new HashMap<String, FieldDeserializer>();
        for (FieldInfo fieldInfo : beanInfo.sortedFields) {
            this.sortedFieldDeserializers[i] = fieldDeserializer = config.createFieldDeserializer(config, beanInfo, fieldInfo);
            this.fieldDeserializerMap.put(fieldInfo.name, fieldDeserializer);
        }
        this.alterNameFieldDeserializers = alterNameFieldDeserializers;
        this.fieldDeserializers = new FieldDeserializer[beanInfo.fields.length];
        for (FieldInfo fieldInfo : beanInfo.fields) {
            this.fieldDeserializers[i] = fieldDeserializer = this.getFieldDeserializer(fieldInfo.name);
        }
    }

    public FieldDeserializer getFieldDeserializer(String key) {
        return this.getFieldDeserializer(key, null);
    }

    public FieldDeserializer getFieldDeserializer(String key, int[] setFlags) {
        FieldDeserializer fieldDeserializer;
        if (key == null) {
            return null;
        }
        if (this.fieldDeserializerMap != null && (fieldDeserializer = this.fieldDeserializerMap.get(key)) != null) {
            return fieldDeserializer;
        }
        int low = 0;
        int high = this.sortedFieldDeserializers.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedFieldDeserializers[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (JavaBeanDeserializer.isSetFlag(mid, setFlags)) {
                return null;
            }
            return this.sortedFieldDeserializers[mid];
        }
        if (this.alterNameFieldDeserializers != null) {
            return this.alterNameFieldDeserializers.get(key);
        }
        return null;
    }

    static boolean isSetFlag(int i, int[] setFlags) {
        if (setFlags == null) {
            return false;
        }
        int flagIndex = i / 32;
        return flagIndex < setFlags.length && (setFlags[flagIndex] & 1 << i % 32) != 0;
    }

    public Object createInstance(DefaultJSONParser parser, Type type) {
        Object object;
        if (type instanceof Class && this.clazz.isInterface()) {
            throw new JSONException("can't parse json to interface in myjson");
        }
        if (this.beanInfo.defaultConstructor == null && this.beanInfo.factoryMethod == null) {
            throw new JSONException("can't find default constructor of bean class " + this.clazz.getName());
        }
        if (this.beanInfo.factoryMethod != null && this.beanInfo.defaultConstructorParameterSize > 0) {
            throw new JSONException("can't find default constructor of bean class " + this.clazz.getName());
        }
        try {
            Constructor<?> constructor = this.beanInfo.defaultConstructor;
            if (this.beanInfo.defaultConstructorParameterSize == 0) {
                object = constructor != null ? constructor.newInstance(new Object[0]) : this.beanInfo.factoryMethod.invoke(null, new Object[0]);
            } else {
                ParseContext context = parser.getContext();
                if (context == null || context.object == null) {
                    throw new JSONException("can't create non-static inner class instance.");
                }
                if (!(type instanceof Class)) {
                    throw new JSONException("can't create non-static inner class instance.");
                }
                String typeName = ((Class)type).getName();
                int lastIndex = typeName.lastIndexOf(36);
                String parentClassName = typeName.substring(0, lastIndex);
                Object ctxObj = context.object;
                String parentName = ctxObj.getClass().getName();
                Object param = null;
                if (!parentName.equals(parentClassName)) {
                    ParseContext parentContext = context.parent;
                    if (parentContext != null && parentContext.object != null && ("java.util.ArrayList".equals(parentName) || "java.util.List".equals(parentName) || "java.util.Collection".equals(parentName) || "java.util.Map".equals(parentName) || "java.util.HashMap".equals(parentName))) {
                        parentName = parentContext.object.getClass().getName();
                        if (parentName.equals(parentClassName)) {
                            param = parentContext.object;
                        }
                    } else {
                        param = ctxObj;
                    }
                } else {
                    param = ctxObj;
                }
                if (param == null || param instanceof Collection && ((Collection)param).isEmpty()) {
                    throw new JSONException("can't create non-static inner class instance.");
                }
                object = constructor.newInstance(param);
            }
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return this.deserialze(parser, type, fieldName, 0);
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, int features) {
        return this.deserialze(parser, type, fieldName, null, features, null);
    }

    protected void check(JSONScanner lexer, int token) {
        if (lexer.token() != token) {
            throw new JSONException("syntax error");
        }
    }

    protected Enum<?> scanEnum(JSONScanner lexer, char seperator) {
        throw new JSONException("illegal enum. " + lexer.info());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, Object object, int features, int[] setFlags) {
        if (type == JSON.class || type == JSONObject.class) {
            return (T)parser.parse();
        }
        lexer = parser.lexer;
        config = parser.getConfig();
        token = lexer.token();
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        context = parser.getContext();
        if (object != null && context != null) {
            context = context.parent;
        }
        childContext = null;
        try {
            block100: {
                block99: {
                    fieldValues = null;
                    if (token == 13) {
                        lexer.nextToken(16);
                        if (object == null) {
                            object = this.createInstance(parser, type);
                        }
                        var13_13 = object;
                        return (T)var13_13;
                    }
                    if (token == 12 || token == 16) break block100;
                    if (lexer.isBlankInput()) {
                        var13_14 = null;
                        return var13_14;
                    }
                    if (token == 4 && (strVal = lexer.stringVal()).length() == 0) {
                        lexer.nextToken();
                        var14_21 = null;
                        return var14_21;
                    }
                    if (token == 14 && lexer.getCurrent() == ']') {
                        lexer.next();
                        lexer.nextToken();
                        strVal = null;
                        return (T)strVal;
                    }
                    if (this.beanInfo.factoryMethod != null && this.beanInfo.fields.length == 1) {
                        block98: {
                            try {
                                field = this.beanInfo.fields[0];
                                if (field.fieldClass != Integer.class) break block98;
                                if (token != 2) break block99;
                                intValue = lexer.intValue();
                                lexer.nextToken();
                                var15_28 = this.createFactoryInstance(config, intValue);
                            }
                            catch (Exception ex) {
                                throw new JSONException(ex.getMessage(), ex);
                            }
                            return (T)var15_28;
                        }
                        if (field.fieldClass == String.class && token == 4) {
                            stringVal = lexer.stringVal();
                            lexer.nextToken();
                            var15_29 = this.createFactoryInstance(config, stringVal);
                            return (T)var15_29;
                        }
                    }
                }
                buf = new StringBuilder().append("syntax error, expect {, actual ").append(lexer.tokenName()).append(", pos ").append(lexer.pos());
                if (fieldName instanceof String) {
                    buf.append(", fieldName ").append(fieldName);
                }
                buf.append(", fastjson-version ").append("1.2.76");
                throw new JSONException(buf.toString());
            }
            if (parser.resolveStatus == 2) {
                parser.resolveStatus = 0;
            }
            fieldIndex = 0;
            notMatchCount = 0;
            while (true) {
                block104: {
                    block127: {
                        block125: {
                            block126: {
                                block101: {
                                    block123: {
                                        block124: {
                                            block121: {
                                                block122: {
                                                    block119: {
                                                        block120: {
                                                            block117: {
                                                                block118: {
                                                                    block115: {
                                                                        block116: {
                                                                            block113: {
                                                                                block114: {
                                                                                    block111: {
                                                                                        block112: {
                                                                                            block109: {
                                                                                                block110: {
                                                                                                    block107: {
                                                                                                        block108: {
                                                                                                            block105: {
                                                                                                                block106: {
                                                                                                                    block102: {
                                                                                                                        block103: {
                                                                                                                            key = null;
                                                                                                                            fieldDeserializer = null;
                                                                                                                            fieldInfo = null;
                                                                                                                            fieldClass = null;
                                                                                                                            if (fieldIndex < this.sortedFieldDeserializers.length && notMatchCount < 16) {
                                                                                                                                fieldDeserializer = this.sortedFieldDeserializers[fieldIndex];
                                                                                                                                fieldInfo = fieldDeserializer.fieldInfo;
                                                                                                                                fieldClass = fieldInfo.fieldClass;
                                                                                                                            }
                                                                                                                            matchField = false;
                                                                                                                            valueParsed = false;
                                                                                                                            fieldValue = null;
                                                                                                                            if (fieldDeserializer == null) break block101;
                                                                                                                            name_chars = fieldInfo.name_chars;
                                                                                                                            if (fieldClass != Integer.TYPE && fieldClass != Integer.class) break block102;
                                                                                                                            intVal = lexer.scanFieldInt(name_chars);
                                                                                                                            fieldValue = intVal == 0 && lexer.matchStat == 5 ? null : Integer.valueOf(intVal);
                                                                                                                            if (lexer.matchStat <= 0) break block103;
                                                                                                                            matchField = true;
                                                                                                                            valueParsed = true;
                                                                                                                            break block101;
                                                                                                                        }
                                                                                                                        if (lexer.matchStat != -2) break block101;
                                                                                                                        ++notMatchCount;
                                                                                                                        break block104;
                                                                                                                    }
                                                                                                                    if (fieldClass != Long.TYPE && fieldClass != Long.class) break block105;
                                                                                                                    longVal = lexer.scanFieldLong(name_chars);
                                                                                                                    fieldValue = longVal == 0L && lexer.matchStat == 5 ? null : Long.valueOf(longVal);
                                                                                                                    if (lexer.matchStat <= 0) break block106;
                                                                                                                    matchField = true;
                                                                                                                    valueParsed = true;
                                                                                                                    break block101;
                                                                                                                }
                                                                                                                if (lexer.matchStat != -2) break block101;
                                                                                                                ++notMatchCount;
                                                                                                                break block104;
                                                                                                            }
                                                                                                            if (fieldClass != String.class) break block107;
                                                                                                            fieldValue = lexer.scanFieldString(name_chars);
                                                                                                            if (lexer.matchStat <= 0) break block108;
                                                                                                            matchField = true;
                                                                                                            valueParsed = true;
                                                                                                            break block101;
                                                                                                        }
                                                                                                        if (lexer.matchStat != -2) break block101;
                                                                                                        ++notMatchCount;
                                                                                                        break block104;
                                                                                                    }
                                                                                                    if (fieldClass != BigDecimal.class) break block109;
                                                                                                    fieldValue = lexer.scanFieldDecimal(name_chars);
                                                                                                    if (lexer.matchStat <= 0) break block110;
                                                                                                    matchField = true;
                                                                                                    valueParsed = true;
                                                                                                    break block101;
                                                                                                }
                                                                                                if (lexer.matchStat != -2) break block101;
                                                                                                ++notMatchCount;
                                                                                                break block104;
                                                                                            }
                                                                                            if (!"java.math.BigInteger".equals(fieldClass.getName())) break block111;
                                                                                            fieldValue = lexer.scanFieldBigInteger(name_chars);
                                                                                            if (lexer.matchStat <= 0) break block112;
                                                                                            matchField = true;
                                                                                            valueParsed = true;
                                                                                            break block101;
                                                                                        }
                                                                                        if (lexer.matchStat != -2) break block101;
                                                                                        ++notMatchCount;
                                                                                        break block104;
                                                                                    }
                                                                                    if (fieldClass != Boolean.TYPE && fieldClass != Boolean.class) break block113;
                                                                                    booleanVal = lexer.scanFieldBoolean(name_chars);
                                                                                    fieldValue = lexer.matchStat == 5 ? null : Boolean.valueOf(booleanVal);
                                                                                    if (lexer.matchStat <= 0) break block114;
                                                                                    matchField = true;
                                                                                    valueParsed = true;
                                                                                    break block101;
                                                                                }
                                                                                if (lexer.matchStat != -2) break block101;
                                                                                ++notMatchCount;
                                                                                break block104;
                                                                            }
                                                                            if (fieldClass != Float.TYPE && fieldClass != Float.class) break block115;
                                                                            floatVal = lexer.scanFieldFloat(name_chars);
                                                                            fieldValue = floatVal == 0.0f && lexer.matchStat == 5 ? null : Float.valueOf(floatVal);
                                                                            if (lexer.matchStat <= 0) break block116;
                                                                            matchField = true;
                                                                            valueParsed = true;
                                                                            break block101;
                                                                        }
                                                                        if (lexer.matchStat != -2) break block101;
                                                                        ++notMatchCount;
                                                                        break block104;
                                                                    }
                                                                    if (fieldClass != Double.TYPE && fieldClass != Double.class) break block117;
                                                                    doubleVal = lexer.scanFieldDouble(name_chars);
                                                                    fieldValue = doubleVal == 0.0 && lexer.matchStat == 5 ? null : Double.valueOf(doubleVal);
                                                                    if (lexer.matchStat <= 0) break block118;
                                                                    matchField = true;
                                                                    valueParsed = true;
                                                                    break block101;
                                                                }
                                                                if (lexer.matchStat != -2) break block101;
                                                                ++notMatchCount;
                                                                break block104;
                                                            }
                                                            if (fieldClass != int[].class) break block119;
                                                            fieldValue = lexer.scanFieldIntArray(name_chars);
                                                            if (lexer.matchStat <= 0) break block120;
                                                            matchField = true;
                                                            valueParsed = true;
                                                            break block101;
                                                        }
                                                        if (lexer.matchStat != -2) break block101;
                                                        ++notMatchCount;
                                                        break block104;
                                                    }
                                                    if (fieldClass != float[].class) break block121;
                                                    fieldValue = lexer.scanFieldFloatArray(name_chars);
                                                    if (lexer.matchStat <= 0) break block122;
                                                    matchField = true;
                                                    valueParsed = true;
                                                    break block101;
                                                }
                                                if (lexer.matchStat != -2) break block101;
                                                ++notMatchCount;
                                                break block104;
                                            }
                                            if (fieldClass != float[][].class) break block123;
                                            fieldValue = lexer.scanFieldFloatArray2(name_chars);
                                            if (lexer.matchStat <= 0) break block124;
                                            matchField = true;
                                            valueParsed = true;
                                            break block101;
                                        }
                                        if (lexer.matchStat != -2) break block101;
                                        ++notMatchCount;
                                        break block104;
                                    }
                                    if (!lexer.matchField(name_chars)) break block104;
                                    matchField = true;
                                }
                                if (matchField) break block125;
                                key = lexer.scanSymbol(parser.symbolTable);
                                if (key != null) break block126;
                                token = lexer.token();
                                if (token == 13) {
                                    lexer.nextToken(16);
                                    break;
                                }
                                if (token == 16 && lexer.isEnabled(Feature.AllowArbitraryCommas)) break block104;
                            }
                            if ("$ref".equals(key) && context != null) {
                                lexer.nextTokenWithColon(4);
                                token = lexer.token();
                                if (token == 4) {
                                    ref = lexer.stringVal();
                                    if ("@".equals(ref)) {
                                        object = context.object;
                                    } else if ("..".equals(ref)) {
                                        parentContext = context.parent;
                                        if (parentContext.object != null) {
                                            object = parentContext.object;
                                        } else {
                                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                            parser.resolveStatus = 1;
                                        }
                                    } else if ("$".equals(ref)) {
                                        rootContext = context;
                                        while (rootContext.parent != null) {
                                            rootContext = rootContext.parent;
                                        }
                                        if (rootContext.object != null) {
                                            object = rootContext.object;
                                        } else {
                                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                            parser.resolveStatus = 1;
                                        }
                                    } else {
                                        if (ref.indexOf(92) > 0) {
                                            buf = new StringBuilder();
                                            for (i = 0; i < ref.length(); ++i) {
                                                ch = ref.charAt(i);
                                                if (ch == '\\') {
                                                    ch = ref.charAt(++i);
                                                }
                                                buf.append(ch);
                                            }
                                            ref = buf.toString();
                                        }
                                        if ((refObj = parser.resolveReference((String)ref)) != null) {
                                            object = refObj;
                                        } else {
                                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                                            parser.resolveStatus = 1;
                                        }
                                    }
                                } else {
                                    throw new JSONException("illegal ref, " + JSONToken.name(token));
                                }
                                lexer.nextToken(13);
                                if (lexer.token() != 13) {
                                    throw new JSONException("illegal ref");
                                }
                                lexer.nextToken(16);
                                parser.setContext(context, object, fieldName);
                                ref = object;
                                return (T)ref;
                            }
                        }
                        if (object == null && fieldValues == null) {
                            object = this.createInstance(parser, type);
                            if (object == null) {
                                fieldValues = new HashMap<String, Integer>(this.fieldDeserializers.length);
                            }
                            childContext = parser.setContext(context, object, fieldName);
                            if (setFlags == null) {
                                setFlags = new int[this.fieldDeserializers.length / 32 + 1];
                            }
                        }
                        if (!matchField) break block127;
                        if (!valueParsed) {
                            fieldDeserializer.parseField(parser, object, type, fieldValues);
                        } else {
                            if (object == null) {
                                fieldValues.put(fieldInfo.name, (Integer)fieldValue);
                            } else if (fieldValue == null) {
                                if (fieldClass != Integer.TYPE && fieldClass != Long.TYPE && fieldClass != Float.TYPE && fieldClass != Double.TYPE && fieldClass != Boolean.TYPE) {
                                    fieldDeserializer.setValue(object, fieldValue);
                                }
                            } else {
                                fieldDeserializer.setValue(object, fieldValue);
                            }
                            if (setFlags != null) {
                                flagIndex = fieldIndex / 32;
                                bitIndex = fieldIndex % 32;
                                v0 = flagIndex;
                                setFlags[v0] = setFlags[v0] | 1 << bitIndex;
                            }
                            if (lexer.matchStat == 4) {
                                break;
                            }
                        }
                        ** GOTO lbl309
                    }
                    match = this.parseField(parser, key, object, type, (Map<String, Object>)(fieldValues == null ? new HashMap<K, V>(this.fieldDeserializers.length) : fieldValues), setFlags);
                    if (!match) {
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            break;
                        }
                    } else {
                        if (lexer.token() == 17) {
                            throw new JSONException("syntax error, unexpect token ':'");
                        }
lbl309:
                        // 4 sources

                        if (lexer.token() != 16) {
                            if (lexer.token() == 13) {
                                lexer.nextToken(16);
                                break;
                            }
                            if (lexer.token() == 18 || lexer.token() == 1) {
                                throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token()));
                            }
                        }
                    }
                }
                ++fieldIndex;
            }
            if (object == null) {
                if (fieldValues == null) {
                    object = this.createInstance(parser, type);
                    if (childContext == null) {
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    fieldIndex = object;
                    return (T)fieldIndex;
                }
                paramNames = this.beanInfo.creatorConstructorParameters;
                if (paramNames != null) {
                    params = new Object[paramNames.length];
                    for (i = 0; i < paramNames.length; ++i) {
                        paramName = paramNames[i];
                        param /* !! */  = fieldValues.remove(paramName);
                        if (param /* !! */  == null) {
                            fieldType = this.beanInfo.creatorConstructorParameterTypes[i];
                            param /* !! */  = this.getObjectOfCommonCode(param /* !! */ , fieldType);
                        } else if (this.beanInfo.creatorConstructorParameterTypes != null && i < this.beanInfo.creatorConstructorParameterTypes.length && (paramType = this.beanInfo.creatorConstructorParameterTypes[i]) instanceof Class && !(paramClass = (Class)paramType).isInstance(param /* !! */ ) && param /* !! */  instanceof List && (list = (List)param /* !! */ ).size() == 1 && paramClass.isInstance(first = list.get(0))) {
                            param /* !! */  = list.get(0);
                        }
                        params[i] = param /* !! */ ;
                    }
                } else {
                    fieldInfoList = this.beanInfo.fields;
                    size = fieldInfoList.length;
                    params = new Object[size];
                    for (i = 0; i < size; ++i) {
                        fieldInfo = fieldInfoList[i];
                        param /* !! */  = fieldValues.get(fieldInfo.name);
                        if (param /* !! */  == null) {
                            fieldType = fieldInfo.fieldType;
                            param /* !! */  = this.getObjectOfCommonCode(param /* !! */ , fieldType);
                        }
                        params[i] = param /* !! */ ;
                    }
                }
                if (this.beanInfo.creatorConstructor != null) {
                    try {
                        object = this.beanInfo.creatorConstructor.newInstance(params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create instance error, " + paramNames + ", " + this.beanInfo.creatorConstructor.toString(), e);
                    }
                    if (paramNames != null) {
                        for (Map.Entry<K, V> entry : fieldValues.entrySet()) {
                            fieldDeserializer = this.getFieldDeserializer((String)entry.getKey());
                            if (fieldDeserializer == null) continue;
                            fieldDeserializer.setValue(object, entry.getValue());
                        }
                    }
                } else if (this.beanInfo.factoryMethod != null) {
                    try {
                        object = this.beanInfo.factoryMethod.invoke(null, params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
                    }
                }
                if (childContext != null) {
                    childContext.object = object;
                }
            }
            if ((buildMethod = this.beanInfo.buildMethod) == null) {
                params = object;
                return (T)params;
            }
            try {
                builtObj = buildMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("build object error", e);
            }
            var15_36 = builtObj;
            return (T)var15_36;
        }
        finally {
            if (childContext != null) {
                childContext.object = object;
            }
            parser.setContext(context);
        }
    }

    private Object getObjectOfCommonCode(Object param, Type fieldType) {
        if (fieldType == Byte.TYPE) {
            param = (byte)0;
        } else if (fieldType == Short.TYPE) {
            param = (short)0;
        } else if (fieldType == Integer.TYPE) {
            param = 0;
        } else if (fieldType == Long.TYPE) {
            param = 0L;
        } else if (fieldType == Float.TYPE) {
            param = Float.valueOf(0.0f);
        } else if (fieldType == Double.TYPE) {
            param = 0.0;
        } else if (fieldType == Boolean.TYPE) {
            param = Boolean.FALSE;
        }
        return param;
    }

    public boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues, int[] setFlags) {
        JSONScanner lexer = parser.lexer;
        FieldDeserializer fieldDeserializer = this.smartMatch(key, setFlags);
        if (fieldDeserializer == null) {
            if (!lexer.isEnabled(Feature.IgnoreNotMatch)) {
                throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
            }
            parser.parseExtra(object, key);
            return false;
        }
        int fieldIndex = -1;
        for (int i = 0; i < this.sortedFieldDeserializers.length; ++i) {
            if (this.sortedFieldDeserializers[i] != fieldDeserializer) continue;
            fieldIndex = i;
            break;
        }
        if (fieldIndex != -1 && setFlags != null && key.startsWith("_") && JavaBeanDeserializer.isSetFlag(fieldIndex, setFlags)) {
            parser.parseExtra(object, key);
            return false;
        }
        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object, objectType, fieldValues);
        if (setFlags != null) {
            int flagIndex = fieldIndex / 32;
            int bitIndex = fieldIndex % 32;
            int n = flagIndex;
            setFlags[n] = setFlags[n] | 1 << bitIndex;
        }
        return true;
    }

    public FieldDeserializer smartMatch(String key) {
        return this.smartMatch(key, null);
    }

    public FieldDeserializer smartMatch(String key, int[] setFlags) {
        if (key == null) {
            return null;
        }
        FieldDeserializer fieldDeserializer = this.getFieldDeserializer(key, setFlags);
        if (fieldDeserializer == null) {
            boolean is = key.startsWith("is");
            String smartKey = is ? key.substring(2) : key;
            fieldDeserializer = this.fieldDeserializerMap.get(smartKey);
            if (fieldDeserializer == null) {
                fieldDeserializer = this.fieldDeserializerMap.get(key);
            }
            if (fieldDeserializer != null) {
                FieldInfo fieldInfo = fieldDeserializer.fieldInfo;
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (is && fieldClass != Boolean.TYPE && fieldClass != Boolean.class) {
                    fieldDeserializer = null;
                }
            }
        }
        return fieldDeserializer;
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    private Object createFactoryInstance(ParserConfig config, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.beanInfo.factoryMethod.invoke(null, value);
    }

    public Object createInstance(Map<String, Object> map, ParserConfig config) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object object = null;
        if (this.beanInfo.creatorConstructor == null && this.beanInfo.factoryMethod == null) {
            object = this.createInstance(null, this.clazz);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                FieldDeserializer fieldDeser = this.smartMatch(key);
                if (fieldDeser == null) continue;
                FieldInfo fieldInfo = fieldDeser.fieldInfo;
                Field field = fieldDeser.fieldInfo.field;
                Type paramType = fieldInfo.fieldType;
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (fieldInfo.declaringClass != null && !fieldClass.isInstance(value)) {
                    String input = value instanceof String && JSONValidator.from((String)value).validate() ? (String)value : JSON.toJSONString(value);
                    DefaultJSONParser parser = new DefaultJSONParser(input);
                    fieldDeser.parseField(parser, object, paramType, null);
                    continue;
                }
                if (field != null && fieldInfo.method == null) {
                    String strVal;
                    Class<?> fieldType = field.getType();
                    if (fieldType == Boolean.TYPE) {
                        if (value == Boolean.FALSE) {
                            field.setBoolean(object, false);
                            continue;
                        }
                        if (value == Boolean.TRUE) {
                            field.setBoolean(object, true);
                            continue;
                        }
                    } else if (fieldType == Integer.TYPE) {
                        if (value instanceof Number) {
                            field.setInt(object, ((Number)value).intValue());
                            continue;
                        }
                    } else if (fieldType == Long.TYPE) {
                        if (value instanceof Number) {
                            field.setLong(object, ((Number)value).longValue());
                            continue;
                        }
                    } else if (fieldType == Float.TYPE) {
                        if (value instanceof Number) {
                            field.setFloat(object, ((Number)value).floatValue());
                            continue;
                        }
                        if (value instanceof String) {
                            strVal = (String)value;
                            float floatValue = strVal.length() <= 10 ? TypeUtils.parseFloat(strVal) : Float.parseFloat(strVal);
                            field.setFloat(object, floatValue);
                            continue;
                        }
                    } else if (fieldType == Double.TYPE) {
                        if (value instanceof Number) {
                            field.setDouble(object, ((Number)value).doubleValue());
                            continue;
                        }
                        if (value instanceof String) {
                            strVal = (String)value;
                            double doubleValue = strVal.length() <= 10 ? TypeUtils.parseDouble(strVal) : Double.parseDouble(strVal);
                            field.setDouble(object, doubleValue);
                            continue;
                        }
                    } else if (value != null && paramType == value.getClass()) {
                        field.set(object, value);
                        continue;
                    }
                }
                value = paramType instanceof ParameterizedType ? TypeUtils.cast(value, (ParameterizedType)paramType, config) : TypeUtils.cast(value, paramType, config);
                fieldDeser.setValue(object, value);
            }
            if (this.beanInfo.buildMethod != null) {
                Object builtObj;
                try {
                    builtObj = this.beanInfo.buildMethod.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    throw new JSONException("build object error", e);
                }
                return builtObj;
            }
            return object;
        }
        FieldInfo[] fieldInfoList = this.beanInfo.fields;
        int size = fieldInfoList.length;
        Object[] params = new Object[size];
        HashMap<String, Integer> missFields = null;
        for (int i = 0; i < size; ++i) {
            FieldInfo fieldInfo = fieldInfoList[i];
            Object param = map.get(fieldInfo.name);
            if (param == null) {
                Class<?> fieldClass = fieldInfo.fieldClass;
                if (fieldClass == Integer.TYPE) {
                    param = 0;
                } else if (fieldClass == Long.TYPE) {
                    param = 0L;
                } else if (fieldClass == Short.TYPE) {
                    param = (short)0;
                } else if (fieldClass == Byte.TYPE) {
                    param = (byte)0;
                } else if (fieldClass == Float.TYPE) {
                    param = Float.valueOf(0.0f);
                } else if (fieldClass == Double.TYPE) {
                    param = 0.0;
                } else if (fieldClass == Character.TYPE) {
                    param = Character.valueOf('0');
                } else if (fieldClass == Boolean.TYPE) {
                    param = false;
                }
                if (missFields == null) {
                    missFields = new HashMap<String, Integer>();
                }
                missFields.put(fieldInfo.name, i);
            }
            params[i] = param;
        }
        if (missFields != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Integer index;
                String key = entry.getKey();
                Object value = entry.getValue();
                FieldDeserializer fieldDeser = this.smartMatch(key);
                if (fieldDeser == null || (index = (Integer)missFields.get(fieldDeser.fieldInfo.name)) == null) continue;
                params[index.intValue()] = value;
            }
        }
        if (this.beanInfo.creatorConstructor != null) {
            try {
                object = this.beanInfo.creatorConstructor.newInstance(params);
            }
            catch (Exception e) {
                throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toString(), e);
            }
        }
        if (this.beanInfo.factoryMethod != null) {
            try {
                object = this.beanInfo.factoryMethod.invoke(null, params);
            }
            catch (Exception e) {
                throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
            }
        }
        return object;
    }

    public Type getFieldType(int ordinal) {
        return this.sortedFieldDeserializers[ordinal].fieldInfo.fieldType;
    }

    protected Object parseRest(DefaultJSONParser parser, Type type, Object fieldName, Object instance, int features) {
        return this.parseRest(parser, type, fieldName, instance, features, new int[0]);
    }

    protected Object parseRest(DefaultJSONParser parser, Type type, Object fieldName, Object instance, int features, int[] setFlags) {
        Object value = this.deserialze(parser, type, fieldName, instance, features, setFlags);
        return value;
    }
}

