/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.annotation.JSONField;
import com.antgroup.antchain.myjson.serializer.FieldSerializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerialContext;
import com.antgroup.antchain.myjson.serializer.SerializeBeanInfo;
import com.antgroup.antchain.myjson.serializer.SerializeFilterable;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.FieldInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@NoMetadata
public class JavaBeanSerializer
extends SerializeFilterable
implements ObjectSerializer {
    protected final FieldSerializer[] getters;
    protected final FieldSerializer[] sortedGetters;
    protected final SerializeBeanInfo beanInfo;

    public Class<?> getType() {
        return this.beanInfo.beanType;
    }

    public JavaBeanSerializer(SerializeBeanInfo beanInfo) {
        this.beanInfo = beanInfo;
        this.sortedGetters = new FieldSerializer[beanInfo.sortedFields.length];
        for (int i = 0; i < this.sortedGetters.length; ++i) {
            this.sortedGetters[i] = new FieldSerializer(beanInfo.beanType, beanInfo.sortedFields[i]);
        }
        if (beanInfo.fields == beanInfo.sortedFields) {
            this.getters = this.sortedGetters;
        } else {
            this.getters = new FieldSerializer[beanInfo.fields.length];
            boolean hashNotMatch = false;
            for (int i = 0; i < this.getters.length; ++i) {
                FieldInfo fieldInfo = beanInfo.fields[i];
                if (fieldInfo.field.getType().isEnum()) {
                    throw new JSONException("field " + fieldInfo.name + " enum type not supported in myjson");
                }
                FieldSerializer fieldSerializer = this.getFieldSerializer(fieldInfo.name);
                if (fieldSerializer == null) {
                    hashNotMatch = true;
                    break;
                }
                this.getters[i] = fieldSerializer;
            }
            if (hashNotMatch) {
                System.arraycopy(this.sortedGetters, 0, this.getters, 0, this.sortedGetters.length);
            }
        }
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        this.write(serializer, object, fieldName, fieldType, features, false);
    }

    protected void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features, boolean unwrapped) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        if (this.writeReference(serializer, object, features)) {
            return;
        }
        FieldSerializer[] getters = out.sortField ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.context;
        if (!this.beanInfo.beanType.isEnum()) {
            serializer.setContext(parent, object, fieldName, this.beanInfo.features, features);
        }
        boolean writeAsArray = this.isWriteAsArray(serializer, features);
        FieldSerializer errorFieldSerializer = null;
        try {
            boolean commaFlag;
            char endSeperator;
            char startSeperator = writeAsArray ? (char)'[' : '{';
            char c = endSeperator = writeAsArray ? (char)']' : '}';
            if (!unwrapped) {
                out.append(startSeperator);
            }
            int seperator = (commaFlag = false) ? 44 : 0;
            commaFlag = seperator == 44;
            boolean ignoreNonFieldGetter = out.isEnabled(SerializerFeature.IgnoreNonFieldGetter);
            for (int i = 0; i < getters.length; ++i) {
                Class<?> fieldCLass;
                int serialzeFeatures;
                List propertyValue;
                FieldSerializer fieldSerializer = getters[i];
                Field field = fieldSerializer.fieldInfo.field;
                FieldInfo fieldInfo = fieldSerializer.fieldInfo;
                String fieldInfoName = fieldInfo.name;
                Class<?> fieldClass = fieldInfo.fieldClass;
                boolean directWritePrefix = out.quoteFieldNames;
                if (ignoreNonFieldGetter && field == null) continue;
                boolean notApply = false;
                if (notApply) {
                    propertyValue = null;
                } else {
                    try {
                        propertyValue = fieldSerializer.getPropertyValueDirect(object);
                    }
                    catch (InvocationTargetException ex) {
                        errorFieldSerializer = fieldSerializer;
                        if (out.isEnabled(SerializerFeature.IgnoreErrorGetter)) {
                            propertyValue = null;
                        }
                        throw ex;
                    }
                }
                String key = fieldInfoName;
                List originalValue = propertyValue;
                propertyValue = this.processValue(serializer, fieldSerializer.fieldContext, object, fieldInfoName, propertyValue, features);
                if (propertyValue == null) {
                    int mask;
                    int defaultMask;
                    serialzeFeatures = fieldInfo.serialzeFeatures;
                    JSONField jsonField = fieldInfo.getAnnotation();
                    if (jsonField != null && !"".equals(jsonField.defaultValue())) {
                        propertyValue = jsonField.defaultValue();
                    } else if (fieldClass == Boolean.class) {
                        defaultMask = SerializerFeature.WriteNullBooleanAsFalse.mask;
                        mask = defaultMask | SerializerFeature.WriteMapNullValue.mask;
                        if (!writeAsArray && (serialzeFeatures & mask) == 0 && (out.features & mask) == 0) continue;
                        if ((serialzeFeatures & defaultMask) != 0) {
                            propertyValue = false;
                        } else if ((out.features & defaultMask) != 0 && (serialzeFeatures & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            propertyValue = false;
                        }
                    } else if (fieldClass == String.class) {
                        defaultMask = SerializerFeature.WriteNullStringAsEmpty.mask;
                        mask = defaultMask | SerializerFeature.WriteMapNullValue.mask;
                        if (!writeAsArray && (serialzeFeatures & mask) == 0 && (out.features & mask) == 0) continue;
                        if ((serialzeFeatures & defaultMask) != 0) {
                            propertyValue = "";
                        } else if ((out.features & defaultMask) != 0 && (serialzeFeatures & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            propertyValue = "";
                        }
                    } else if (Number.class.isAssignableFrom(fieldClass)) {
                        defaultMask = SerializerFeature.WriteNullNumberAsZero.mask;
                        mask = defaultMask | SerializerFeature.WriteMapNullValue.mask;
                        if (!writeAsArray && (serialzeFeatures & mask) == 0 && (out.features & mask) == 0) continue;
                        if ((serialzeFeatures & defaultMask) != 0) {
                            propertyValue = 0;
                        } else if ((out.features & defaultMask) != 0 && (serialzeFeatures & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            propertyValue = 0;
                        }
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        defaultMask = SerializerFeature.WriteNullListAsEmpty.mask;
                        mask = defaultMask | SerializerFeature.WriteMapNullValue.mask;
                        if (!writeAsArray && (serialzeFeatures & mask) == 0 && (out.features & mask) == 0) continue;
                        if ((serialzeFeatures & defaultMask) != 0) {
                            propertyValue = Collections.emptyList();
                        } else if ((out.features & defaultMask) != 0 && (serialzeFeatures & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            propertyValue = Collections.emptyList();
                        }
                    } else if (!writeAsArray && !fieldSerializer.writeNull && !out.isEnabled(SerializerFeature.WriteMapNullValue.mask) && (serialzeFeatures & SerializerFeature.WriteMapNullValue.mask) == 0) continue;
                }
                if (propertyValue != null && (out.notWriteDefaultValue || (fieldInfo.serialzeFeatures & SerializerFeature.NotWriteDefaultValue.mask) != 0 || (this.beanInfo.features & SerializerFeature.NotWriteDefaultValue.mask) != 0) && ((fieldCLass = fieldInfo.fieldClass) == Byte.TYPE && propertyValue instanceof Byte && (Byte)((Object)propertyValue) == 0 || fieldCLass == Short.TYPE && propertyValue instanceof Short && (Short)((Object)propertyValue) == 0 || fieldCLass == Integer.TYPE && propertyValue instanceof Integer && (Integer)((Object)propertyValue) == 0 || fieldCLass == Long.TYPE && propertyValue instanceof Long && (Long)((Object)propertyValue) == 0L || fieldCLass == Float.TYPE && propertyValue instanceof Float && ((Float)((Object)propertyValue)).equals(Float.valueOf(0.0f)) || fieldCLass == Double.TYPE && propertyValue instanceof Double && (Double)((Object)propertyValue) == 0.0 || fieldCLass == Boolean.TYPE && propertyValue instanceof Boolean && !((Boolean)((Object)propertyValue)).booleanValue())) continue;
                if (commaFlag) {
                    out.write(44);
                }
                if (key != fieldInfoName) {
                    if (!writeAsArray) {
                        out.writeFieldName(key, true);
                    }
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else {
                    if (!writeAsArray) {
                        if (directWritePrefix) {
                            out.write(fieldInfo.name_chars, 0, fieldInfo.name_chars.length);
                        } else {
                            fieldSerializer.writePrefix(serializer);
                        }
                    }
                    if (!writeAsArray) {
                        if (fieldClass == String.class) {
                            if (propertyValue == null) {
                                serialzeFeatures = fieldSerializer.features;
                                if ((out.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0 && (serialzeFeatures & SerializerFeature.WriteMapNullValue.mask) == 0) {
                                    out.writeString("");
                                } else if ((serialzeFeatures & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
                                    out.writeString("");
                                } else {
                                    out.writeNull();
                                }
                            } else {
                                String propertyValueString = (String)((Object)propertyValue);
                                out.writeStringWithDoubleQuote(propertyValueString, '\u0000');
                            }
                        } else {
                            fieldSerializer.writeValue(serializer, propertyValue);
                        }
                    } else {
                        fieldSerializer.writeValue(serializer, propertyValue);
                    }
                }
                boolean fieldUnwrappedNull = false;
                if (fieldUnwrappedNull) continue;
                commaFlag = true;
            }
            if (!unwrapped) {
                out.append(endSeperator);
            }
        }
        catch (Exception e) {
            String errorMessage = "write javaBean error, fastjson version 1.2.76";
            if (object != null) {
                errorMessage = errorMessage + ", class " + object.getClass().getName();
            }
            if (fieldName != null) {
                errorMessage = errorMessage + ", fieldName : " + fieldName;
            } else if (errorFieldSerializer != null && errorFieldSerializer.fieldInfo != null) {
                FieldInfo fieldInfo = errorFieldSerializer.fieldInfo;
                errorMessage = fieldInfo.method != null ? errorMessage + ", method : " + fieldInfo.method.getName() : errorMessage + ", fieldName : " + errorFieldSerializer.fieldInfo.name;
            }
            if (e.getMessage() != null) {
                errorMessage = errorMessage + ", " + e.getMessage();
            }
            Throwable cause = null;
            if (e instanceof InvocationTargetException) {
                cause = e.getCause();
            }
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(errorMessage, cause);
        }
        finally {
            serializer.context = parent;
        }
    }

    public boolean writeReference(JSONSerializer serializer, Object object, int fieldFeatures) {
        SerialContext context = serializer.context;
        int mask = SerializerFeature.DisableCircularReferenceDetect.mask;
        if (context == null || (context.features & mask) != 0 || (fieldFeatures & mask) != 0) {
            return false;
        }
        if (serializer.references != null && serializer.references.containsKey(object)) {
            serializer.writeReference(object);
            return true;
        }
        return false;
    }

    protected boolean isWriteAsArray(JSONSerializer serializer, int fieldFeatrues) {
        int mask = SerializerFeature.BeanToArray.mask;
        return (this.beanInfo.features & mask) != 0 || serializer.out.beanToArray || (fieldFeatrues & mask) != 0;
    }

    public FieldSerializer getFieldSerializer(String key) {
        if (key == null) {
            return null;
        }
        int low = 0;
        int high = this.sortedGetters.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedGetters[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedGetters[mid];
        }
        return null;
    }

    public Map<String, Object> getFieldValuesMap(Object object) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(this.sortedGetters.length);
        for (FieldSerializer getter : this.sortedGetters) {
            map.put(getter.fieldInfo.name, getter.getPropertyValue(object));
        }
        return map;
    }
}

