/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

@NoMetadata
public class MiscCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final MiscCodec instance = new MiscCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull();
            return;
        }
        Class<?> objClass = object.getClass();
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            Object objKey = entry.getKey();
            Object objVal = entry.getValue();
            if (objKey instanceof String) {
                String key = (String)objKey;
                if (objVal instanceof String) {
                    String value = (String)objVal;
                    out.writeFieldValueStringWithDoubleQuoteCheck('{', key, value);
                } else {
                    out.write(123);
                    out.writeFieldName(key);
                    serializer.write(objVal);
                }
            } else {
                out.write(123);
                serializer.write(objKey);
                out.write(58);
                serializer.write(objVal);
            }
            out.write(125);
            return;
        }
        throw new JSONException("not support class : " + objClass);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String strVal;
        Object objVal;
        JSONScanner lexer = parser.lexer;
        if (parser.resolveStatus == 2) {
            parser.resolveStatus = 0;
            parser.accept(16);
            if (lexer.token() == 4) {
                if (!"val".equals(lexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextToken();
            parser.accept(17);
            objVal = parser.parse();
            parser.accept(13);
        } else {
            objVal = parser.parse();
        }
        if (objVal == null) {
            strVal = null;
        } else if (objVal instanceof String) {
            strVal = (String)objVal;
        } else {
            if (objVal instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)objVal;
                if (clazz == Map.Entry.class) {
                    return (T)jsonObject.entrySet().iterator().next();
                }
                return jsonObject.toJavaObject(clazz);
            }
            throw new JSONException("expect string");
        }
        if (strVal == null || strVal.length() == 0) {
            return null;
        }
        if (clazz instanceof ParameterizedType) {
            ParameterizedType parmeterizedType = (ParameterizedType)clazz;
            clazz = parmeterizedType.getRawType();
        }
        throw new JSONException("MiscCodec not support " + clazz.toString());
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

