/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myxml;

import java.util.ArrayList;

public class XmlInputStream {
    private final char[] origin;
    int position = 0;
    private final int length;
    private static final char[] SPACE_CHARACTERS = new char[]{' ', '\t', '\n'};

    public XmlInputStream(String origin) {
        this.origin = origin.toCharArray();
        this.length = this.origin.length;
    }

    public int read() {
        if (this.position >= this.length) {
            return -1;
        }
        char result = this.origin[this.position];
        ++this.position;
        return result;
    }

    public void skip() {
        if (this.position < this.length) {
            ++this.position;
        }
    }

    public int currentChar() {
        if (this.position >= this.length) {
            return -1;
        }
        return this.origin[this.position];
    }

    public char[] lookAhead(int count) {
        if (this.position + count > this.length) {
            return null;
        }
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.origin[this.position + i];
        }
        this.position += count;
        return result;
    }

    public boolean checkAhead(char[] validatorChars) {
        int count = validatorChars.length;
        if (this.position + count > this.length) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (validatorChars[i] == this.origin[this.position + i]) continue;
            return false;
        }
        return true;
    }

    public boolean checkAhead(char validatorChar) {
        if (this.position + 1 >= this.length) {
            return false;
        }
        return validatorChar == this.origin[this.position];
    }

    public boolean checkWhitespace() {
        if (this.position + 1 >= this.length) {
            return false;
        }
        char c = this.origin[this.position];
        return c == ' ' || c == '\n' || c == '\t' || Character.isWhitespace(c);
    }

    public void skipWhitespaces() {
        while (true) {
            int c;
            if ((c = this.currentChar()) == -1) {
                return;
            }
            if (!Character.isWhitespace(c)) break;
            this.skip();
        }
    }

    public boolean eof() {
        return this.position >= this.length;
    }

    public int getPosition() {
        return this.position;
    }

    public char[] readUntilChar(int until) {
        return this.readUntilOneOfChars(until, -1);
    }

    public char[] readUntilOneOfChars(int untilChar1, int untilChar2) {
        ArrayList<Character> chars = new ArrayList<Character>();
        int c;
        while ((c = this.read()) != -1) {
            if (c == untilChar1 || c == untilChar2) {
                --this.position;
                char[] result = new char[chars.size()];
                for (int i = 0; i < chars.size(); ++i) {
                    result[i] = ((Character)chars.get(i)).charValue();
                }
                return result;
            }
            chars.add(Character.valueOf((char)c));
        }
        return null;
    }

    public char[] readUntilOneOfCharsOrWhitespace(int untilChar1, int untilChar2) {
        ArrayList<Character> chars = new ArrayList<Character>();
        int c;
        while ((c = this.read()) != -1) {
            if (c == untilChar1 || c == untilChar2 || c == 32 || c == 10 || c == 9 || Character.isWhitespace(c)) {
                --this.position;
                char[] result = new char[chars.size()];
                for (int i = 0; i < chars.size(); ++i) {
                    result[i] = ((Character)chars.get(i)).charValue();
                }
                return result;
            }
            chars.add(Character.valueOf((char)c));
        }
        return null;
    }

    public String remainingString() {
        return new String(this.origin, this.position, this.origin.length - this.position);
    }

    public int total() {
        return this.length;
    }
}

