/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerialContext;
import com.antgroup.antchain.myjson.serializer.SerializeConfig;
import com.antgroup.antchain.myjson.serializer.SerializeFilterable;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.StringCodec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.IdentityHashMap;

@NoMetadata
public class JSONSerializer
extends SerializeFilterable {
    protected final SerializeConfig config;
    public final SerializeWriter out;
    private int indentCount = 0;
    private String indent = "\t";
    protected IdentityHashMap<Object, SerialContext> references = null;
    protected SerialContext context;

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter out) {
        this(out, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig config) {
        this(new SerializeWriter(), config);
    }

    public JSONSerializer(SerializeWriter out, SerializeConfig config) {
        this.out = out;
        this.config = config;
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext context) {
        this.context = context;
    }

    public void setContext(SerialContext parent, Object object, Object fieldName, int features) {
        this.setContext(parent, object, fieldName, features, 0);
    }

    public void setContext(SerialContext parent, Object object, Object fieldName, int features, int fieldFeatures) {
        if (this.out.disableCircularReferenceDetect) {
            return;
        }
        this.context = new SerialContext(parent, object, fieldName, features, fieldFeatures);
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        this.references.put(object, this.context);
    }

    public void setContext(Object object, Object fieldName) {
        this.setContext(this.context, object, fieldName, 0);
    }

    public void popContext() {
        if (this.context != null) {
            this.context = this.context.parent;
        }
    }

    public boolean containsReference(Object value) {
        if (this.references == null) {
            return false;
        }
        SerialContext refContext = this.references.get(value);
        if (refContext == null) {
            return false;
        }
        if (value == Collections.emptyMap()) {
            return false;
        }
        Object fieldName = refContext.fieldName;
        return fieldName == null || fieldName instanceof Integer || fieldName instanceof String;
    }

    public void writeReference(Object object) {
        SerialContext context = this.context;
        Object current = context.object;
        if (object == current) {
            this.out.write("{\"$ref\":\"@\"}");
            return;
        }
        SerialContext parentContext = context.parent;
        if (parentContext != null && object == parentContext.object) {
            this.out.write("{\"$ref\":\"..\"}");
            return;
        }
        SerialContext rootContext = context;
        while (rootContext.parent != null) {
            rootContext = rootContext.parent;
        }
        if (object == rootContext.object) {
            this.out.write("{\"$ref\":\"$\"}");
        } else {
            this.out.write("{\"$ref\":\"");
            String path = this.references.get(object).toString();
            this.out.write(path);
            this.out.write("\"}");
        }
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        ObjectSerializer writer = this.getObjectWriter(clazz);
        try {
            writer.write(this, object, null, null, 0);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public final void writeWithFieldName(Object object, Object fieldName) {
        this.writeWithFieldName(object, fieldName, null, 0);
    }

    public final void writeWithFieldName(Object object, Object fieldName, Type fieldType, int fieldFeatures) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Class<?> clazz = object.getClass();
            ObjectSerializer writer = this.getObjectWriter(clazz);
            writer.write(this, object, fieldName, fieldType, fieldFeatures);
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public final void write(String text) {
        StringCodec.instance.write(this, text);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.config.getObjectWriter(clazz);
    }

    public void close() {
        this.out.close();
    }
}

