/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myxml;

import com.antgroup.antchain.myxml.XmlAttribute;
import java.util.ArrayList;
import java.util.List;

public class XmlElement {
    String name;
    private final int depth;
    XmlElement parent;
    List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
    private List<XmlElement> children = new ArrayList<XmlElement>();
    String content = "";

    public XmlElement(XmlElement parent, String name) {
        this.parent = parent;
        this.name = name;
        this.depth = parent != null ? parent.getDepth() + 1 : 1;
    }

    public XmlElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<XmlElement> getChildren() {
        return this.children;
    }

    public void setChildren(List<XmlElement> children) {
        this.children = children;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<XmlAttribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return XmlElement.toString(this.name);
    }

    static String toString(String name) {
        return "'" + name + "'";
    }

    public XmlAttribute getAttribute(String name) {
        for (XmlAttribute attr : this.attributes) {
            if (!attr.name.equals(name)) continue;
            return attr;
        }
        return null;
    }

    public XmlElement getChild(String childElementName) {
        for (XmlElement child : this.children) {
            if (!child.name.equals(childElementName)) continue;
            return child;
        }
        return null;
    }

    public List<XmlElement> getChildList(String childElementName) {
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        for (XmlElement child : this.children) {
            if (!child.name.equals(childElementName)) continue;
            result.add(child);
        }
        return result;
    }
}

