/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myxml;

import com.antgroup.antchain.myxml.InvalidXmlException;
import com.antgroup.antchain.myxml.XmlAttribute;
import com.antgroup.antchain.myxml.XmlCodec;
import com.antgroup.antchain.myxml.XmlDocument;
import com.antgroup.antchain.myxml.XmlElement;
import com.antgroup.antchain.myxml.XmlInputStream;
import java.util.ArrayList;

public final class XmlParser {
    private static final char[] XML_HEADER_PREFIX = "<?xml".toCharArray();

    private static void parseXmlHeader(XmlInputStream stream) throws InvalidXmlException {
        int c;
        stream.skipWhitespaces();
        if (!stream.checkAhead(XML_HEADER_PREFIX)) {
            return;
        }
        stream.lookAhead(XML_HEADER_PREFIX.length);
        do {
            if ((c = stream.read()) != -1) continue;
            throw new InvalidXmlException("invalid xml header", stream.position);
        } while (c != 63);
        int next = stream.read();
        if (next == 62) {
            return;
        }
        throw new InvalidXmlException("invalid xml header", stream.position);
    }

    private static void parseElementAttribute(XmlInputStream stream, XmlElement element) throws InvalidXmlException {
        String attrName;
        stream.skipWhitespaces();
        if (stream.checkAhead('>')) {
            return;
        }
        char[] attrNameChars = stream.readUntilOneOfCharsOrWhitespace(61, 62);
        String string = attrName = attrNameChars != null ? new String(attrNameChars).trim() : "";
        if (stream.checkWhitespace()) {
            element.attributes.add(new XmlAttribute(attrName, ""));
            return;
        }
        stream.skipWhitespaces();
        int charAfterAttrName = stream.currentChar();
        if (charAfterAttrName == 62) {
            element.attributes.add(new XmlAttribute(attrName, ""));
            return;
        }
        if (charAfterAttrName != 61) {
            throw new InvalidXmlException("invalid xml attribute", stream.position);
        }
        stream.skip();
        stream.skipWhitespaces();
        if (!stream.checkAhead('\"')) {
            throw new InvalidXmlException("invalid xml attribute value begin, need \"", stream.position);
        }
        stream.skip();
        char[] attrValueChars = stream.readUntilChar(34);
        if (!stream.checkAhead('\"')) {
            throw new InvalidXmlException("invalid xml attrbute value end, need \"", stream.position);
        }
        String attrValue = new String(attrValueChars);
        attrValue = XmlCodec.unescapeXmlText(attrValue);
        stream.skip();
        element.attributes.add(new XmlAttribute(attrName, attrValue));
    }

    private static XmlElement parseElement(XmlInputStream stream, XmlElement parent) throws InvalidXmlException {
        stream.skipWhitespaces();
        if (!stream.checkAhead('<')) {
            throw new InvalidXmlException("invalid xml element name", stream.position);
        }
        stream.skip();
        stream.skipWhitespaces();
        char[] nameChars = stream.readUntilOneOfChars(62, 32);
        if (nameChars == null) {
            throw new InvalidXmlException("invalid xml element name", stream.position);
        }
        String name = new String(nameChars);
        int charAfterName = stream.read();
        if (charAfterName == -1) {
            throw new InvalidXmlException("invalid xml element name", stream.position);
        }
        XmlElement result = new XmlElement(parent, name);
        if (charAfterName == 32) {
            int positionBeforeParseAttr = stream.position;
            while (!stream.checkAhead('>') && !stream.eof()) {
                XmlParser.parseElementAttribute(stream, result);
                stream.skipWhitespaces();
                if (positionBeforeParseAttr == stream.position) {
                    throw new InvalidXmlException("invalid xml element attribute", stream.position);
                }
                positionBeforeParseAttr = stream.position;
            }
            if (stream.checkAhead('>')) {
                stream.skip();
            } else {
                stream.readUntilChar(62);
                stream.skip();
            }
        }
        ArrayList<XmlElement> children = new ArrayList<XmlElement>();
        StringBuilder contentBuilder = new StringBuilder();
        while (!stream.eof()) {
            char[] contentBuf = stream.readUntilChar(60);
            if (contentBuf == null) {
                throw new InvalidXmlException("invalid xml element content", stream.position);
            }
            contentBuilder.append(contentBuf);
            stream.skipWhitespaces();
            int charAfterContent = stream.currentChar();
            if (charAfterContent == -1) {
                throw new InvalidXmlException("invalid xml element content", stream.position);
            }
            if (charAfterContent == 60) {
                if (stream.checkAhead(new char[]{'<', '/'})) break;
                XmlElement child = XmlParser.parseElement(stream, result);
                children.add(child);
                continue;
            }
            throw new InvalidXmlException("invalid xml element content", stream.position);
        }
        String content = contentBuilder.toString().trim();
        content = XmlCodec.unescapeXmlText(content);
        stream.skipWhitespaces();
        char[] elementEndChars = ("</" + name + ">").toCharArray();
        if (!stream.checkAhead(elementEndChars)) {
            throw new InvalidXmlException("invalid xml element end of name " + name, stream.position);
        }
        stream.lookAhead(elementEndChars.length);
        result.setContent(content);
        result.setChildren(children);
        return result;
    }

    public static XmlDocument parse(String xmlText) throws InvalidXmlException {
        XmlInputStream stream = new XmlInputStream(xmlText);
        XmlDocument doc = XmlParser.parse(stream);
        if (xmlText.length() > 10000) {
            System.gc();
        }
        return doc;
    }

    public static XmlDocument parse(XmlInputStream stream) throws InvalidXmlException {
        XmlParser.parseXmlHeader(stream);
        XmlElement rootElement = XmlParser.parseElement(stream, null);
        stream.skipWhitespaces();
        if (!stream.eof()) {
            throw new InvalidXmlException("invalid xml end", stream.position);
        }
        XmlDocument doc = new XmlDocument();
        doc.setRoot(rootElement);
        return doc;
    }
}

