/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.parser.deserializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.util.FieldInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@NoMetadata
public abstract class FieldDeserializer {
    public final FieldInfo fieldInfo;
    protected final Class<?> clazz;

    public FieldDeserializer(Class<?> clazz, FieldInfo fieldInfo) {
        this.clazz = clazz;
        this.fieldInfo = fieldInfo;
    }

    public Class<?> getOwnerClass() {
        return this.clazz;
    }

    public abstract void parseField(DefaultJSONParser var1, Object var2, Type var3, Map<String, Object> var4);

    public int getFastMatchToken() {
        return 0;
    }

    public void setValue(Object object, boolean value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, int value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, long value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, String value) {
        this.setValue(object, (Object)value);
    }

    public void setValue(Object object, Object value) {
        block28: {
            if (value == null && this.fieldInfo.fieldClass.isPrimitive()) {
                return;
            }
            try {
                Method method = this.fieldInfo.method;
                if (method != null) {
                    if (this.fieldInfo.getOnly) {
                        if (Map.class.isAssignableFrom(method.getReturnType())) {
                            Map map = null;
                            try {
                                map = (Map)method.invoke(object, new Object[0]);
                            }
                            catch (InvocationTargetException e) {
                                FieldDeserializer.degradeValueAssignment(this.fieldInfo.field, method, object, value);
                                return;
                            }
                            if (map != null) {
                                if (map == Collections.emptyMap()) {
                                    return;
                                }
                                if (map.isEmpty() && ((Map)value).isEmpty()) {
                                    return;
                                }
                                map.putAll((Map)value);
                            } else if (value != null) {
                                FieldDeserializer.degradeValueAssignment(this.fieldInfo.field, method, object, value);
                            }
                            break block28;
                        }
                        Collection collection = null;
                        try {
                            collection = (Collection)method.invoke(object, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            FieldDeserializer.degradeValueAssignment(this.fieldInfo.field, method, object, value);
                            return;
                        }
                        if (collection != null && value != null) {
                            if (!collection.isEmpty()) {
                                collection.clear();
                            } else if (((Collection)value).isEmpty()) {
                                return;
                            }
                            collection.addAll((Collection)value);
                        } else if (collection == null && value != null) {
                            FieldDeserializer.degradeValueAssignment(this.fieldInfo.field, method, object, value);
                        }
                        break block28;
                    }
                    method.invoke(object, value);
                    break block28;
                }
                Field field = this.fieldInfo.field;
                if (this.fieldInfo.getOnly) {
                    if (Map.class.isAssignableFrom(this.fieldInfo.fieldClass)) {
                        Map map = (Map)field.get(object);
                        if (map != null) {
                            map.putAll((Map)value);
                        }
                    } else {
                        Collection collection = (Collection)field.get(object);
                        if (collection != null && value != null) {
                            collection.clear();
                            collection.addAll((Collection)value);
                        }
                    }
                } else if (field != null) {
                    field.set(object, value);
                }
            }
            catch (Exception e) {
                throw new JSONException("set property error, " + this.clazz.getName() + "#" + this.fieldInfo.name, e);
            }
        }
    }

    private static boolean degradeValueAssignment(Field field, Method getMethod, Object object, Object value) throws InvocationTargetException, IllegalAccessException {
        if (FieldDeserializer.setFieldValue(field, object, value)) {
            return true;
        }
        try {
            Method setMethod = object.getClass().getDeclaredMethod("set" + getMethod.getName().substring(3), getMethod.getReturnType());
            setMethod.invoke(object, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean setFieldValue(Field field, Object object, Object value) throws IllegalAccessException {
        if (field != null && !Modifier.isFinal(field.getModifiers())) {
            field.set(object, value);
            return true;
        }
        return false;
    }
}

