/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myxml;

import com.antgroup.antchain.myjava.interop.Unmanaged;

public final class XmlCodec {
    private static String escapeSpecialChar(char c) {
        switch (c) {
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    private static String unescapeSpecialChar(String xmlTextChars) {
        if ("&quot;".equals(xmlTextChars)) {
            return "\"";
        }
        if ("&apos;".equals(xmlTextChars)) {
            return "'";
        }
        if ("&lt;".equals(xmlTextChars)) {
            return "<";
        }
        if ("&gt;".equals(xmlTextChars)) {
            return ">";
        }
        if ("&amp;".equals(xmlTextChars)) {
            return "&";
        }
        return xmlTextChars;
    }

    public static String escapeXmlText(String string) {
        StringBuilder builder = new StringBuilder();
        for (char c : string.toCharArray()) {
            String xmlTextOfChar = XmlCodec.escapeSpecialChar(c);
            if (xmlTextOfChar == null) {
                builder.append(c);
                continue;
            }
            builder.append(xmlTextOfChar);
        }
        return builder.toString();
    }

    @Unmanaged
    private static boolean isLessThanSpecialXml(char[] xmlTextChars, int position) {
        int total = xmlTextChars.length;
        return total - position >= 4 && xmlTextChars[position + 1] == 'l' && xmlTextChars[position + 2] == 't' && xmlTextChars[position + 3] == ';';
    }

    @Unmanaged
    private static boolean isGreatThanSpecialXml(char[] xmlTextChars, int position) {
        int total = xmlTextChars.length;
        return total - position >= 4 && xmlTextChars[position + 1] == 'g' && xmlTextChars[position + 2] == 't' && xmlTextChars[position + 3] == ';';
    }

    @Unmanaged
    private static boolean isAmpSpecialXml(char[] xmlTextChars, int position) {
        int total = xmlTextChars.length;
        return total - position >= 5 && xmlTextChars[position + 1] == 'a' && xmlTextChars[position + 2] == 'm' && xmlTextChars[position + 3] == 'p' && xmlTextChars[position + 4] == ';';
    }

    @Unmanaged
    private static boolean isQuotSpecialXml(char[] xmlTextChars, int position) {
        int total = xmlTextChars.length;
        return total - position >= 6 && xmlTextChars[position + 1] == 'q' && xmlTextChars[position + 2] == 'u' && xmlTextChars[position + 3] == 'o' && xmlTextChars[position + 4] == 't' && xmlTextChars[position + 5] == ';';
    }

    @Unmanaged
    private static boolean isAposSpecialXml(char[] xmlTextChars, int position) {
        int total = xmlTextChars.length;
        return total - position >= 6 && xmlTextChars[position + 1] == 'a' && xmlTextChars[position + 2] == 'p' && xmlTextChars[position + 3] == 'o' && xmlTextChars[position + 4] == 's' && xmlTextChars[position + 5] == ';';
    }

    private static int getBeginningSpecialXmlTextLength(char[] xmlTextChars, int position) {
        int total = xmlTextChars.length;
        if (position >= total || xmlTextChars[position] != '&') {
            return 0;
        }
        if (total - position < 4) {
            return 0;
        }
        if (XmlCodec.isLessThanSpecialXml(xmlTextChars, position)) {
            return "&lt;".length();
        }
        if (XmlCodec.isGreatThanSpecialXml(xmlTextChars, position)) {
            return "&gt;".length();
        }
        if (total - position < 5) {
            return 0;
        }
        if (XmlCodec.isAmpSpecialXml(xmlTextChars, position)) {
            return "&amp;".length();
        }
        if (total - position < 6) {
            return 0;
        }
        if (XmlCodec.isQuotSpecialXml(xmlTextChars, position)) {
            return "&quot;".length();
        }
        if (XmlCodec.isAposSpecialXml(xmlTextChars, position)) {
            return "&apos;".length();
        }
        return 0;
    }

    public static String unescapeXmlText(String xmlText) {
        if (!xmlText.contains("&")) {
            return xmlText;
        }
        char[] xmlTextChars = xmlText.toCharArray();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < xmlTextChars.length) {
            int xmlSpecialTextLength = XmlCodec.getBeginningSpecialXmlTextLength(xmlTextChars, i);
            if (xmlSpecialTextLength <= 0) {
                builder.append(xmlTextChars[i]);
                ++i;
                continue;
            }
            builder.append(XmlCodec.unescapeSpecialChar(new String(xmlTextChars, i, xmlSpecialTextLength)));
            i += xmlSpecialTextLength;
        }
        return builder.toString();
    }
}

