/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSON;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import com.antgroup.antchain.myjson.util.IOUtils;
import com.antgroup.antchain.myjson.util.RyuDouble;
import com.antgroup.antchain.myjson.util.RyuFloat;
import java.util.List;

@NoMetadata
public final class SerializeWriter {
    private static char[] bufLocal = null;
    private static int BUFFER_THRESHOLD = 131072;
    protected char[] buf;
    protected int count;
    protected int features;
    protected boolean quoteFieldNames;
    protected boolean sortField;
    protected boolean disableCircularReferenceDetect;
    protected boolean beanToArray;
    protected boolean writeNonStringValueAsString;
    protected boolean notWriteDefaultValue;
    protected boolean writeDirect;
    protected char keySeperator;
    protected int maxBufSize = -1;
    protected long sepcialBits;
    static final int nonDirectFeatures = 0 | SerializerFeature.BrowserCompatible.mask | SerializerFeature.WriteNonStringValueAsString.mask | SerializerFeature.IgnoreErrorGetter.mask | SerializerFeature.NotWriteDefaultValue.mask;

    private static void cpdBegin() {
    }

    public SerializeWriter() {
        this(JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
    }

    public SerializeWriter(SerializerFeature ... features) {
        this(0, features);
    }

    public SerializeWriter(int defaultFeatures, SerializerFeature ... features) {
        this.buf = bufLocal;
        if (this.buf != null) {
            bufLocal = null;
        } else {
            this.buf = new char[2048];
        }
        int featuresValue = defaultFeatures;
        for (SerializerFeature feature : features) {
            featuresValue |= feature.getMask();
        }
        this.features = featuresValue;
        this.computeFeatures();
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void setMaxBufSize(int maxBufSize) {
        if (maxBufSize < this.buf.length) {
            throw new JSONException("must > " + this.buf.length);
        }
        this.maxBufSize = maxBufSize;
    }

    public int getBufferLength() {
        return this.buf.length;
    }

    public SerializeWriter(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
        this.computeFeatures();
    }

    public void config(SerializerFeature feature, boolean state) {
        this.features = state ? (this.features |= feature.getMask()) : (this.features &= ~feature.getMask());
        this.computeFeatures();
    }

    protected void computeFeatures() {
        this.quoteFieldNames = (this.features & SerializerFeature.QuoteFieldNames.mask) != 0;
        this.sortField = (this.features & SerializerFeature.SortField.mask) != 0;
        this.disableCircularReferenceDetect = (this.features & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
        this.beanToArray = (this.features & SerializerFeature.BeanToArray.mask) != 0;
        this.writeNonStringValueAsString = (this.features & SerializerFeature.WriteNonStringValueAsString.mask) != 0;
        this.notWriteDefaultValue = (this.features & SerializerFeature.NotWriteDefaultValue.mask) != 0;
        this.writeDirect = this.quoteFieldNames && (this.features & nonDirectFeatures) == 0 && this.beanToArray;
        this.keySeperator = (char)34;
        long S0 = 0x4FFFFFFFFL;
        this.sepcialBits = 0x4FFFFFFFFL;
    }

    public boolean isEnabled(SerializerFeature feature) {
        return (this.features & feature.mask) != 0;
    }

    public boolean isEnabled(int feature) {
        return (this.features & feature) != 0;
    }

    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void expandCapacity(int minimumCapacity) {
        char[] charsLocal;
        if (this.maxBufSize != -1 && minimumCapacity >= this.maxBufSize) {
            throw new JSONException("serialize exceeded MAX_OUTPUT_LENGTH=" + this.maxBufSize + ", minimumCapacity=" + minimumCapacity);
        }
        int newCapacity = this.buf.length + (this.buf.length >> 1) + 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        if (this.buf.length < BUFFER_THRESHOLD && ((charsLocal = bufLocal) == null || charsLocal.length < this.buf.length)) {
            bufLocal = this.buf;
        }
        this.buf = newValue;
    }

    public SerializeWriter append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    public SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public void close() {
        if (this.buf.length <= BUFFER_THRESHOLD) {
            bufLocal = this.buf;
        }
        this.buf = null;
    }

    public void write(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        this.write(text, 0, text.length());
    }

    public void writeInt(int i) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int size = i < 0 ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeByteArray(byte[] bytes) {
        int bytesLen = bytes.length;
        int quote = 34;
        if (bytesLen == 0) {
            String emptyString = "\"\"";
            this.write(emptyString);
            return;
        }
        char[] CA = IOUtils.CA;
        int eLen = bytesLen / 3 * 3;
        int charsLen = (bytesLen - 1) / 3 + 1 << 2;
        int offset = this.count;
        int newcount = this.count + charsLen + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        this.buf[offset++] = 34;
        int s = 0;
        int d = offset;
        while (s < eLen) {
            int i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.buf[d++] = CA[i >>> 18 & 0x3F];
            this.buf[d++] = CA[i >>> 12 & 0x3F];
            this.buf[d++] = CA[i >>> 6 & 0x3F];
            this.buf[d++] = CA[i & 0x3F];
        }
        int left = bytesLen - eLen;
        if (left > 0) {
            int i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytesLen - 1] & 0xFF) << 2 : 0);
            this.buf[newcount - 5] = CA[i >> 12];
            this.buf[newcount - 4] = CA[i >>> 6 & 0x3F];
            this.buf[newcount - 3] = left == 2 ? CA[i & 0x3F] : 61;
            this.buf[newcount - 2] = 61;
        }
        this.buf[newcount - 1] = 34;
    }

    public void writeFloat(float value, boolean checkWriteClassName) {
        if (value != value || Float.isInfinite(value)) {
            this.writeNull();
        } else {
            int newcount = this.count + 15;
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            int len = RyuFloat.toString(value, this.buf, this.count);
            this.count += len;
        }
    }

    public void writeDouble(double value, boolean checkWriteClassName) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.writeNull();
            return;
        }
        int newcount = this.count + 24;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int len = RyuDouble.toString(value, this.buf, this.count);
        this.count += len;
    }

    public void writeLong(long i) {
        boolean needQuotationMark;
        boolean bl = needQuotationMark = this.isEnabled(SerializerFeature.BrowserCompatible) && (i > 0x1FFFFFFFFFFFFFL || i < -9007199254740991L);
        if (i == Long.MIN_VALUE) {
            if (needQuotationMark) {
                this.write("\"-9223372036854775808\"");
            } else {
                this.write("-9223372036854775808");
            }
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (needQuotationMark) {
            newcount += 2;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        if (needQuotationMark) {
            this.buf[this.count] = 34;
            IOUtils.getChars(i, newcount - 1, this.buf);
            this.buf[newcount - 1] = 34;
        } else {
            IOUtils.getChars(i, newcount, this.buf);
        }
        this.count = newcount;
    }

    public void writeNull() {
        this.write("null");
    }

    public void writeNull(SerializerFeature feature) {
        this.writeNull(0, feature.mask);
    }

    public void writeNull(int beanFeatures, int feature) {
        if ((beanFeatures & feature) == 0 && (this.features & feature) == 0) {
            this.writeNull();
            return;
        }
        if (feature == SerializerFeature.WriteNullListAsEmpty.mask) {
            this.write("[]");
        } else if (feature == SerializerFeature.WriteNullStringAsEmpty.mask) {
            this.writeString("");
        } else if (feature == SerializerFeature.WriteNullBooleanAsFalse.mask) {
            this.write("false");
        } else if (feature == SerializerFeature.WriteNullNumberAsZero.mask) {
            this.write(48);
        } else {
            this.writeNull();
        }
    }

    public void writeStringWithDoubleQuote(String text, char seperator) {
        if (text == null) {
            this.writeNull();
            if (seperator != '\u0000') {
                this.write(seperator);
            }
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (seperator != '\u0000') {
            ++newcount;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char ch;
            int i;
            int lastSpecialIndex = -1;
            for (i = start; i < end; ++i) {
                ch = this.buf[i];
                if (ch == '\"' || ch == '/' || ch == '\\') {
                    lastSpecialIndex = i;
                    ++newcount;
                    continue;
                }
                if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t') {
                    lastSpecialIndex = i;
                    ++newcount;
                    continue;
                }
                if (ch < ' ') {
                    lastSpecialIndex = i;
                    newcount += 5;
                    continue;
                }
                if (ch < '\u007f') continue;
                lastSpecialIndex = i;
                newcount += 5;
            }
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            for (i = lastSpecialIndex; i >= start; --i) {
                ch = this.buf[i];
                if (ch == '\b' || ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = IOUtils.replaceChars[ch];
                    ++end;
                    continue;
                }
                if (ch == '\"' || ch == '/' || ch == '\\') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = ch;
                    ++end;
                    continue;
                }
                if (ch < ' ') {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 6, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = 117;
                    this.buf[i + 2] = 48;
                    this.buf[i + 3] = 48;
                    this.buf[i + 4] = IOUtils.ASCII_CHARS[ch * 2];
                    this.buf[i + 5] = IOUtils.ASCII_CHARS[ch * 2 + 1];
                    end += 5;
                    continue;
                }
                if (ch < '\u007f') continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 6, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = 117;
                this.buf[i + 2] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                this.buf[i + 3] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                this.buf[i + 4] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                this.buf[i + 5] = IOUtils.DIGITS[ch & 0xF];
                end += 5;
            }
            if (seperator != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = seperator;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int specialCount = 0;
        int lastSpecialIndex = -1;
        int firstSpecialIndex = -1;
        int lastSpecial = 0;
        for (int i = start; i < end; ++i) {
            boolean special;
            int ch = this.buf[i];
            if (ch >= 93) {
                if (ch < 127 || ch != 8232 && ch != 8233 && ch >= 160) continue;
                if (firstSpecialIndex == -1) {
                    firstSpecialIndex = i;
                }
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
                newcount += 4;
                continue;
            }
            boolean bl = special = ch < 64 && (this.sepcialBits & 1L << ch) != 0L || ch == 92;
            if (!special) continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
            if (ch == 40 || ch == 41 || ch == 60 || ch == 62 || ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                newcount += 4;
            }
            if (firstSpecialIndex != -1) continue;
            firstSpecialIndex = i;
        }
        if (specialCount > 0) {
            if ((newcount += specialCount) > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            if (specialCount == 1) {
                int LengthOfCopy;
                int destPos;
                int srcPos;
                if (lastSpecial == 8232) {
                    srcPos = lastSpecialIndex + 1;
                    destPos = lastSpecialIndex + 6;
                    LengthOfCopy = end - lastSpecialIndex - 1;
                    System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = 117;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 48;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 56;
                } else if (lastSpecial == 8233) {
                    srcPos = lastSpecialIndex + 1;
                    destPos = lastSpecialIndex + 6;
                    LengthOfCopy = end - lastSpecialIndex - 1;
                    System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = 117;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 48;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 57;
                } else if (lastSpecial == 40 || lastSpecial == 41 || lastSpecial == 60 || lastSpecial == 62) {
                    srcPos = lastSpecialIndex + 1;
                    destPos = lastSpecialIndex + 6;
                    LengthOfCopy = end - lastSpecialIndex - 1;
                    System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = 117;
                    int ch = lastSpecial;
                    this.buf[++lastSpecialIndex] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                    this.buf[++lastSpecialIndex] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                    this.buf[++lastSpecialIndex] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                    this.buf[++lastSpecialIndex] = IOUtils.DIGITS[ch & 0xF];
                } else {
                    int destPos2;
                    int srcPos2;
                    int ch = lastSpecial;
                    if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                        srcPos2 = lastSpecialIndex + 1;
                        destPos2 = lastSpecialIndex + 6;
                        int LengthOfCopy2 = end - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos2, this.buf, destPos2, LengthOfCopy2);
                        int bufIndex = lastSpecialIndex;
                        this.buf[bufIndex++] = 92;
                        this.buf[bufIndex++] = 117;
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                    } else {
                        srcPos2 = lastSpecialIndex + 1;
                        destPos2 = lastSpecialIndex + 2;
                        int LengthOfCopy3 = end - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos2, this.buf, destPos2, LengthOfCopy3);
                        this.buf[lastSpecialIndex] = 92;
                        this.buf[++lastSpecialIndex] = IOUtils.replaceChars[ch];
                    }
                }
            } else if (specialCount > 1) {
                int textIndex = firstSpecialIndex - start;
                int bufIndex = firstSpecialIndex;
                for (int i = textIndex; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] != 0) {
                        this.buf[bufIndex++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                            end += 5;
                            continue;
                        }
                        this.buf[bufIndex++] = IOUtils.replaceChars[ch];
                        ++end;
                        continue;
                    }
                    if (ch == '\u2028' || ch == '\u2029') {
                        bufIndex = this.writeUnicode2028AndUnicode2029CharOf6Bytes(this.buf, bufIndex, ch);
                        end += 5;
                        continue;
                    }
                    this.buf[bufIndex++] = ch;
                }
            }
        }
        if (seperator != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = seperator;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    private int writeUnicode2028AndUnicode2029CharOf6Bytes(char[] buf, int bufIndex, char ch) {
        buf[bufIndex++] = 92;
        buf[bufIndex++] = 117;
        buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
        buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
        buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
        buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
        return bufIndex;
    }

    public void write(List<String> list) {
        int offset;
        if (list.isEmpty()) {
            this.write("[]");
            return;
        }
        int initOffset = offset = this.count;
        int list_size = list.size();
        for (int i = 0; i < list_size; ++i) {
            int j;
            String text = list.get(i);
            boolean hasSpecial = false;
            if (text == null) {
                hasSpecial = true;
            } else {
                char ch;
                int len = text.length();
                for (j = 0; j < len && !(hasSpecial = (ch = text.charAt(j)) < ' ' || ch > '~' || ch == '\"' || ch == '\\'); ++j) {
                }
            }
            if (hasSpecial) {
                this.count = initOffset;
                this.write(91);
                for (j = 0; j < list.size(); ++j) {
                    text = list.get(j);
                    if (j != 0) {
                        this.write(44);
                    }
                    if (text == null) {
                        this.write("null");
                        continue;
                    }
                    this.writeStringWithDoubleQuote(text, '\u0000');
                }
                this.write(93);
                return;
            }
            int newcount = offset + text.length() + 3;
            if (i == list.size() - 1) {
                ++newcount;
            }
            if (newcount > this.buf.length) {
                this.count = offset;
                this.expandCapacity(newcount);
            }
            this.buf[offset++] = i == 0 ? 91 : 44;
            this.buf[offset++] = 34;
            text.getChars(0, text.length(), this.buf, offset);
            offset += text.length();
            this.buf[offset++] = 34;
        }
        this.buf[offset++] = 93;
        this.count = offset;
    }

    public void write(boolean value) {
        if (value) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValueStringWithDoubleQuoteCheck(char seperator, String name, String value) {
        int valueLen;
        int nameLen = name.length();
        int newcount = this.count;
        if (value == null) {
            valueLen = 4;
            newcount += nameLen + 8;
        } else {
            valueLen = value.length();
            newcount += nameLen + valueLen + 6;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = seperator;
        int nameStart = this.count + 2;
        int nameEnd = nameStart + nameLen;
        this.buf[this.count + 1] = 34;
        name.getChars(0, nameLen, this.buf, nameStart);
        this.count = newcount;
        this.buf[nameEnd] = 34;
        int index = nameEnd + 1;
        this.buf[index++] = 58;
        if (value == null) {
            this.buf[index++] = 110;
            this.buf[index++] = 117;
            this.buf[index++] = 108;
            this.buf[index++] = 108;
            return;
        }
        this.buf[index++] = 34;
        int valueStart = index;
        int valueEnd = valueStart + valueLen;
        value.getChars(0, valueLen, this.buf, valueStart);
        int specialCount = 0;
        int lastSpecialIndex = -1;
        int firstSpecialIndex = -1;
        int lastSpecial = 0;
        for (int i = valueStart; i < valueEnd; ++i) {
            boolean special;
            int ch = this.buf[i];
            if (ch >= 93) {
                if (ch < 127 || ch != 8232 && ch != 8233 && ch >= 160) continue;
                if (firstSpecialIndex == -1) {
                    firstSpecialIndex = i;
                }
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
                newcount += 4;
                continue;
            }
            boolean bl = special = ch < 64 && (this.sepcialBits & 1L << ch) != 0L || ch == 92;
            if (!special) continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
            if (ch == 40 || ch == 41 || ch == 60 || ch == 62 || ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                newcount += 4;
            }
            if (firstSpecialIndex != -1) continue;
            firstSpecialIndex = i;
        }
        if (specialCount > 0) {
            if ((newcount += specialCount) > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            if (specialCount == 1) {
                int destPos;
                int srcPos;
                int ch;
                int LengthOfCopy;
                int destPos2;
                int srcPos2;
                if (lastSpecial == 8232) {
                    srcPos2 = lastSpecialIndex + 1;
                    destPos2 = lastSpecialIndex + 6;
                    LengthOfCopy = valueEnd - lastSpecialIndex - 1;
                    System.arraycopy(this.buf, srcPos2, this.buf, destPos2, LengthOfCopy);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = 117;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 48;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 56;
                } else if (lastSpecial == 8233) {
                    srcPos2 = lastSpecialIndex + 1;
                    destPos2 = lastSpecialIndex + 6;
                    LengthOfCopy = valueEnd - lastSpecialIndex - 1;
                    System.arraycopy(this.buf, srcPos2, this.buf, destPos2, LengthOfCopy);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = 117;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 48;
                    this.buf[++lastSpecialIndex] = 50;
                    this.buf[++lastSpecialIndex] = 57;
                } else if (lastSpecial == 40 || lastSpecial == 41 || lastSpecial == 60 || lastSpecial == 62) {
                    ch = lastSpecial;
                    srcPos = lastSpecialIndex + 1;
                    destPos = lastSpecialIndex + 6;
                    int LengthOfCopy2 = valueEnd - lastSpecialIndex - 1;
                    System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy2);
                    int bufIndex = lastSpecialIndex;
                    this.buf[bufIndex++] = 92;
                    this.buf[bufIndex++] = 117;
                    this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                    this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                    this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                    this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                } else {
                    ch = lastSpecial;
                    if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                        srcPos = lastSpecialIndex + 1;
                        destPos = lastSpecialIndex + 6;
                        int LengthOfCopy3 = valueEnd - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy3);
                        int bufIndex = lastSpecialIndex;
                        this.buf[bufIndex++] = 92;
                        this.buf[bufIndex++] = 117;
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                        this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                    } else {
                        srcPos = lastSpecialIndex + 1;
                        destPos = lastSpecialIndex + 2;
                        int LengthOfCopy4 = valueEnd - lastSpecialIndex - 1;
                        System.arraycopy(this.buf, srcPos, this.buf, destPos, LengthOfCopy4);
                        this.buf[lastSpecialIndex] = 92;
                        this.buf[++lastSpecialIndex] = IOUtils.replaceChars[ch];
                    }
                }
            } else if (specialCount > 1) {
                int textIndex = firstSpecialIndex - valueStart;
                int bufIndex = firstSpecialIndex;
                for (int i = textIndex; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[ch] != 0) {
                        this.buf[bufIndex++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[ch] == 4) {
                            this.buf[bufIndex++] = 117;
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 12 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 8 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch >>> 4 & 0xF];
                            this.buf[bufIndex++] = IOUtils.DIGITS[ch & 0xF];
                            valueEnd += 5;
                            continue;
                        }
                        this.buf[bufIndex++] = IOUtils.replaceChars[ch];
                        ++valueEnd;
                        continue;
                    }
                    if (ch == '\u2028' || ch == '\u2029') {
                        bufIndex = this.writeUnicode2028AndUnicode2029CharOf6Bytes(this.buf, bufIndex, ch);
                        valueEnd += 5;
                        continue;
                    }
                    this.buf[bufIndex++] = ch;
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeString(String text, char seperator) {
        this.writeStringWithDoubleQuote(text, seperator);
    }

    public void writeString(String text) {
        this.writeStringWithDoubleQuote(text, '\u0000');
    }

    public void writeString(char[] chars) {
        String text = new String(chars);
        this.writeStringWithDoubleQuote(text, '\u0000');
    }

    public void writeFieldName(String key) {
        this.writeFieldName(key, false);
    }

    public void writeFieldName(String key, boolean checkSpecial) {
        if (key == null) {
            this.write("null:");
            return;
        }
        if (this.quoteFieldNames) {
            this.writeStringWithDoubleQuote(key, ':');
        } else {
            boolean hashSpecial = key.length() == 0;
            for (int i = 0; i < key.length(); ++i) {
                boolean special;
                char ch = key.charAt(i);
                boolean bl = special = ch < '@' && (this.sepcialBits & 1L << ch) != 0L || ch == '\\';
                if (!special) continue;
                hashSpecial = true;
                break;
            }
            if (hashSpecial) {
                this.writeStringWithDoubleQuote(key, ':');
            } else {
                this.write(key);
                this.write(58);
            }
        }
    }

    private static void cpdEnd() {
    }
}

