/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

@NoMetadata
public class StringCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static StringCodec instance = new StringCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        this.write(serializer, (String)object);
    }

    public void write(JSONSerializer serializer, String value) {
        SerializeWriter out = serializer.out;
        if (value == null) {
            out.writeNull(SerializerFeature.WriteNullStringAsEmpty);
            return;
        }
        out.writeString(value);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return StringCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONScanner lexer = parser.getLexer();
        if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)val;
        }
        if (lexer.token() == 2) {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)val;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)value.toString();
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

