/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myxml;

import com.antgroup.antchain.myxml.XmlAttribute;
import com.antgroup.antchain.myxml.XmlCodec;
import com.antgroup.antchain.myxml.XmlDocument;
import com.antgroup.antchain.myxml.XmlElement;
import java.util.List;

public final class XmlWriter {
    private static void writeXmlAttribute(StringBuilder out, XmlAttribute attribute) {
        if (attribute == null) {
            return;
        }
        out.append(attribute.name);
        out.append("=");
        out.append("\"");
        String attrValueXmlText = XmlCodec.escapeXmlText(attribute.value != null ? attribute.value : "");
        out.append(attrValueXmlText);
        out.append("\"");
    }

    private static void writeXmlElement(StringBuilder out, XmlElement element) {
        if (element == null) {
            return;
        }
        out.append("<");
        out.append(element.name);
        if (element.getAttributes() != null) {
            for (XmlAttribute attribute : element.getAttributes()) {
                out.append(" ");
                XmlWriter.writeXmlAttribute(out, attribute);
            }
        }
        out.append(">");
        String textXmlFormat = XmlCodec.escapeXmlText(element.getContent() != null ? element.getContent() : "");
        out.append(textXmlFormat);
        List<XmlElement> children = element.getChildren();
        if (children != null) {
            for (XmlElement child : children) {
                XmlWriter.writeXmlElement(out, child);
            }
        }
        out.append("</");
        out.append(element.name);
        out.append(">");
    }

    public static String writeXmlDocumentToString(XmlDocument document) {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XmlWriter.writeXmlElement(builder, document.getRoot());
        return builder.toString();
    }
}

