/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.parser;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSON;
import com.antgroup.antchain.myjson.JSONArray;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.parser.Feature;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.JSONToken;
import com.antgroup.antchain.myjson.parser.ParseContext;
import com.antgroup.antchain.myjson.parser.ParserConfig;
import com.antgroup.antchain.myjson.parser.SymbolTable;
import com.antgroup.antchain.myjson.parser.deserializer.FieldDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.JavaBeanDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.ResolveFieldDeserializer;
import com.antgroup.antchain.myjson.serializer.IntegerCodec;
import com.antgroup.antchain.myjson.serializer.LongCodec;
import com.antgroup.antchain.myjson.serializer.StringCodec;
import java.io.Closeable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@NoMetadata
public class DefaultJSONParser
implements Closeable {
    public final Object input;
    public final SymbolTable symbolTable;
    protected ParserConfig config;
    private static final Set<Class<?>> primitiveClasses = new HashSet();
    public final JSONScanner lexer;
    protected ParseContext context;
    private ParseContext[] contextArray;
    private int contextArrayIndex = 0;
    private List<ResolveTask> resolveTaskList;
    public static final int NONE = 0;
    public static final int NeedToResolve = 1;
    public static final int TypeNameRedirect = 2;
    public int resolveStatus = 0;
    private int objectKeyLevel = 0;

    public DefaultJSONParser(String input) {
        this(input, ParserConfig.getGlobalInstance(), JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String input, ParserConfig config) {
        this((Object)input, new JSONScanner(input, JSON.DEFAULT_PARSER_FEATURE), config);
    }

    public DefaultJSONParser(String input, ParserConfig config, int features) {
        this((Object)input, new JSONScanner(input, features), config);
    }

    public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
        this(input, new JSONScanner(input, length, features), config);
    }

    public DefaultJSONParser(JSONScanner lexer) {
        this(lexer, ParserConfig.getGlobalInstance());
    }

    public DefaultJSONParser(JSONScanner lexer, ParserConfig config) {
        this(null, lexer, config);
    }

    public DefaultJSONParser(Object input, JSONScanner lexer, ParserConfig config) {
        this.lexer = lexer;
        this.input = input;
        this.config = config;
        this.symbolTable = config.symbolTable;
        char ch = lexer.getCurrent();
        if (ch == '{') {
            lexer.next();
            lexer.token = 12;
        } else if (ch == '[') {
            lexer.next();
            lexer.token = 14;
        } else {
            lexer.nextToken();
        }
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    public final Object parseObject(Map object, Object fieldName) {
        JSONScanner lexer = this.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        if (lexer.token() == 13) {
            lexer.nextToken();
            return object;
        }
        if (lexer.token() == 4 && lexer.stringVal().length() == 0) {
            lexer.nextToken();
            return object;
        }
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName() + ", " + lexer.info());
        }
        Object context = this.context;
        try {
            Map<String, Object> map;
            Object value;
            Object key;
            char ch;
            boolean isJsonObjectMap = object instanceof JSONObject;
            Map<String, Object> map2 = isJsonObjectMap ? ((JSONObject)object).getInnerMap() : object;
            boolean setContextFlag = false;
            while (true) {
                Object contextR;
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (ch == ',') {
                        lexer.next();
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                    }
                }
                boolean isObjectKey = false;
                if (ch == '\"') {
                    key = lexer.scanSymbol(this.symbolTable, '\"');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                    }
                } else {
                    if (ch == '}') {
                        lexer.next();
                        lexer.resetStringPosition();
                        lexer.nextToken();
                        if (!setContextFlag) {
                            if (this.context != null && fieldName == this.context.fieldName && object == this.context.object) {
                                context = this.context;
                            } else {
                                contextR = this.setContext(object, fieldName);
                                if (context == null) {
                                    context = contextR;
                                }
                                setContextFlag = true;
                            }
                        }
                        contextR = object;
                        return contextR;
                    }
                    if (ch == '\'') {
                        if (!lexer.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbol(this.symbolTable, '\'');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if (ch == '\u001a') {
                            throw new JSONException("syntax error");
                        }
                        if (ch == ',') {
                            throw new JSONException("syntax error");
                        }
                        if (ch >= '0' && ch <= '9' || ch == '-') {
                            lexer.resetStringPosition();
                            lexer.scanNumber();
                            try {
                                key = lexer.token() == 2 ? (Number)lexer.integerValue() : (Number)lexer.decimalValue(true);
                                if (isJsonObjectMap) {
                                    key = key.toString();
                                }
                            }
                            catch (Exception e) {
                                throw new JSONException("parse number key error" + lexer.info() + " " + e.getMessage());
                            }
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("parse number key error" + lexer.info());
                            }
                        } else if (ch == '{' || ch == '[') {
                            if (this.objectKeyLevel++ > 512) {
                                throw new JSONException("object key level > 512");
                            }
                            lexer.nextToken();
                            key = this.parse();
                            isObjectKey = true;
                        } else {
                            if (!lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                throw new JSONException("syntax error");
                            }
                            key = lexer.scanSymbolUnQuoted(this.symbolTable);
                            lexer.skipWhitespace();
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                            }
                        }
                    }
                }
                if (!isObjectKey) {
                    lexer.next();
                    lexer.skipWhitespace();
                }
                ch = lexer.getCurrent();
                lexer.resetStringPosition();
                if (!setContextFlag) {
                    if (this.context != null && fieldName == this.context.fieldName && object == this.context.object) {
                        context = this.context;
                    } else {
                        contextR = this.setContext(object, fieldName);
                        if (context == null) {
                            context = contextR;
                        }
                        setContextFlag = true;
                    }
                }
                if (object.getClass() == JSONObject.class && key == null) {
                    key = "null";
                }
                if (ch == '\"') {
                    lexer.scanString();
                    String strValue = lexer.stringVal();
                    value = strValue;
                    map2.put((String)key, value);
                } else if (ch >= '0' && ch <= '9' || ch == '-') {
                    lexer.scanNumber();
                    value = lexer.token() == 2 ? (Number)lexer.integerValue() : (Number)lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
                    map2.put((String)key, value);
                } else {
                    if (ch == '[') {
                        lexer.nextToken();
                        JSONArray list = new JSONArray();
                        if (fieldName == null) {
                            this.setContext((ParseContext)context);
                        }
                        this.parseArray(list, key);
                        value = lexer.isEnabled(Feature.UseObjectArray) ? list.toArray() : list;
                        map2.put((String)key, value);
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            Map<String, Object> map3 = object;
                            return map3;
                        }
                        if (lexer.token() == 16) continue;
                        throw new JSONException("syntax error");
                    }
                    if (ch == '{') {
                        lexer.nextToken();
                        boolean parentIsArray = fieldName != null && fieldName.getClass() == Integer.class;
                        JSONObject input = new JSONObject();
                        ParseContext ctxLocal = null;
                        if (!parentIsArray) {
                            ctxLocal = this.setContext(this.context, input, key);
                        }
                        Object obj = null;
                        boolean objParsed = false;
                        if (!objParsed) {
                            obj = this.parseObject(input, key);
                        }
                        if (ctxLocal != null && input != obj) {
                            ctxLocal.object = object;
                        }
                        if (key != null) {
                            this.checkMapResolve(object, key.toString());
                        }
                        map2.put((String)key, obj);
                        if (parentIsArray) {
                            this.setContext(obj, key);
                        }
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            this.setContext((ParseContext)context);
                            Map<String, Object> map4 = object;
                            return map4;
                        }
                        if (lexer.token() == 16) {
                            if (parentIsArray) {
                                this.popContext();
                                continue;
                            }
                            this.setContext((ParseContext)context);
                            continue;
                        }
                        throw new JSONException("syntax error, " + lexer.tokenName());
                    }
                    lexer.nextToken();
                    value = this.parse();
                    map2.put((String)key, value);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        map = object;
                        return map;
                    }
                    if (lexer.token() == 16) continue;
                    throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                }
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ',') break;
                lexer.next();
            }
            if (ch == '}') {
                lexer.next();
                lexer.resetStringPosition();
                lexer.nextToken();
                this.setContext(value, key);
                map = object;
                return map;
            }
            throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
        }
        finally {
            this.setContext((ParseContext)context);
        }
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(ParserConfig config) {
        this.config = config;
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject(clazz, null);
    }

    public <T> T parseObject(Type type) {
        return this.parseObject(type, null);
    }

    public <T> T parseObject(Type type, Object fieldName) {
        int token = this.lexer.token();
        if (token == 8) {
            this.lexer.nextToken();
            return null;
        }
        if (token == 4) {
            if (type == byte[].class) {
                byte[] bytes = this.lexer.bytesValue();
                this.lexer.nextToken();
                return (T)bytes;
            }
            if (type == char[].class) {
                String strVal = this.lexer.stringVal();
                this.lexer.nextToken();
                return (T)strVal.toCharArray();
            }
        }
        ObjectDeserializer deserializer = this.config.getDeserializer(type);
        try {
            if (deserializer.getClass() == JavaBeanDeserializer.class) {
                if (this.lexer.token() != 12 && this.lexer.token() != 14) {
                    throw new JSONException("syntax error,expect start with { or [,but actually start with " + this.lexer.tokenName());
                }
                return ((JavaBeanDeserializer)deserializer).deserialze(this, type, fieldName, 0);
            }
            return deserializer.deserialze(this, type, fieldName);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    public void parseArray(Type type, Collection array) {
        this.parseArray(type, array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArray(Type type, Collection array, Object fieldName) {
        int token = this.lexer.token();
        if (token != 14) {
            throw new JSONException("field " + fieldName + " expect '[', but " + JSONToken.name(token) + ", " + this.lexer.info());
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerCodec.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringCodec.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        ParseContext context = this.context;
        this.setContext(array, fieldName);
        try {
            int i = 0;
            while (true) {
                Object val;
                if (this.lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (this.lexer.token() == 16) {
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.token() == 15) {
                    break;
                }
                if (Integer.TYPE == type) {
                    val = IntegerCodec.instance.deserialze(this, null, null);
                    array.add(val);
                } else if (String.class == type) {
                    String value;
                    if (this.lexer.token() == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        Object obj = this.parse();
                        value = obj == null ? null : obj.toString();
                    }
                    array.add(value);
                } else {
                    if (this.lexer.token() == 8) {
                        this.lexer.nextToken();
                        val = null;
                    } else {
                        val = deserializer.deserialze(this, type, i);
                    }
                    array.add(val);
                    this.checkListResolve(array);
                }
                if (this.lexer.token() == 16) {
                    this.lexer.nextToken(deserializer.getFastMatchToken());
                }
                ++i;
            }
        }
        finally {
            this.setContext(context);
        }
        this.lexer.nextToken(16);
    }

    public void parseObject(Object object) {
        block14: {
            Class<?> clazz = object.getClass();
            JavaBeanDeserializer beanDeser = null;
            ObjectDeserializer deserializer = this.config.getDeserializer(clazz);
            if (deserializer instanceof JavaBeanDeserializer) {
                beanDeser = (JavaBeanDeserializer)deserializer;
            }
            if (this.lexer.token() != 12 && this.lexer.token() != 16) {
                throw new JSONException("syntax error, expect {, actual " + this.lexer.tokenName());
            }
            while (true) {
                Object fieldValue;
                String key;
                if ((key = this.lexer.scanSymbol(this.symbolTable)) == null) {
                    if (this.lexer.token() != 13) {
                        if (this.lexer.token() == 16 && this.lexer.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    break block14;
                }
                FieldDeserializer fieldDeser = null;
                if (beanDeser != null) {
                    fieldDeser = beanDeser.getFieldDeserializer(key);
                }
                if (fieldDeser == null) {
                    if (!this.lexer.isEnabled(Feature.IgnoreNotMatch)) {
                        throw new JSONException("setter not found, class " + clazz.getName() + ", property " + key);
                    }
                    this.lexer.nextTokenWithColon();
                    this.parse();
                    if (this.lexer.token() != 13) continue;
                    this.lexer.nextToken();
                    return;
                }
                Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
                Type fieldType = fieldDeser.fieldInfo.fieldType;
                if (fieldClass == Integer.TYPE) {
                    this.lexer.nextTokenWithColon(2);
                    fieldValue = IntegerCodec.instance.deserialze(this, fieldType, null);
                } else if (fieldClass == String.class) {
                    this.lexer.nextTokenWithColon(4);
                    fieldValue = StringCodec.deserialze(this);
                } else if (fieldClass == Long.TYPE) {
                    this.lexer.nextTokenWithColon(2);
                    fieldValue = LongCodec.instance.deserialze(this, fieldType, null);
                } else {
                    ObjectDeserializer fieldValueDeserializer = this.config.getDeserializer(fieldClass, fieldType);
                    this.lexer.nextTokenWithColon(fieldValueDeserializer.getFastMatchToken());
                    fieldValue = fieldValueDeserializer.deserialze(this, fieldType, null);
                }
                fieldDeser.setValue(object, fieldValue);
                if (this.lexer.token() != 16 && this.lexer.token() == 13) break;
            }
            this.lexer.nextToken(16);
            return;
        }
        this.lexer.nextToken(16);
    }

    public int getResolveStatus() {
        return this.resolveStatus;
    }

    public void setResolveStatus(int resolveStatus) {
        this.resolveStatus = resolveStatus;
    }

    public Object getObject(String path) {
        for (int i = 0; i < this.contextArrayIndex; ++i) {
            if (!path.equals(this.contextArray[i].toString())) continue;
            return this.contextArray[i].object;
        }
        return null;
    }

    public void checkListResolve(Collection array) {
        if (this.resolveStatus == 1) {
            if (array instanceof List) {
                int index = array.size() - 1;
                List list = (List)array;
                ResolveTask task = this.getLastResolveTask();
                task.fieldDeserializer = new ResolveFieldDeserializer(this, list, index);
                task.ownerContext = this.context;
                this.setResolveStatus(0);
            } else {
                ResolveTask task = this.getLastResolveTask();
                task.fieldDeserializer = new ResolveFieldDeserializer(array);
                task.ownerContext = this.context;
                this.setResolveStatus(0);
            }
        }
    }

    public void checkMapResolve(Map object, Object fieldName) {
        if (this.resolveStatus == 1) {
            ResolveFieldDeserializer fieldResolver = new ResolveFieldDeserializer(object, fieldName);
            ResolveTask task = this.getLastResolveTask();
            task.fieldDeserializer = fieldResolver;
            task.ownerContext = this.context;
            this.setResolveStatus(0);
        }
    }

    public Object parseObject(Map object) {
        return this.parseObject(object, null);
    }

    public JSONObject parseObject() {
        JSONObject object = new JSONObject();
        Object parsedObject = this.parseObject(object);
        if (parsedObject instanceof JSONObject) {
            return (JSONObject)parsedObject;
        }
        if (parsedObject == null) {
            return null;
        }
        return new JSONObject((Map)parsedObject);
    }

    public final void parseArray(Collection array) {
        this.parseArray(array, null);
    }

    /*
     * Exception decompiling
     */
    public final void parseArray(Collection array, Object fieldName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ParseContext getContext() {
        return this.context;
    }

    public List<ResolveTask> getResolveTaskList() {
        if (this.resolveTaskList == null) {
            this.resolveTaskList = new ArrayList<ResolveTask>(2);
        }
        return this.resolveTaskList;
    }

    public void addResolveTask(ResolveTask task) {
        if (this.resolveTaskList == null) {
            this.resolveTaskList = new ArrayList<ResolveTask>(2);
        }
        this.resolveTaskList.add(task);
    }

    public ResolveTask getLastResolveTask() {
        return this.resolveTaskList.get(this.resolveTaskList.size() - 1);
    }

    public void setContext(ParseContext context) {
        this.context = context;
    }

    public void popContext() {
        this.context = this.context.parent;
        if (this.contextArrayIndex <= 0) {
            return;
        }
        --this.contextArrayIndex;
        this.contextArray[this.contextArrayIndex] = null;
    }

    public ParseContext setContext(Object object, Object fieldName) {
        return this.setContext(this.context, object, fieldName);
    }

    public ParseContext setContext(ParseContext parent, Object object, Object fieldName) {
        this.context = new ParseContext(parent, object, fieldName);
        this.addContext(this.context);
        return this.context;
    }

    private void addContext(ParseContext context) {
        int i = this.contextArrayIndex++;
        if (this.contextArray == null) {
            this.contextArray = new ParseContext[8];
        } else if (i >= this.contextArray.length) {
            int newLen = this.contextArray.length * 3 / 2;
            ParseContext[] newArray = new ParseContext[newLen];
            System.arraycopy(this.contextArray, 0, newArray, 0, this.contextArray.length);
            this.contextArray = newArray;
        }
        this.contextArray[i] = context;
    }

    public Object parse() {
        return this.parse(null);
    }

    public Object parse(Object fieldName) {
        JSONScanner lexer = this.lexer;
        switch (lexer.token()) {
            case 14: {
                JSONArray array = new JSONArray();
                this.parseArray(array, fieldName);
                if (lexer.isEnabled(Feature.UseObjectArray)) {
                    return array.toArray();
                }
                return array;
            }
            case 12: {
                JSONObject object = new JSONObject();
                return this.parseObject(object, fieldName);
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                Number value = lexer.decimalValue(lexer.isEnabled(Feature.UseBigDecimal));
                lexer.nextToken();
                return value;
            }
            case 4: {
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 21: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 20: {
                if (lexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("unterminated json string, " + lexer.info());
            }
            case 24: {
                byte[] bytes = lexer.bytesValue();
                lexer.nextToken();
                return bytes;
            }
            case 18: {
                String identifier = lexer.stringVal();
                if ("NaN".equals(identifier)) {
                    lexer.nextToken();
                    return null;
                }
                throw new JSONException("syntax error, " + lexer.info());
            }
        }
        throw new JSONException("syntax error, " + lexer.info());
    }

    public void config(Feature feature, boolean state) {
        this.lexer.config(feature, state);
    }

    public boolean isEnabled(Feature feature) {
        return this.lexer.isEnabled(feature);
    }

    public JSONScanner getLexer() {
        return this.lexer;
    }

    public final void accept(int token) {
        JSONScanner lexer = this.lexer;
        if (lexer.token() != token) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken();
    }

    public final void accept(int token, int nextExpectToken) {
        JSONScanner lexer = this.lexer;
        if (lexer.token() == token) {
            lexer.nextToken(nextExpectToken);
        } else {
            this.throwException(token);
        }
    }

    public void throwException(int token) {
        throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(this.lexer.token()));
    }

    @Override
    public void close() {
        try (JSONScanner lexer = this.lexer;){
            if (lexer.isEnabled(Feature.AutoCloseSource) && lexer.token() != 20) {
                throw new JSONException("not close json text, token : " + JSONToken.name(lexer.token()));
            }
        }
    }

    public Object resolveReference(String ref) {
        if (this.contextArray == null) {
            return null;
        }
        for (int i = 0; i < this.contextArray.length && i < this.contextArrayIndex; ++i) {
            ParseContext context = this.contextArray[i];
            if (!context.toString().equals(ref)) continue;
            return context.object;
        }
        return null;
    }

    public void parseExtra(Object object, String key) {
        JSONScanner lexer = this.lexer;
        lexer.nextTokenWithColon();
        Type type = null;
        if (type == null) {
            this.parse();
        } else {
            this.parseObject(type);
        }
        if (this.resolveStatus == 1) {
            this.resolveStatus = 0;
        }
    }

    static {
        Class[] classes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, String.class};
        primitiveClasses.addAll(Arrays.asList(classes));
    }

    @NoMetadata
    public static class ResolveTask {
        public final ParseContext context;
        public final String referenceValue;
        public FieldDeserializer fieldDeserializer;
        public ParseContext ownerContext;

        public ResolveTask(ParseContext context, String referenceValue) {
            this.context = context;
            this.referenceValue = referenceValue;
        }
    }
}

