/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.parser;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.parser.JSONLexerBase;
import com.antgroup.antchain.myjson.parser.SymbolTable;
import com.antgroup.antchain.myjson.util.IOUtils;
import java.math.BigDecimal;
import java.math.MathContext;

@NoMetadata
public final class JSONScanner
extends JSONLexerBase {
    public static final char EOI = '\u001a';
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKNOWN = 0;
    public static final int OBJECT = 1;
    public static final int ARRAY = 2;
    public static final int VALUE = 3;
    public static final int END = 4;
    public static final int VALUE_NULL = 5;
    private final String text;
    private final int len;

    private static void cpdBegin() {
    }

    public JSONScanner(String input, int features) {
        super(features);
        this.text = input;
        this.len = this.text.length();
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    @Override
    public final char charAt(int index) {
        if (index >= this.len) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    @Override
    public final char next() {
        int index;
        char c = (index = ++this.bp) >= this.len ? (char)'\u001a' : (char)this.text.charAt(index);
        this.ch = c;
        return c;
    }

    public JSONScanner(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    @Override
    protected final void copyTo(int offset, int count, char[] dest) {
        this.text.getChars(offset, offset + count, dest, 0);
    }

    static boolean charArrayCompare(String src, int offset, char[] dest) {
        int destLen = dest.length;
        if (destLen + offset > src.length()) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src.charAt(offset + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean charArrayCompare(char[] chars) {
        return JSONScanner.charArrayCompare(this.text, this.bp, chars);
    }

    @Override
    public final int indexOf(char ch, int startIndex) {
        return this.text.indexOf(ch, startIndex);
    }

    @Override
    public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.text, offset, len, hash);
    }

    public byte[] bytesValue() {
        if (this.token == 24) {
            int start = this.np + 1;
            int len = this.sp;
            if (len % 2 != 0) {
                throw new JSONException("illegal state. " + len);
            }
            byte[] bytes = new byte[len / 2];
            for (int i = 0; i < bytes.length; ++i) {
                char c0 = this.text.charAt(start + i * 2);
                char c1 = this.text.charAt(start + i * 2 + 1);
                int b0 = c0 - (c0 <= '9' ? 48 : 55);
                int b1 = c1 - (c1 <= '9' ? 48 : 55);
                bytes[i] = (byte)(b0 << 4 | b1);
            }
            return bytes;
        }
        if (!this.hasSpecial) {
            return IOUtils.decodeBase64(this.text, this.np + 1, this.sp);
        }
        String escapedText = new String(this.sbuf, 0, this.sp);
        return IOUtils.decodeBase64(escapedText);
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.subString(this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    @Override
    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    @Override
    public final char[] sub_chars(int offset, int count) {
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return chars;
    }

    @Override
    public final String numberString() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.subString(this.np, sp);
    }

    public final BigDecimal decimalValue() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        if (sp > 65535) {
            throw new JSONException("decimal overflow");
        }
        int offset = this.np;
        int count = sp;
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return new BigDecimal(this.sbuf, 0, count, MathContext.UNLIMITED);
        }
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return new BigDecimal(chars, 0, chars.length, MathContext.UNLIMITED);
    }

    @Override
    public boolean isEOF() {
        return this.bp == this.len || this.ch == '\u001a' && this.bp + 1 >= this.len;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int scanFieldInt(char[] fieldName) {
        int n;
        int value;
        boolean negative;
        char ch;
        int index;
        char startChar;
        int startPos;
        block24: {
            int n2;
            boolean quote;
            this.matchStat = 0;
            startPos = this.bp;
            startChar = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return 0;
            }
            index = this.bp + fieldName.length;
            boolean bl = quote = (ch = this.charAt(index++)) == '\"';
            if (quote) {
                ch = this.charAt(index++);
            }
            boolean bl2 = negative = ch == '-';
            if (negative) {
                ch = this.charAt(index++);
            }
            if (ch >= '0' && ch <= '9') {
                value = ch - 48;
            } else {
                this.matchStat = -1;
                return 0;
            }
            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                int value_10 = value * 10;
                if (value_10 < value) {
                    this.matchStat = -1;
                    return 0;
                }
                value = value_10 + (ch - 48);
            }
            if (ch == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
            if (quote) {
                if (ch != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                ch = this.charAt(index++);
            }
            while (true) {
                if (ch == ',' || ch == '}') {
                    this.bp = index - 1;
                    if (ch == ',') {
                        break;
                    }
                    break block24;
                }
                if (!JSONScanner.isWhitespace(ch)) {
                    this.matchStat = -1;
                    return 0;
                }
                ch = this.charAt(index++);
            }
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (negative) {
                n2 = -value;
                return n2;
            }
            n2 = value;
            return n2;
        }
        if (ch == '}') {
            this.bp = index - 1;
            ch = this.charAt(++this.bp);
            while (true) {
                if (ch == ',') {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (ch == ']') {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (ch == '}') {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (ch == '\u001a') {
                    this.token = 20;
                    break;
                }
                if (!JSONScanner.isWhitespace(ch)) {
                    this.bp = startPos;
                    this.ch = startChar;
                    this.matchStat = -1;
                    return 0;
                }
                ch = this.charAt(++this.bp);
            }
            this.matchStat = 4;
        }
        if (negative) {
            n = -value;
            return n;
        }
        n = value;
        return n;
    }

    @Override
    public String scanFieldString(char[] fieldName) {
        String stringVal;
        int endIndex;
        char ch;
        char startChar;
        int startPos;
        block20: {
            int startIndex;
            this.matchStat = 0;
            startPos = this.bp;
            startChar = this.ch;
            while (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                if (JSONScanner.isWhitespace(this.ch)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.ch)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return this.stringDefaultValue();
            }
            int index = this.bp + fieldName.length;
            int spaceCount = 0;
            if ((ch = this.charAt(index++)) != '\"') {
                while (JSONScanner.isWhitespace(ch)) {
                    ++spaceCount;
                    ch = this.charAt(index++);
                }
                if (ch != '\"') {
                    this.matchStat = -1;
                    return this.stringDefaultValue();
                }
            }
            if ((endIndex = this.indexOf('\"', startIndex = index)) == -1) {
                throw new JSONException("unclosed str");
            }
            stringVal = this.subString(startIndex, endIndex - startIndex);
            if (stringVal.indexOf(92) != -1) {
                while (true) {
                    int slashCount = 0;
                    for (int i = endIndex - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                        ++slashCount;
                    }
                    if (slashCount % 2 == 0) break;
                    endIndex = this.indexOf('\"', endIndex + 1);
                }
                int chars_len = endIndex - (this.bp + fieldName.length + 1 + spaceCount);
                char[] chars = this.sub_chars(this.bp + fieldName.length + 1 + spaceCount, chars_len);
                stringVal = JSONScanner.readString(chars, chars_len);
            }
            ch = this.charAt(endIndex + 1);
            while (true) {
                if (ch == ',' || ch == '}') break block20;
                if (!JSONScanner.isWhitespace(ch)) break;
                ch = this.charAt(++endIndex + 1);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.bp = endIndex + 1;
        this.ch = ch;
        String strVal = stringVal;
        if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return strVal;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '\u001a') {
            this.token = 20;
        } else {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.matchStat = 4;
        return strVal;
    }

    @Override
    public long scanFieldLong(char[] fieldName) {
        long value;
        boolean negative;
        block19: {
            char ch;
            boolean quote;
            this.matchStat = 0;
            int startPos = this.bp;
            char startChar = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return 0L;
            }
            int index = this.bp + fieldName.length;
            boolean bl = quote = (ch = this.charAt(index++)) == '\"';
            if (quote) {
                ch = this.charAt(index++);
            }
            negative = false;
            if (ch == '-') {
                ch = this.charAt(index++);
                negative = true;
            }
            if (ch >= '0' && ch <= '9') {
                boolean valid;
                value = ch - 48;
                while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                    value = value * 10L + (long)(ch - 48);
                }
                if (ch == '.') {
                    this.matchStat = -1;
                    return 0L;
                }
                if (quote) {
                    if (ch != '\"') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    ch = this.charAt(index++);
                }
                if (ch == ',' || ch == '}') {
                    this.bp = index - 1;
                }
                boolean bl2 = valid = value >= 0L || value == Long.MIN_VALUE && negative;
                if (!valid) {
                    this.bp = startPos;
                    this.ch = startChar;
                    this.matchStat = -1;
                    return 0L;
                }
            } else {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return 0L;
            }
            while (true) {
                if (ch == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    return negative ? -value : value;
                }
                if (ch == '}') {
                    ch = this.charAt(++this.bp);
                    while (true) {
                        if (ch == ',') {
                            this.token = 16;
                            this.ch = this.charAt(++this.bp);
                            break block19;
                        }
                        if (ch == ']') {
                            this.token = 15;
                            this.ch = this.charAt(++this.bp);
                            break block19;
                        }
                        if (ch == '}') {
                            this.token = 13;
                            this.ch = this.charAt(++this.bp);
                            break block19;
                        }
                        if (ch == '\u001a') {
                            this.token = 20;
                            break block19;
                        }
                        if (!JSONScanner.isWhitespace(ch)) break;
                        ch = this.charAt(++this.bp);
                    }
                    this.bp = startPos;
                    this.ch = startChar;
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(ch)) break;
                this.bp = index;
                ch = this.charAt(index++);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return negative ? -value : value;
    }

    @Override
    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        block29: {
            char ch;
            boolean quote;
            this.matchStat = 0;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return false;
            }
            int startPos = this.bp;
            int index = this.bp + fieldName.length;
            boolean bl = quote = (ch = this.charAt(index++)) == '\"';
            if (quote) {
                ch = this.charAt(index++);
            }
            if (ch == 't') {
                if (this.charAt(index++) != 'r') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'u') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (quote && this.charAt(index++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = index;
                ch = this.charAt(this.bp);
                value = true;
            } else if (ch == 'f') {
                if (this.charAt(index++) != 'a') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'l') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 's') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (quote && this.charAt(index++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = index;
                ch = this.charAt(this.bp);
                value = false;
            } else if (ch == '1') {
                if (quote && this.charAt(index++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = index;
                ch = this.charAt(this.bp);
                value = true;
            } else if (ch == '0') {
                if (quote && this.charAt(index++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = index;
                ch = this.charAt(this.bp);
                value = false;
            } else {
                this.matchStat = -1;
                return false;
            }
            while (true) {
                if (ch == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    break block29;
                }
                if (ch == '}') {
                    block30: {
                        ch = this.charAt(++this.bp);
                        while (true) {
                            if (ch == ',') {
                                this.token = 16;
                                this.ch = this.charAt(++this.bp);
                                break block30;
                            }
                            if (ch == ']') {
                                this.token = 15;
                                this.ch = this.charAt(++this.bp);
                                break block30;
                            }
                            if (ch == '}') {
                                this.token = 13;
                                this.ch = this.charAt(++this.bp);
                                break block30;
                            }
                            if (ch == '\u001a') {
                                this.token = 20;
                                break block30;
                            }
                            if (!JSONScanner.isWhitespace(ch)) break;
                            ch = this.charAt(++this.bp);
                        }
                        this.matchStat = -1;
                        return false;
                    }
                    this.matchStat = 4;
                    break block29;
                }
                if (!JSONScanner.isWhitespace(ch)) break;
                ch = this.charAt(++this.bp);
            }
            this.bp = startPos;
            ch = this.charAt(this.bp);
            this.matchStat = -1;
            return false;
        }
        return value;
    }

    @Override
    public final int scanInt(char expectNext) {
        int value;
        boolean negative;
        boolean quote;
        this.matchStat = 0;
        int mark = this.bp;
        int offset = this.bp;
        char chLocal = this.charAt(offset++);
        while (JSONScanner.isWhitespace(chLocal)) {
            chLocal = this.charAt(offset++);
        }
        boolean bl = quote = chLocal == '\"';
        if (quote) {
            chLocal = this.charAt(offset++);
        }
        boolean bl2 = negative = chLocal == '-';
        if (negative) {
            chLocal = this.charAt(offset++);
        }
        if (chLocal >= '0' && chLocal <= '9') {
            value = chLocal - 48;
            while ((chLocal = this.charAt(offset++)) >= '0' && chLocal <= '9') {
                int value_10 = value * 10;
                if (value_10 < value) {
                    throw new JSONException("parseInt error : " + this.subString(mark, offset - 1));
                }
                value = value_10 + (chLocal - 48);
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (quote) {
                if (chLocal != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                chLocal = this.charAt(offset++);
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (chLocal == 'n' && this.charAt(offset++) == 'u' && this.charAt(offset++) == 'l' && this.charAt(offset++) == 'l') {
                this.matchStat = 5;
                int value2 = 0;
                chLocal = this.charAt(offset++);
                if (quote && chLocal == '\"') {
                    chLocal = this.charAt(offset++);
                }
                while (true) {
                    if (chLocal == ',') {
                        this.bp = offset;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return value2;
                    }
                    if (chLocal == ']') {
                        this.bp = offset;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return value2;
                    }
                    if (!JSONScanner.isWhitespace(chLocal)) break;
                    chLocal = this.charAt(offset++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (chLocal == expectNext) {
                this.bp = offset;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return negative ? -value : value;
            }
            if (!JSONScanner.isWhitespace(chLocal)) break;
            chLocal = this.charAt(offset++);
        }
        this.matchStat = -1;
        return negative ? -value : value;
    }

    @Override
    public double scanDouble(char seperator) {
        double value;
        boolean negative;
        char chLocal;
        boolean quote;
        this.matchStat = 0;
        int offset = this.bp;
        boolean bl = quote = (chLocal = this.charAt(offset++)) == '\"';
        if (quote) {
            chLocal = this.charAt(offset++);
        }
        boolean bl2 = negative = chLocal == '-';
        if (negative) {
            chLocal = this.charAt(offset++);
        }
        if (chLocal >= '0' && chLocal <= '9') {
            int count;
            int start;
            boolean exp;
            boolean small;
            long intVal = chLocal - 48;
            while ((chLocal = this.charAt(offset++)) >= '0' && chLocal <= '9') {
                intVal = intVal * 10L + (long)(chLocal - 48);
            }
            long power = 1L;
            boolean bl3 = small = chLocal == '.';
            if (small) {
                if ((chLocal = this.charAt(offset++)) >= '0' && chLocal <= '9') {
                    intVal = intVal * 10L + (long)(chLocal - 48);
                    power = 10L;
                    while ((chLocal = this.charAt(offset++)) >= '0' && chLocal <= '9') {
                        intVal = intVal * 10L + (long)(chLocal - 48);
                        power *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            boolean bl4 = exp = chLocal == 'e' || chLocal == 'E';
            if (exp) {
                if ((chLocal = this.charAt(offset++)) == '+' || chLocal == '-') {
                    chLocal = this.charAt(offset++);
                }
                while (chLocal >= '0' && chLocal <= '9') {
                    chLocal = this.charAt(offset++);
                }
            }
            if (quote) {
                if (chLocal != '\"') {
                    this.matchStat = -1;
                    return 0.0;
                }
                chLocal = this.charAt(offset++);
                start = this.bp + 1;
                count = offset - start - 2;
            } else {
                start = this.bp;
                count = offset - start - 1;
            }
            if (!exp && count < 18) {
                value = (double)intVal / (double)power;
                if (negative) {
                    value = -value;
                }
            } else {
                String text = this.subString(start, count);
                value = Double.parseDouble(text);
            }
        } else {
            if (chLocal == 'n' && this.charAt(offset++) == 'u' && this.charAt(offset++) == 'l' && this.charAt(offset++) == 'l') {
                this.matchStat = 5;
                double value2 = 0.0;
                chLocal = this.charAt(offset++);
                if (quote && chLocal == '\"') {
                    chLocal = this.charAt(offset++);
                }
                while (true) {
                    if (chLocal == ',') {
                        this.bp = offset;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return value2;
                    }
                    if (chLocal == ']') {
                        this.bp = offset;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return value2;
                    }
                    if (!JSONScanner.isWhitespace(chLocal)) break;
                    chLocal = this.charAt(offset++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (chLocal == seperator) {
            this.bp = offset;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        this.matchStat = -1;
        return value;
    }

    @Override
    protected final void arrayCopy(int srcPos, char[] dest, int destPos, int length) {
        this.text.getChars(srcPos, srcPos + length, dest, destPos);
    }

    @Override
    public String info() {
        StringBuilder buf = new StringBuilder();
        int line = 1;
        int column = 1;
        int textLength = this.text.length();
        if (this.bp > textLength) {
            throw new JSONException("bp invalid value " + this.bp + " and text length " + textLength);
        }
        int i = 0;
        while (i < this.bp && i < textLength) {
            char ch = this.text.charAt(i);
            if (ch == '\n') {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        buf.append("pos ").append(this.bp).append(", line ").append(line).append(", column ").append(column);
        if (this.text.length() < 65535) {
            buf.append(this.text);
        } else {
            buf.append(this.text.substring(0, 65535));
        }
        return buf.toString();
    }

    @Override
    public final void skipObject(boolean valid) {
        int i;
        boolean quote = false;
        int braceCnt = 0;
        for (i = this.bp; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                if (i < this.len - 1) {
                    ++i;
                    continue;
                }
                this.ch = ch;
                this.bp = i;
                throw new JSONException("illegal str, " + this.info());
            }
            if (ch == '\"') {
                quote = !quote;
                continue;
            }
            if (ch == '{') {
                if (quote) continue;
                ++braceCnt;
                continue;
            }
            if (ch != '}' || quote || --braceCnt != -1) continue;
            this.bp = i + 1;
            if (this.bp == this.text.length()) {
                this.ch = (char)26;
                this.token = 20;
                return;
            }
            this.ch = this.text.charAt(this.bp);
            if (this.ch == ',') {
                int index;
                this.token = 16;
                this.ch = (char)((index = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(index));
                return;
            }
            if (this.ch == '}') {
                this.token = 13;
                this.next();
                return;
            }
            if (this.ch == ']') {
                this.token = 15;
                this.next();
                return;
            }
            this.nextToken(16);
            return;
        }
        for (int j = 0; j < this.bp; ++j) {
            if (j >= this.text.length() || this.text.charAt(j) != ' ') continue;
            ++i;
        }
        if (i == this.text.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    public final void skipArray(boolean valid) {
        int i;
        boolean quote = false;
        int bracketCnt = 0;
        for (i = this.bp; i < this.text.length(); ++i) {
            char ch = this.text.charAt(i);
            if (ch == '\\') {
                if (i < this.len - 1) {
                    ++i;
                    continue;
                }
                this.ch = ch;
                this.bp = i;
                throw new JSONException("illegal str, " + this.info());
            }
            if (ch == '\"') {
                quote = !quote;
                continue;
            }
            if (ch == '[') {
                if (quote) continue;
                ++bracketCnt;
                continue;
            }
            if (ch == '{' && valid) {
                int index;
                this.ch = (char)((index = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(index));
                this.skipObject(valid);
                continue;
            }
            if (ch != ']' || quote || --bracketCnt != -1) continue;
            this.bp = i + 1;
            if (this.bp == this.text.length()) {
                this.ch = (char)26;
                this.token = 20;
                return;
            }
            this.ch = this.text.charAt(this.bp);
            this.nextToken(16);
            return;
        }
        if (i == this.text.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    public final void skipString() {
        if (this.ch == '\"') {
            for (int i = this.bp + 1; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (c == '\\') {
                    if (i >= this.len - 1) continue;
                    ++i;
                    continue;
                }
                if (c != '\"') continue;
                this.bp = i + 1;
                this.ch = this.text.charAt(this.bp);
                return;
            }
            throw new JSONException("unclosed str");
        }
        throw new UnsupportedOperationException();
    }

    private static void cpdEnd() {
    }
}

