/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.parser.deserializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.JSON;
import com.antgroup.antchain.myjson.JSONArray;
import com.antgroup.antchain.myjson.JSONException;
import com.antgroup.antchain.myjson.JSONObject;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.Feature;
import com.antgroup.antchain.myjson.parser.JSONScanner;
import com.antgroup.antchain.myjson.parser.ParseContext;
import com.antgroup.antchain.myjson.parser.deserializer.ContextObjectDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.JavaBeanDeserializer;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

@NoMetadata
public class MapDeserializer
extends ContextObjectDeserializer
implements ObjectDeserializer {
    public static MapDeserializer instance = new MapDeserializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, String format, int features) {
        if (type == JSONObject.class) {
            return (T)parser.parseObject();
        }
        JSONScanner lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        Map<Object, Object> map = this.createMap(type);
        ParseContext context = parser.getContext();
        try {
            Object t;
            parser.setContext(context, map, fieldName);
            Object object = t = this.deserialze(parser, type, fieldName, map, features);
            return (T)object;
        }
        finally {
            parser.setContext(context);
        }
    }

    protected Object deserialze(DefaultJSONParser parser, Type type, Object fieldName, Map map) {
        return this.deserialze(parser, type, fieldName, map, 0);
    }

    protected Object deserialze(DefaultJSONParser parser, Type type, Object fieldName, Map map, int features) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = null;
            valueType = parameterizedType.getActualTypeArguments()[1];
            if (String.class == keyType) {
                return MapDeserializer.parseMap(parser, map, valueType, fieldName, features);
            }
            return MapDeserializer.parseMap(parser, map, keyType, valueType, fieldName);
        }
        return parser.parseObject(map, fieldName);
    }

    public static Map parseMap(DefaultJSONParser parser, Map<String, Object> map, Type valueType, Object fieldName, int features) {
        JSONScanner lexer = parser.lexer;
        int token = lexer.token();
        if (token != 12) {
            String stringVal;
            if (token == 4 && ((stringVal = lexer.stringVal()).length() == 0 || stringVal.equals("null"))) {
                return null;
            }
            String msg = "syntax error, expect {, actual " + lexer.tokenName();
            if (fieldName instanceof String) {
                msg = msg + ", fieldName ";
                msg = msg + fieldName;
            }
            msg = msg + ", ";
            msg = msg + lexer.info();
            if (token != 4) {
                Object first;
                JSONArray array = new JSONArray();
                parser.parseArray(array, fieldName);
                if (array.size() == 1 && (first = array.get(0)) instanceof JSONObject) {
                    return (JSONObject)first;
                }
            }
            throw new JSONException(msg);
        }
        ParseContext context = parser.getContext();
        try {
            int i = 0;
            while (true) {
                Object value;
                String key;
                lexer.skipWhitespace();
                char ch = lexer.getCurrent();
                if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (ch == ',') {
                        lexer.next();
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                    }
                }
                if (ch == '\"') {
                    key = lexer.scanSymbol(parser.getSymbolTable(), '\"');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                    }
                } else {
                    if (ch == '}') {
                        lexer.next();
                        lexer.resetStringPosition();
                        lexer.nextToken(16);
                        Map<String, Object> map2 = map;
                        return map2;
                    }
                    if (ch == '\'') {
                        if (!lexer.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbol(parser.getSymbolTable(), '\'');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if (!lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbolUnQuoted(parser.getSymbolTable());
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                        }
                    }
                }
                lexer.next();
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                lexer.resetStringPosition();
                lexer.nextToken();
                if (i != 0) {
                    parser.setContext(context);
                }
                if (lexer.token() == 8) {
                    value = null;
                    lexer.nextToken();
                } else {
                    value = parser.parseObject(valueType, (Object)key);
                }
                map.put(key, value);
                parser.checkMapResolve(map, key);
                parser.setContext(context, value, key);
                parser.setContext(context);
                int tok = lexer.token();
                if (tok == 20 || tok == 15) {
                    Map<String, Object> map3 = map;
                    return map3;
                }
                if (tok == 13) {
                    lexer.nextToken();
                    Map<String, Object> map4 = map;
                    return map4;
                }
                ++i;
            }
        }
        finally {
            parser.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseMap(DefaultJSONParser parser, Map<Object, Object> map, Type keyType, Type valueType, Object fieldName) {
        JSONScanner lexer = parser.lexer;
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ObjectDeserializer keyDeserializer = parser.getConfig().getDeserializer(keyType);
        ObjectDeserializer valueDeserializer = parser.getConfig().getDeserializer(valueType);
        lexer.nextToken(keyDeserializer.getFastMatchToken());
        ParseContext context = parser.getContext();
        try {
            while (true) {
                Object key;
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    break;
                }
                if (lexer.token() == 4 && keyDeserializer instanceof JavaBeanDeserializer) {
                    String keyStrValue = lexer.stringVal();
                    lexer.nextToken();
                    DefaultJSONParser keyParser = new DefaultJSONParser(keyStrValue, parser.getConfig(), parser.getLexer().getFeatures());
                    key = keyDeserializer.deserialze(keyParser, keyType, null);
                } else {
                    key = keyDeserializer.deserialze(parser, keyType, null);
                }
                if (lexer.token() != 17) {
                    throw new JSONException("syntax error, expect :, actual " + lexer.token());
                }
                lexer.nextToken(valueDeserializer.getFastMatchToken());
                Object value = valueDeserializer.deserialze(parser, valueType, key);
                parser.checkMapResolve(map, key);
                map.put(key, value);
                if (lexer.token() != 16) continue;
                lexer.nextToken(keyDeserializer.getFastMatchToken());
            }
        }
        finally {
            parser.setContext(context);
        }
        return map;
    }

    public Map<Object, Object> createMap(Type type) {
        return this.createMap(type, JSON.DEFAULT_GENERATE_FEATURE);
    }

    public Map<Object, Object> createMap(Type type, int featrues) {
        if (type == Map.class) {
            return new HashMap<Object, Object>();
        }
        if (type == HashMap.class) {
            return new HashMap<Object, Object>();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (EnumMap.class.equals((Object)rawType)) {
                Type[] actualArgs = parameterizedType.getActualTypeArguments();
                return new EnumMap<Object, Object>((Class)actualArgs[0]);
            }
            return this.createMap(rawType, featrues);
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new JSONException("unsupport type " + type);
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("unsupport type " + type, e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

