/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjson.serializer;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjson.parser.DefaultJSONParser;
import com.antgroup.antchain.myjson.parser.deserializer.ObjectDeserializer;
import com.antgroup.antchain.myjson.serializer.JSONSerializer;
import com.antgroup.antchain.myjson.serializer.ObjectSerializer;
import com.antgroup.antchain.myjson.serializer.SerializeWriter;
import com.antgroup.antchain.myjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;

@NoMetadata
public class CharacterCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final CharacterCodec instance = new CharacterCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        Character value = (Character)object;
        if (value == null) {
            out.writeString("");
            return;
        }
        char c = value.charValue();
        if (c == '\u0000') {
            out.writeString("\u0000");
        } else {
            out.writeString(value.toString());
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Object value = parser.parse();
        return (T)(value == null ? null : TypeUtils.castToChar(value));
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

