/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.maven;

import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryVersion;
import com.antgroup.antchain.myjava.callgraph.CallGraph;
import com.antgroup.antchain.myjava.diagnostics.ProblemProvider;
import com.antgroup.antchain.myjava.maven.MavenMyJavaToolLog;
import com.antgroup.antchain.myjava.maven.MavenSourceFileProviderLookup;
import com.antgroup.antchain.myjava.tooling.MyJavaProblemRenderer;
import com.antgroup.antchain.myjava.tooling.MyJavaTargetType;
import com.antgroup.antchain.myjava.tooling.MyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.builder.BuildException;
import com.antgroup.antchain.myjava.tooling.builder.BuildResult;
import com.antgroup.antchain.myjava.tooling.builder.BuildStrategy;
import com.antgroup.antchain.myjava.tooling.builder.InProcessBuildStrategy;
import com.antgroup.antchain.myjava.tooling.builder.RemoteBuildStrategy;
import com.antgroup.antchain.myjava.tooling.daemon.BuildDaemon;
import com.antgroup.antchain.myjava.tooling.daemon.DaemonInfo;
import com.antgroup.antchain.myjava.tooling.daemon.DaemonLog;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildService;
import com.antgroup.antchain.myjava.vm.MyJavaOptimizationLevel;
import java.io.File;
import java.net.URLClassLoader;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="compile", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class MyJavaCompileMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private MavenArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<MavenArtifactRepository> remoteRepositories;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classFiles;
    @Parameter
    private List<String> compileScopes;
    @Parameter(property="myjava.minifying", defaultValue="false")
    private boolean minifying = false;
    @Parameter(property="myjava.strict", defaultValue="false")
    private boolean strict;
    @Parameter(property="myjava.maxTopLevelNames", defaultValue="10000")
    private int maxTopLevelNames = 10000;
    @Parameter
    private Properties properties;
    @Parameter(property="myjava.debugInformationGenerated", defaultValue="true")
    private boolean debugInformationGenerated;
    @Parameter(property="myjava.sourceMapsGenerated", defaultValue="false")
    private boolean sourceMapsGenerated;
    @Parameter(property="myjava.sourceFilesCopied", defaultValue="false")
    private boolean sourceFilesCopied;
    @Parameter(property="myjava.incremental", defaultValue="false")
    private boolean incremental;
    @Parameter(property="myjava.showBuildConfig", defaultValue="false")
    private boolean showBuildConfig;
    @Parameter
    private String[] transformers;
    @Parameter(defaultValue="${project.build.directory}/wasm")
    private File targetDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter(property="myjava.targetFileName", defaultValue="")
    private String targetFileName = "";
    @Parameter(property="myjava.mainClass")
    private String mainClass;
    @Parameter(property="myjava.entryPointName", defaultValue="main")
    private String entryPointName;
    @Parameter
    private String[] classesToPreserve;
    @Parameter(property="myjava.stopOnErrors", defaultValue="true")
    private boolean stopOnErrors = true;
    @Parameter(property="myjava.optimizationLevel", defaultValue="SIMPLE_OPTIMIZED")
    private MyJavaOptimizationLevel optimizationLevel = MyJavaOptimizationLevel.SIMPLE_OPTIMIZED;
    @Parameter(property="myjava.fastGlobalAnalysis", defaultValue="false")
    private boolean fastGlobalAnalysis;
    @Parameter(property="myjava.targetType", defaultValue="WEBASSEMBLY")
    private MyJavaTargetType targetType = MyJavaTargetType.WEBASSEMBLY;
    @Parameter(defaultValue="${project.build.directory}/myjava-cache")
    private File cacheDirectory;
    @Parameter(property="myjava.wasmVersion", defaultValue="V_0x1")
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    @Parameter(property="myjava.wasmSectionCode", defaultValue="1")
    private int wasmSectionCode = 1;
    @Parameter(property="myjava.optimizeWasmStart", defaultValue="true")
    private boolean optimizeWasmStart;
    @Parameter(property="myjava.compressWasm", defaultValue="true")
    private boolean compressWasm;
    @Parameter(property="myjava.minHeapSize", defaultValue="6")
    private int minHeapSize;
    @Parameter(property="myjava.maxHeapSize", defaultValue="14")
    private int maxHeapSize;
    @Parameter(property="myjava.maxMemorySize", defaultValue="16")
    private int maxMemorySize;
    @Parameter(property="myjava.enableMemoryTrace", defaultValue="false")
    private boolean enableMemoryTrace;
    @Parameter(property="myjava.outOfProcess", defaultValue="false")
    private boolean outOfProcess;
    @Parameter(property="myjava.processMemory", defaultValue="512")
    private int processMemory;
    @Parameter(property="myjava.longjmpSupported", defaultValue="true")
    private boolean longjmpSupported;
    @Parameter(property="myjava.heapDump", defaultValue="false")
    private boolean heapDump;

    private void setupBuilder(BuildStrategy builder) throws MojoExecutionException {
        builder.setLog((MyJavaToolLog)new MavenMyJavaToolLog(this.getLog()));
        try {
            builder.setClassPathEntries(this.prepareClassPath());
            builder.setObfuscated(this.minifying);
            builder.setStrict(this.strict);
            builder.setMaxTopLevelNames(this.maxTopLevelNames);
            builder.setTargetDirectory(this.targetDirectory.getAbsolutePath());
            if (this.transformers != null) {
                builder.setTransformers(this.transformers);
            }
            if (this.sourceFilesCopied) {
                this.getSourceFileProviders(builder);
                builder.addSourcesDirectory(this.sourceDirectory.getAbsolutePath());
            }
            if (this.properties != null) {
                builder.setProperties(this.properties);
            }
            builder.setIncremental(this.incremental);
            builder.setDebugInformationGenerated(this.debugInformationGenerated);
            builder.setSourceMapsFileGenerated(this.sourceMapsGenerated);
            builder.setSourceFilesCopied(this.sourceFilesCopied);
            builder.setEnableMemoryTraceHooks(this.enableMemoryTrace);
            builder.setMinHeapSize(this.minHeapSize * 1024 * 1024);
            builder.setMaxHeapSize(this.maxHeapSize * 1024 * 1024);
            builder.setMaxMemorySize(this.maxMemorySize * 1024 * 1024);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unexpected error occurred", (Exception)e);
        }
    }

    private List<String> prepareClassPath() {
        Log log = this.getLog();
        log.info((CharSequence)"Preparing classpath for MyJava");
        ArrayList<String> paths = new ArrayList<String>();
        StringBuilder classpath = new StringBuilder();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!this.filterByScope(artifact)) continue;
            File file = artifact.getFile();
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(file.getPath());
            paths.add(file.getAbsolutePath());
        }
        if (classpath.length() > 0) {
            classpath.append(':');
        }
        classpath.append(this.classFiles.getPath());
        paths.add(this.classFiles.getAbsolutePath());
        log.info((CharSequence)("Using the following classpath for MyJava: " + classpath));
        return paths;
    }

    private boolean filterByScope(Artifact artifact) {
        return this.compileScopes == null ? this.isSupportedScope(artifact.getScope()) : this.compileScopes.contains(artifact.getScope());
    }

    protected boolean isSupportedScope(String scope) {
        switch (scope) {
            case "compile": 
            case "provided": 
            case "system": {
                return true;
            }
        }
        return false;
    }

    private void getSourceFileProviders(BuildStrategy builder) {
        MavenSourceFileProviderLookup lookup = new MavenSourceFileProviderLookup();
        lookup.setMavenProject(this.project);
        lookup.setRepositorySystem(this.repositorySystem);
        lookup.setLocalRepository((ArtifactRepository)this.localRepository);
        lookup.setRemoteRepositories(this.remoteRepositories);
        lookup.setPluginDependencies(this.pluginArtifacts);
        lookup.resolve(builder);
    }

    public void execute() throws MojoExecutionException {
        if (this.outOfProcess) {
            this.executeInSeparateProcess();
        } else {
            this.executeWithBuilder((BuildStrategy)new InProcessBuildStrategy(URLClassLoader::new));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateProcess() throws MojoExecutionException {
        DaemonInfo daemon;
        try {
            daemon = BuildDaemon.start((boolean)false, (int)this.processMemory, (DaemonLog)new DaemonLogImpl(), (String[])this.createDaemonClassPath());
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Error starting MyJava process", e);
        }
        try {
            RemoteBuildService buildService;
            try {
                Registry registry = LocateRegistry.getRegistry(daemon.getPort());
                buildService = (RemoteBuildService)registry.lookup("MyJavaVM-Daemon");
            }
            catch (NotBoundException | RemoteException e) {
                throw new MojoExecutionException("Error connecting MyJava process", e);
            }
            RemoteBuildStrategy builder = new RemoteBuildStrategy(buildService);
            this.executeWithBuilder((BuildStrategy)builder);
        }
        finally {
            daemon.getProcess().destroy();
        }
    }

    private void executeWithBuilder(BuildStrategy builder) throws MojoExecutionException {
        builder.init();
        Log log = this.getLog();
        this.setupBuilder(builder);
        MavenMyJavaToolLog toolLog = new MavenMyJavaToolLog(log);
        builder.setLog((MyJavaToolLog)toolLog);
        try {
            builder.setMainClass(this.mainClass);
            builder.setEntryPointName(this.entryPointName);
            if (!this.targetFileName.isEmpty()) {
                builder.setTargetFileName(this.targetFileName);
            }
            builder.setOptimizationLevel(this.optimizationLevel);
            builder.setFastDependencyAnalysis(this.fastGlobalAnalysis);
            if (this.classesToPreserve != null) {
                builder.setClassesToPreserve(this.classesToPreserve);
            }
            builder.setCacheDirectory(this.cacheDirectory.getAbsolutePath());
            builder.setTargetType(this.targetType);
            builder.setWasmVersion(this.wasmVersion);
            builder.setWasmSectionCode(this.wasmSectionCode);
            builder.setOptimizeWasmStart(this.optimizeWasmStart);
            builder.setCompressWasm(this.compressWasm);
            builder.setLongjmpSupported(this.longjmpSupported);
            builder.setHeapDump(this.heapDump);
            BuildResult result = builder.build(this.showBuildConfig);
            MyJavaProblemRenderer.describeProblems((CallGraph)result.getCallGraph(), (ProblemProvider)result.getProblems(), (MyJavaToolLog)toolLog);
            if (this.stopOnErrors && !result.getProblems().getSevereProblems().isEmpty()) {
                throw new MojoExecutionException("Build error");
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
            throw new MojoExecutionException("Unexpected error occurred", e.getCause());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error occurred", e);
        }
    }

    private String[] createDaemonClassPath() {
        Artifact toolArtifact = this.pluginArtifacts.stream().filter(artifact -> artifact.getGroupId().equals("com.alipay.myjava") && artifact.getArtifactId().equals("myjava-tooling")).findFirst().orElse(null);
        if (toolArtifact == null) {
            return new String[0];
        }
        ArtifactResolutionResult resolutionResult = this.repositorySystem.resolve(new ArtifactResolutionRequest().setLocalRepository((ArtifactRepository)this.localRepository).setRemoteRepositories(new ArrayList<MavenArtifactRepository>(this.remoteRepositories)).setResolveTransitively(true).setResolveRoot(true).setArtifact(toolArtifact));
        if (!resolutionResult.isSuccess()) {
            return new String[0];
        }
        return (String[])resolutionResult.getArtifacts().stream().map(artifact -> artifact.getFile().getAbsolutePath()).toArray(String[]::new);
    }

    class DaemonLogImpl
    implements DaemonLog {
        DaemonLogImpl() {
        }

        public void error(String message) {
            MyJavaCompileMojo.this.getLog().error((CharSequence)message);
        }

        public void error(String message, Throwable e) {
            MyJavaCompileMojo.this.getLog().error((CharSequence)message, e);
        }

        public void info(String message) {
            MyJavaCompileMojo.this.getLog().info((CharSequence)message);
        }
    }
}

