/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.optimization;

import com.antgroup.antchain.myjava.common.DisjointSet;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.PrimitiveType;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.InstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BoxingElimination {
    private static Set<String> wrapperClasses = Stream.of(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class).map(Class::getName).collect(Collectors.toSet());
    private DisjointSet set = new DisjointSet();
    private Program program;
    private List<Wrapper> wrappers = new ArrayList<Wrapper>();

    public void optimize(Program program) {
        this.program = program;
        this.initDisjointSet();
        this.findBoxedValues();
        this.removeInstructions();
    }

    private void initDisjointSet() {
        for (int i = 0; i < this.program.variableCount(); ++i) {
            this.set.create();
        }
    }

    private void findBoxedValues() {
        UsageExtractor use = new UsageExtractor();
        this.wrappers.addAll(Collections.nCopies(this.program.variableCount(), null));
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            for (Instruction insn : block) {
                if (insn instanceof AssignInstruction) {
                    AssignInstruction assign = (AssignInstruction)insn;
                    this.union(assign.getReceiver().getIndex(), assign.getAssignee().getIndex());
                    continue;
                }
                if (insn instanceof CastInstruction) {
                    CastInstruction cast = (CastInstruction)insn;
                    Wrapper targetWrapper = new Wrapper();
                    if (cast.getTargetType() instanceof ValueType.Object) {
                        targetWrapper.expectedType = ((ValueType.Object)cast.getTargetType()).getClassName();
                    } else {
                        targetWrapper.state = WrapperState.REFUTED;
                    }
                    this.update(cast.getReceiver().getIndex(), targetWrapper);
                    this.union(cast.getValue().getIndex(), cast.getReceiver().getIndex());
                    continue;
                }
                if (insn instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodReference method = invoke.getMethod();
                    if (wrapperClasses.contains(method.getClassName()) && method.getName().endsWith("Value") && method.parameterCount() == 0 && method.getReturnType() instanceof ValueType.Primitive) continue;
                    if (method.getName().equals("valueOf") && wrapperClasses.contains(method.getClassName()) && invoke.getReceiver() != null) {
                        Wrapper wrapper = new Wrapper();
                        wrapper.state = WrapperState.PROVEN;
                        this.update(invoke.getReceiver().getIndex(), wrapper);
                        continue;
                    }
                }
                insn.acceptVisitor((InstructionVisitor)use);
                for (Variable usedVar : use.getUsedVariables()) {
                    Wrapper wrapper = new Wrapper();
                    wrapper.state = WrapperState.REFUTED;
                    this.update(usedVar.getIndex(), wrapper);
                }
            }
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    this.union(phi.getReceiver().getIndex(), incoming.getValue().getIndex());
                }
            }
        }
    }

    private void removeInstructions() {
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            for (Instruction insn : block) {
                AssignInstruction assign;
                if (insn instanceof CastInstruction) {
                    CastInstruction cast = (CastInstruction)insn;
                    if (!this.isProven(cast.getReceiver().getIndex())) continue;
                    assign = new AssignInstruction();
                    assign.setReceiver(cast.getReceiver());
                    assign.setAssignee(cast.getValue());
                    insn.replace((Instruction)assign);
                    continue;
                }
                if (!(insn instanceof InvokeInstruction)) continue;
                InvokeInstruction invoke = (InvokeInstruction)insn;
                if (invoke.getReceiver() != null && this.isProven(invoke.getReceiver().getIndex())) {
                    assign = new AssignInstruction();
                    assign.setReceiver(invoke.getReceiver());
                    assign.setAssignee((Variable)invoke.getArguments().get(0));
                    insn.replace((Instruction)assign);
                    continue;
                }
                if (invoke.getInstance() == null || !this.isProven(invoke.getInstance().getIndex())) continue;
                assign = new AssignInstruction();
                assign.setReceiver(invoke.getReceiver());
                assign.setAssignee(invoke.getInstance());
                insn.replace((Instruction)assign);
            }
        }
    }

    private boolean isProven(int index) {
        Wrapper wrapper = this.wrappers.get(index = this.set.find(index));
        return wrapper != null && wrapper.state == WrapperState.PROVEN;
    }

    private int union(int a, int b) {
        Wrapper p = this.wrappers.get(this.set.find(a));
        Wrapper q = this.wrappers.get(this.set.find(b));
        int c = this.set.union(a, b);
        if (c >= this.wrappers.size()) {
            this.wrappers.addAll(Collections.nCopies(c - this.wrappers.size() + 1, null));
        }
        this.wrappers.set(c, this.union(p, q));
        return c;
    }

    private Wrapper union(Wrapper a, Wrapper b) {
        Wrapper wrapper;
        if (a == null) {
            wrapper = b;
        } else if (b == null) {
            wrapper = a;
        } else {
            if (a.state == WrapperState.REFUTED || b.state == WrapperState.REFUTED) {
                a.state = WrapperState.REFUTED;
            } else if (a.state == WrapperState.PROVEN || b.state == WrapperState.PROVEN) {
                a.state = WrapperState.PROVEN;
            }
            if (a.state != WrapperState.REFUTED) {
                if (a.expectedType == null) {
                    a.expectedType = b.expectedType;
                } else if (b.expectedType != null) {
                    if (this.isSubtype(b.expectedType, a.expectedType)) {
                        a.expectedType = b.expectedType;
                    } else if (!this.isSubtype(a.expectedType, b.expectedType)) {
                        a.state = WrapperState.REFUTED;
                    }
                }
            }
            if (a.state != WrapperState.REFUTED) {
                if (a.type == null) {
                    a.type = b.type;
                } else if (b.type != null && b.type != a.type) {
                    a.state = WrapperState.REFUTED;
                }
                if (a.type != null && b.type != null && !this.isSubtype(a.type, a.expectedType)) {
                    a.state = WrapperState.REFUTED;
                }
            }
            wrapper = a;
        }
        return wrapper;
    }

    private void update(int index, Wrapper wrapper) {
        index = this.set.find(index);
        this.wrappers.set(index, this.union(this.wrappers.get(index), wrapper));
    }

    private boolean isSubtype(String subtype, String supertype) {
        if (subtype.equals(supertype)) {
            return true;
        }
        switch (supertype) {
            case "java.lang.Object": {
                return true;
            }
            case "java.lang.Number": {
                switch (subtype) {
                    case "java.lang.Byte": 
                    case "java.lang.Short": 
                    case "java.lang.Integer": 
                    case "java.lang.Long": 
                    case "java.lang.Float": 
                    case "java.lang.Double": {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private boolean isSubtype(PrimitiveType subtype, String supertype) {
        switch (supertype) {
            case "java.lang.Object": {
                return true;
            }
            case "java.lang.Number": {
                switch (subtype) {
                    case BYTE: 
                    case SHORT: 
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
        }
        switch (subtype) {
            case BOOLEAN: {
                return supertype.equals("java.lang.Boolean");
            }
            case BYTE: {
                return supertype.equals("java.lang.Byte");
            }
            case SHORT: {
                return supertype.equals("java.lang.Short");
            }
            case CHARACTER: {
                return supertype.equals("java.lang.Character");
            }
            case INTEGER: {
                return supertype.equals("java.lang.Integer");
            }
            case LONG: {
                return supertype.equals("java.lang.Long");
            }
            case FLOAT: {
                return supertype.equals("java.lang.Float");
            }
            case DOUBLE: {
                return supertype.equals("java.lang.Double");
            }
        }
        return false;
    }

    static enum WrapperState {
        PROVEN,
        REFUTED,
        UNKNOWN;

    }

    static class Wrapper {
        PrimitiveType type;
        String expectedType = "java.lang.Object";
        WrapperState state = WrapperState.UNKNOWN;

        Wrapper() {
        }
    }
}

