/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.reflect;

import com.antgroup.antchain.myjava.metaprogramming.impl.reflect.ReflectClassImpl;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.ElementReader;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ReflectContext {
    private ClassReaderSource classSource;
    private ClassHierarchy hierarchy;
    private Map<ValueType, ReflectClassImpl<?>> classes = new HashMap();
    private ClassLoader classLoader;

    public ReflectContext(ClassHierarchy hierarchy, ClassLoader classLoader) {
        this.classSource = hierarchy.getClassSource();
        this.hierarchy = hierarchy;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ClassHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public ReflectClassImpl<?> getClass(ValueType type) {
        return this.classes.computeIfAbsent(type, t -> new ReflectClassImpl(type, this));
    }

    public <T> ReflectClassImpl<T> findClass(Class<T> cls) {
        return this.getClass(ValueType.parse(cls));
    }

    public ReflectClassImpl<?> findClass(String name) {
        if (this.classSource.get(name) == null) {
            return null;
        }
        return this.getClass((ValueType)ValueType.object((String)name));
    }

    public static int getModifiers(ElementReader element) {
        int modifiers = 0;
        switch (element.getLevel()) {
            case PUBLIC: {
                modifiers |= 1;
                break;
            }
            case PROTECTED: {
                modifiers |= 4;
                break;
            }
            case PRIVATE: {
                modifiers |= 2;
                break;
            }
        }
        EnumSet modifierSet = element.readModifiers();
        if (modifierSet.contains(ElementModifier.ABSTRACT)) {
            modifiers |= 0x400;
        }
        if (modifierSet.contains(ElementModifier.FINAL)) {
            modifiers |= 0x10;
        }
        if (modifierSet.contains(ElementModifier.INTERFACE)) {
            modifiers |= 0x200;
        }
        if (modifierSet.contains(ElementModifier.NATIVE)) {
            modifiers |= 0x100;
        }
        if (modifierSet.contains(ElementModifier.STATIC)) {
            modifiers |= 8;
        }
        if (modifierSet.contains(ElementModifier.STRICT)) {
            modifiers |= 0x800;
        }
        if (modifierSet.contains(ElementModifier.SYNCHRONIZED)) {
            modifiers |= 0x20;
        }
        if (modifierSet.contains(ElementModifier.TRANSIENT)) {
            modifiers |= 0x80;
        }
        if (modifierSet.contains(ElementModifier.VOLATILE)) {
            modifiers |= 0x40;
        }
        return modifiers;
    }
}

