/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl;

import com.antgroup.antchain.myjava.model.ValueType;
import java.lang.reflect.Array;

public class JavaClassUtils {
    public static Class<?> getJavaTypeFromValueType(ClassLoader classLoader, ValueType type) throws ReflectiveOperationException {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case CHARACTER: {
                    return Character.TYPE;
                }
                case INTEGER: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
            }
        } else {
            if (type instanceof ValueType.Array) {
                Class<?> componentType = JavaClassUtils.getJavaTypeFromValueType(classLoader, ((ValueType.Array)type).getItemType());
                return Array.newInstance(componentType, 0).getClass();
            }
            if (type == ValueType.VOID) {
                return Void.TYPE;
            }
            if (type instanceof ValueType.Object) {
                String name = ((ValueType.Object)type).getClassName();
                return Class.forName(name, true, classLoader);
            }
        }
        throw new AssertionError((Object)("Don't know how to map type: " + type));
    }
}

