/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.model;

import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.metaprogramming.Meta;
import com.antgroup.antchain.myjava.metaprogramming.ReflectClass;
import com.antgroup.antchain.myjava.metaprogramming.Value;
import com.antgroup.antchain.myjava.metaprogramming.impl.model.MethodModel;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MethodDescriber {
    private Diagnostics diagnostics;
    private ClassReaderSource classSource;
    private Map<MethodReference, Optional<MethodModel>> cache = new HashMap<MethodReference, Optional<MethodModel>>();
    private List<MethodModel> knownMethods = new ArrayList<MethodModel>();

    public MethodDescriber(Diagnostics diagnostics, ClassReaderSource classSource) {
        this.diagnostics = diagnostics;
        this.classSource = classSource;
    }

    public MethodModel getMethod(MethodReference method) {
        return this.cache.computeIfAbsent(method, k -> {
            MethodModel model = this.describeMethod((MethodReference)k);
            if (model != null) {
                this.knownMethods.add(model);
            }
            return Optional.ofNullable(model);
        }).orElse(null);
    }

    public Iterable<MethodModel> getKnownMethods() {
        return this.knownMethods;
    }

    private MethodModel describeMethod(MethodReference methodRef) {
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return null;
        }
        if (method.getAnnotations().get(Meta.class.getName()) == null) {
            return null;
        }
        CallLocation location = new CallLocation(methodRef);
        MethodModel proxyMethod = this.findMetaMethod(method);
        if (proxyMethod == null) {
            this.diagnostics.error(location, "Corresponding meta method was not found", new Object[0]);
            return null;
        }
        return proxyMethod;
    }

    private MethodModel findMetaMethod(MethodReader method) {
        ClassReader cls = this.classSource.get(method.getOwnerName());
        boolean isStatic = method.hasModifier(ElementModifier.STATIC);
        int expectedParameterCount = (isStatic ? 0 : 1) + method.parameterCount();
        for (MethodReader meta : cls.getMethods()) {
            if (meta == method || !meta.hasModifier(ElementModifier.STATIC) || !meta.getName().equals(method.getName()) || meta.getResultType() != ValueType.VOID || meta.parameterCount() != expectedParameterCount) continue;
            int paramOffset = 0;
            if (!isStatic) {
                if (meta.parameterCount() == 0 || meta.parameterType(0).isObject(Value.class)) {
                    return null;
                }
                ++paramOffset;
            }
            int classParamIndex = -1;
            for (int i = 0; i < method.parameterCount(); ++i) {
                ValueType proxyParam = meta.parameterType(i + paramOffset);
                if (proxyParam.isObject(ReflectClass.class)) {
                    if (classParamIndex == -1) {
                        classParamIndex = i;
                        continue;
                    }
                    return null;
                }
                if (proxyParam.isObject(Value.class)) continue;
                return null;
            }
            return new MethodModel(method.getReference(), meta.getReference(), classParamIndex, isStatic);
        }
        return null;
    }
}

