/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl.reflect;

import com.antgroup.antchain.myjava.metaprogramming.impl.JavaClassUtils;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.ValueType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AnnotationProxy
implements InvocationHandler {
    private ClassLoader classLoader;
    private ClassHierarchy hierarchy;
    private AnnotationReader reader;
    private Class<?> annotationType;
    private Map<String, Object> cache = new HashMap<String, Object>();

    AnnotationProxy(ClassLoader classLoader, ClassHierarchy hierarchy, AnnotationReader reader, Class<?> annotationType) {
        this.classLoader = classLoader;
        this.hierarchy = hierarchy;
        this.reader = reader;
        this.annotationType = annotationType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("annotationType")) {
            return this.annotationType;
        }
        ClassReader cls = this.hierarchy.getClassSource().get(this.reader.getType());
        return this.cache.computeIfAbsent(method.getName(), name -> {
            MethodDescriptor desc = new MethodDescriptor(name, new ValueType[]{ValueType.parse(method.getReturnType())});
            MethodReader methodReader = cls.getMethod(desc);
            AnnotationValue value = this.reader.getValue(name);
            if (value == null) {
                value = methodReader.getAnnotationDefault();
            }
            try {
                return this.convertValue(value, desc.getResultType());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Object convertValue(AnnotationValue value, ValueType type) throws Exception {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return value.getBoolean();
                }
                case BYTE: {
                    return value.getByte();
                }
                case SHORT: {
                    return value.getShort();
                }
                case INTEGER: {
                    return value.getInt();
                }
                case LONG: {
                    return value.getLong();
                }
                case FLOAT: {
                    return Float.valueOf(value.getFloat());
                }
                case DOUBLE: {
                    return value.getDouble();
                }
                case CHARACTER: {
                    return Character.valueOf(value.getChar());
                }
            }
        } else {
            if (type.isObject(String.class)) {
                return value.getString();
            }
            if (type instanceof ValueType.Array) {
                List array = value.getList();
                ValueType itemType = ((ValueType.Array)type).getItemType();
                Class<?> componentType = this.convertClass(itemType);
                Object result = Array.newInstance(componentType, array.size());
                for (int i = 0; i < array.size(); ++i) {
                    Array.set(result, i, this.convertValue((AnnotationValue)array.get(i), itemType));
                }
                return result;
            }
            if (type.isObject(Class.class)) {
                return this.convertClass(value.getJavaClass());
            }
            if (this.hierarchy.isSuperType(ValueType.parse(Enum.class), type, false)) {
                FieldReference fieldRef = value.getEnumValue();
                Class<?> enumClass = Class.forName(fieldRef.getClassName(), true, this.classLoader);
                return enumClass.getField(fieldRef.getFieldName()).get(null);
            }
            if (this.hierarchy.isSuperType(ValueType.parse(Annotation.class), type, false)) {
                Class<?> annotType = this.convertClass(type);
                AnnotationProxy handler = new AnnotationProxy(this.classLoader, this.hierarchy, value.getAnnotation(), annotType);
                return Proxy.newProxyInstance(this.classLoader, new Class[]{annotType}, (InvocationHandler)handler);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + type));
    }

    private Class<?> convertClass(ValueType type) throws Exception {
        return JavaClassUtils.getJavaTypeFromValueType(this.classLoader, type);
    }
}

