/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling.builder;

import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryVersion;
import com.antgroup.antchain.myjava.callgraph.CallGraph;
import com.antgroup.antchain.myjava.diagnostics.Problem;
import com.antgroup.antchain.myjava.diagnostics.ProblemProvider;
import com.antgroup.antchain.myjava.tooling.EmptyMyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.MyJavaTargetType;
import com.antgroup.antchain.myjava.tooling.MyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.builder.BuildException;
import com.antgroup.antchain.myjava.tooling.builder.BuildResult;
import com.antgroup.antchain.myjava.tooling.builder.BuildStrategy;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildCallback;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildRequest;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildResponse;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildService;
import com.antgroup.antchain.myjava.vm.MyJavaOptimizationLevel;
import com.antgroup.antchain.myjava.vm.MyJavaPhase;
import com.antgroup.antchain.myjava.vm.MyJavaProgressFeedback;
import com.antgroup.antchain.myjava.vm.MyJavaProgressListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RemoteBuildStrategy
implements BuildStrategy {
    private RemoteBuildRequest request;
    private RemoteBuildService buildService;
    private MyJavaProgressListener progressListener;
    private MyJavaToolLog log = new EmptyMyJavaToolLog();

    public RemoteBuildStrategy(RemoteBuildService buildService) {
        this.buildService = buildService;
    }

    @Override
    public void init() {
        this.request = new RemoteBuildRequest();
        this.request.optimizationLevel = MyJavaOptimizationLevel.ADVANCED;
        this.request.wasmVersion = WasmBinaryVersion.V_0x1;
        this.request.wasmSectionCode = 1;
        this.request.compressWasm = true;
        this.request.dumpNames = true;
        this.request.longjmpSupported = true;
    }

    @Override
    public void addSourcesDirectory(String directory) {
        this.request.sourceDirectories.add(directory);
    }

    @Override
    public void addSourcesJar(String jarFile) {
        this.request.sourceJarFiles.add(jarFile);
    }

    @Override
    public void setClassPathEntries(List<String> entries) {
        this.request.classPath.addAll(entries);
    }

    @Override
    public void setTargetType(MyJavaTargetType targetType) {
        this.request.targetType = targetType;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.request.mainClass = mainClass;
    }

    @Override
    public void setEntryPointName(String entryPointName) {
        this.request.entryPointName = entryPointName;
    }

    @Override
    public void setTargetDirectory(String targetDirectory) {
        this.request.targetDirectory = targetDirectory;
    }

    @Override
    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.request.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    @Override
    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.request.debugInformationGenerated = debugInformationGenerated;
    }

    @Override
    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.request.sourceFilesCopied = sourceFilesCopied;
    }

    @Override
    public void setProgressListener(MyJavaProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public void setIncremental(boolean incremental) {
        this.request.incremental = incremental;
    }

    @Override
    public void setProperties(Properties properties) {
        this.request.properties = new Properties();
        this.request.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public void setLog(MyJavaToolLog log) {
        this.log = log;
    }

    @Override
    public void setObfuscated(boolean obfuscated) {
        this.request.obfuscated = obfuscated;
    }

    @Override
    public void setEnableMemoryTraceHooks(boolean enableMemoryTraceHooks) {
        this.request.enableMemoryTraceHooks = enableMemoryTraceHooks;
    }

    @Override
    public void setStrict(boolean strict) {
        this.request.strict = strict;
    }

    @Override
    public void setMaxTopLevelNames(int maxTopLevelNames) {
        this.request.maxTopLevelNames = maxTopLevelNames;
    }

    @Override
    public void setTransformers(String[] transformers) {
        this.request.transformers = (String[])transformers.clone();
    }

    @Override
    public void setOptimizationLevel(MyJavaOptimizationLevel level) {
        this.request.optimizationLevel = level;
    }

    @Override
    public void setFastDependencyAnalysis(boolean value) {
        this.request.fastDependencyAnalysis = value;
    }

    @Override
    public void setTargetFileName(String targetFileName) {
        this.request.tagetFileName = targetFileName;
    }

    @Override
    public void setClassesToPreserve(String[] classesToPreserve) {
        this.request.classesToPreserve = (String[])classesToPreserve.clone();
    }

    @Override
    public void setCacheDirectory(String cacheDirectory) {
        this.request.cacheDirectory = cacheDirectory;
    }

    @Override
    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.request.wasmVersion = wasmVersion;
    }

    @Override
    public void setWasmSectionCode(int wasmSectionCode) {
        this.request.wasmSectionCode = wasmSectionCode;
    }

    @Override
    public void setOptimizeWasmStart(boolean optimizeWasmStart) {
        this.request.optimizeWasmStart = optimizeWasmStart;
    }

    @Override
    public void setCompressWasm(boolean compressWasm) {
        this.request.compressWasm = compressWasm;
    }

    @Override
    public void setDumpNames(boolean dumpNames) {
        this.request.dumpNames = dumpNames;
    }

    @Override
    public void setMinHeapSize(int minHeapSize) {
        this.request.minHeapSize = minHeapSize;
    }

    @Override
    public void setMaxHeapSize(int maxHeapSize) {
        this.request.maxHeapSize = maxHeapSize;
    }

    @Override
    public void setMaxMemorySize(int maxMemorySize) {
        this.request.maxMemorySize = maxMemorySize;
    }

    @Override
    public void setLongjmpSupported(boolean value) {
        this.request.longjmpSupported = value;
    }

    @Override
    public void setHeapDump(boolean heapDump) {
        this.request.heapDump = heapDump;
    }

    @Override
    public BuildResult build(boolean printConfig) throws BuildException {
        RemoteBuildResponse response;
        try {
            response = this.buildService.build(this.request, new CallbackImpl(this.progressListener, this.log));
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
        if (response.exception != null) {
            throw new BuildException(response.exception);
        }
        return new BuildResult(){
            private ProblemProvider problems = new ProblemProvider(){

                public List<Problem> getProblems() {
                    return response.problems;
                }

                public List<Problem> getSevereProblems() {
                    return response.severeProblems;
                }
            };

            @Override
            public CallGraph getCallGraph() {
                return response.callGraph;
            }

            @Override
            public ProblemProvider getProblems() {
                return this.problems;
            }

            @Override
            public Collection<String> getUsedResources() {
                return response.usedResources;
            }

            @Override
            public Collection<String> getClasses() {
                return response.classes;
            }

            @Override
            public Collection<String> getGeneratedFiles() {
                return response.generatedFiles;
            }
        };
    }

    static class CallbackImpl
    extends UnicastRemoteObject
    implements RemoteBuildCallback {
        private MyJavaProgressListener listener;
        private MyJavaToolLog log;

        CallbackImpl(MyJavaProgressListener listener, MyJavaToolLog log) throws RemoteException {
            this.listener = listener;
            this.log = log;
        }

        @Override
        public MyJavaProgressFeedback phaseStarted(MyJavaPhase phase, int count) {
            return this.listener != null ? this.listener.phaseStarted(phase, count) : MyJavaProgressFeedback.CONTINUE;
        }

        @Override
        public MyJavaProgressFeedback progressReached(int progress) {
            return this.listener != null ? this.listener.progressReached(progress) : MyJavaProgressFeedback.CONTINUE;
        }

        @Override
        public void errorReported(String message, Throwable e) {
            this.log.error(message, e);
        }

        @Override
        public void errorReported(String message) {
            this.log.error(message);
        }

        @Override
        public void warningReported(String message, Throwable e) {
            this.log.warning(message, e);
        }

        @Override
        public void warningReported(String message) {
            this.log.warning(message);
        }

        @Override
        public void infoReported(String message, Throwable e) {
            this.log.info(message, e);
        }

        @Override
        public void infoReported(String message) {
            this.log.info(message);
        }
    }
}

