/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling;

import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.ProgramReader;
import com.antgroup.antchain.myjava.model.TextLocation;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionReader;
import com.antgroup.antchain.myjava.model.instructions.InstructionReader;
import com.antgroup.antchain.myjava.vm.MyJavaVM;
import java.util.LinkedHashSet;
import java.util.Set;

public class InstructionLocationReader
extends AbstractInstructionReader {
    private Set<String> resources;

    public InstructionLocationReader(Set<String> resources) {
        this.resources = resources;
    }

    public void location(TextLocation location) {
        if (location != null && location.getFileName() != null) {
            this.resources.add(location.getFileName());
        }
    }

    public static Set<String> extractUsedResources(MyJavaVM vm) {
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        ClassReaderSource classSource = vm.getDependencyClassSource();
        InstructionLocationReader reader = new InstructionLocationReader(resources);
        for (MethodReference methodRef : vm.getMethods()) {
            ProgramReader program;
            MethodReader method;
            ClassReader cls = classSource.get(methodRef.getClassName());
            if (cls == null || (method = cls.getMethod(methodRef.getDescriptor())) == null || (program = method.getProgram()) == null) continue;
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                program.basicBlockAt(i).readAllInstructions((InstructionReader)reader);
            }
        }
        return resources;
    }
}

