/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling;

import com.antgroup.antchain.myjava.backend.wasm.WasmTarget;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryVersion;
import com.antgroup.antchain.myjava.cache.AlwaysStaleCacheStatus;
import com.antgroup.antchain.myjava.cache.CacheStatus;
import com.antgroup.antchain.myjava.cache.DiskCachedClassReaderSource;
import com.antgroup.antchain.myjava.cache.DiskMethodNodeCache;
import com.antgroup.antchain.myjava.cache.DiskProgramCache;
import com.antgroup.antchain.myjava.cache.EmptyProgramCache;
import com.antgroup.antchain.myjava.cache.FileSymbolTable;
import com.antgroup.antchain.myjava.cache.SymbolTable;
import com.antgroup.antchain.myjava.debugging.information.DebugInformation;
import com.antgroup.antchain.myjava.debugging.information.DebugInformationBuilder;
import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.FastDependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.PreciseDependencyAnalyzer;
import com.antgroup.antchain.myjava.diagnostics.ProblemProvider;
import com.antgroup.antchain.myjava.model.ClassHolderSource;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.PreOptimizingClassHolderSource;
import com.antgroup.antchain.myjava.model.ProgramCache;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import com.antgroup.antchain.myjava.parsing.ClassDateProvider;
import com.antgroup.antchain.myjava.parsing.ClasspathClassHolderSource;
import com.antgroup.antchain.myjava.tooling.EmptyMyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.InstructionLocationReader;
import com.antgroup.antchain.myjava.tooling.MyJavaTargetType;
import com.antgroup.antchain.myjava.tooling.MyJavaToolException;
import com.antgroup.antchain.myjava.tooling.MyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.sources.SourceFileProvider;
import com.antgroup.antchain.myjava.tooling.sources.SourceFilesCopier;
import com.antgroup.antchain.myjava.vm.BuildTarget;
import com.antgroup.antchain.myjava.vm.DirectoryBuildTarget;
import com.antgroup.antchain.myjava.vm.MyJavaOptimizationLevel;
import com.antgroup.antchain.myjava.vm.MyJavaProgressListener;
import com.antgroup.antchain.myjava.vm.MyJavaTarget;
import com.antgroup.antchain.myjava.vm.MyJavaVM;
import com.antgroup.antchain.myjava.vm.MyJavaVMBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class MyJavaVMTool {
    private File targetDirectory = new File(".");
    private MyJavaTargetType targetType = MyJavaTargetType.WEBASSEMBLY;
    private String targetFileName = "";
    private boolean obfuscated = false;
    private boolean enableMemoryTraceHooks = false;
    private boolean strict;
    private int maxTopLevelNames = 10000;
    private String mainClass;
    private String entryPointName = "main";
    private Properties properties = new Properties();
    private boolean debugInformationGenerated;
    private boolean sourceMapsFileGenerated;
    private boolean sourceFilesCopied;
    private boolean incremental;
    private File cacheDirectory = new File("./myjava-cache");
    private List<String> transformers = new ArrayList<String>();
    private List<String> classesToPreserve = new ArrayList<String>();
    private MyJavaToolLog log = new EmptyMyJavaToolLog();
    private ClassLoader classLoader = MyJavaVMTool.class.getClassLoader();
    private DiskCachedClassReaderSource cachedClassSource;
    private DiskProgramCache programCache;
    private DiskMethodNodeCache astCache;
    private FileSymbolTable symbolTable;
    private FileSymbolTable fileTable;
    private FileSymbolTable variableTable;
    private boolean cancelled;
    private MyJavaProgressListener progressListener;
    private MyJavaVM vm;
    private boolean fastDependencyAnalysis;
    private MyJavaOptimizationLevel optimizationLevel = MyJavaOptimizationLevel.SIMPLE_OPTIMIZED;
    private List<SourceFileProvider> sourceFileProviders = new ArrayList<SourceFileProvider>();
    private DebugInformationBuilder debugEmitter;
    private WasmTarget webAssemblyTarget;
    private WasmBinaryVersion wasmVersion = WasmBinaryVersion.V_0x1;
    private int wasmSectionCode = 1;
    private boolean optimizeWasmStart = true;
    private boolean compressWasm = true;
    private boolean dumpNames = true;
    private Set<File> generatedFiles = new HashSet<File>();
    private int minHeapSize = 0;
    private int maxHeapSize = 0;
    private int maxMemorySize = 0;
    private ReferenceCache referenceCache;
    private boolean longjmpSupported = true;
    private boolean heapDump;

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    public void setEnableMemoryTraceHooks(boolean enableMemoryTraceHooks) {
        this.enableMemoryTraceHooks = enableMemoryTraceHooks;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setMaxTopLevelNames(int maxTopLevelNames) {
        this.maxTopLevelNames = maxTopLevelNames;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public boolean isSourceMapsFileGenerated() {
        return this.sourceMapsFileGenerated;
    }

    public void setSourceMapsFileGenerated(boolean sourceMapsFileGenerated) {
        this.sourceMapsFileGenerated = sourceMapsFileGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public List<String> getClassesToPreserve() {
        return this.classesToPreserve;
    }

    public MyJavaToolLog getLog() {
        return this.log;
    }

    public void setLog(MyJavaToolLog log) {
        this.log = log;
    }

    public MyJavaTargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(MyJavaTargetType targetType) {
        this.targetType = targetType;
    }

    public MyJavaOptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(MyJavaOptimizationLevel optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public boolean isFastDependencyAnalysis() {
        return this.fastDependencyAnalysis;
    }

    public void setFastDependencyAnalysis(boolean fastDependencyAnalysis) {
        this.fastDependencyAnalysis = fastDependencyAnalysis;
    }

    public void setMinHeapSize(int minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WasmBinaryVersion getWasmVersion() {
        return this.wasmVersion;
    }

    public void setWasmVersion(WasmBinaryVersion wasmVersion) {
        this.wasmVersion = wasmVersion;
    }

    public int getWasmSectionCode() {
        return this.wasmSectionCode;
    }

    public void setWasmSectionCode(int wasmSectionCode) {
        this.wasmSectionCode = wasmSectionCode;
    }

    public void setOptimizeWasmStart(boolean optimizeWasmStart) {
        this.optimizeWasmStart = optimizeWasmStart;
    }

    public void setCompressWasm(boolean compressWasm) {
        this.compressWasm = compressWasm;
    }

    public void setDumpNames(boolean dumpNames) {
        this.dumpNames = dumpNames;
    }

    public void setLongjmpSupported(boolean longjmpSupported) {
        this.longjmpSupported = longjmpSupported;
    }

    public void setHeapDump(boolean heapDump) {
        this.heapDump = heapDump;
    }

    public void setProgressListener(MyJavaProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public ProblemProvider getProblemProvider() {
        return this.vm != null ? this.vm.getProblemProvider() : null;
    }

    public DependencyInfo getDependencyInfo() {
        return this.vm.getDependencyInfo();
    }

    public Collection<String> getClasses() {
        return this.vm != null ? this.vm.getClasses() : Collections.emptyList();
    }

    public Set<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public Collection<String> getUsedResources() {
        if (this.vm == null) {
            return Collections.emptyList();
        }
        return InstructionLocationReader.extractUsedResources(this.vm);
    }

    public void addSourceFileProvider(SourceFileProvider sourceFileProvider) {
        this.sourceFileProviders.add(sourceFileProvider);
    }

    private MyJavaTarget prepareTarget() {
        switch (this.targetType) {
            case WEBASSEMBLY: {
                return this.prepareWebAssemblyTarget();
            }
        }
        throw new IllegalStateException("Unknown target type: " + (Object)((Object)this.targetType));
    }

    private WasmTarget prepareWebAssemblyTarget() {
        this.webAssemblyTarget = new WasmTarget();
        this.webAssemblyTarget.setDebugging(this.debugInformationGenerated);
        this.webAssemblyTarget.setWastEmitted(this.debugInformationGenerated);
        this.webAssemblyTarget.setAbiEmitted(true);
        this.webAssemblyTarget.setWascEmitted(true);
        this.webAssemblyTarget.setHtmlEmitted(true);
        this.webAssemblyTarget.setWasmSectionCode(this.wasmSectionCode);
        this.webAssemblyTarget.setOptimizeWasmStart(this.optimizeWasmStart);
        this.webAssemblyTarget.setCompressWasm(this.compressWasm);
        this.webAssemblyTarget.setDumpNames(this.dumpNames);
        this.webAssemblyTarget.setVersion(this.wasmVersion);
        if (this.minHeapSize > 0) {
            this.webAssemblyTarget.setMinHeapSize(this.minHeapSize);
        }
        if (this.maxHeapSize > 0) {
            this.webAssemblyTarget.setMaxHeapSize(this.maxHeapSize);
        }
        if (this.maxMemorySize > 0) {
            this.webAssemblyTarget.setMaxMemorySize(this.maxMemorySize);
        }
        this.webAssemblyTarget.setObfuscated(this.obfuscated);
        this.webAssemblyTarget.setEnableMemoryTraceHooks(this.enableMemoryTraceHooks);
        return this.webAssemblyTarget;
    }

    public void generate() throws MyJavaToolException {
        try {
            AlwaysStaleCacheStatus cacheStatus;
            this.cancelled = false;
            this.log.info("Running MyJava");
            this.referenceCache = new ReferenceCache();
            MyJavaVMBuilder vmBuilder = new MyJavaVMBuilder(this.prepareTarget());
            vmBuilder.setReferenceCache(this.referenceCache);
            if (this.incremental) {
                this.cacheDirectory.mkdirs();
                this.symbolTable = new FileSymbolTable(new File(this.cacheDirectory, "symbols"));
                this.fileTable = new FileSymbolTable(new File(this.cacheDirectory, "files"));
                this.variableTable = new FileSymbolTable(new File(this.cacheDirectory, "variables"));
                ClasspathClassHolderSource innerClassSource = new ClasspathClassHolderSource(this.classLoader, this.referenceCache);
                PreOptimizingClassHolderSource classSource = new PreOptimizingClassHolderSource((ClassHolderSource)innerClassSource);
                this.cachedClassSource = new DiskCachedClassReaderSource(this.cacheDirectory, this.referenceCache, (SymbolTable)this.symbolTable, (SymbolTable)this.fileTable, (SymbolTable)this.variableTable, (ClassHolderSource)classSource, (ClassDateProvider)innerClassSource);
                this.programCache = new DiskProgramCache(this.cacheDirectory, this.referenceCache, (SymbolTable)this.symbolTable, (SymbolTable)this.fileTable, (SymbolTable)this.variableTable);
                try {
                    this.symbolTable.update();
                    this.fileTable.update();
                    this.variableTable.update();
                }
                catch (IOException e) {
                    this.log.info("Cache is missing");
                }
                vmBuilder.setClassLoader(this.classLoader).setClassSource((ClassReaderSource)this.cachedClassSource);
                cacheStatus = this.cachedClassSource;
            } else {
                vmBuilder.setClassLoader(this.classLoader).setClassSource((ClassReaderSource)new PreOptimizingClassHolderSource((ClassHolderSource)new ClasspathClassHolderSource(this.classLoader, this.referenceCache)));
                cacheStatus = AlwaysStaleCacheStatus.INSTANCE;
            }
            vmBuilder.setDependencyAnalyzerFactory(this.fastDependencyAnalysis ? FastDependencyAnalyzer::new : PreciseDependencyAnalyzer::new);
            vmBuilder.setObfuscated(this.obfuscated);
            vmBuilder.setStrict(this.strict);
            this.vm = vmBuilder.build();
            if (this.progressListener != null) {
                this.vm.setProgressListener(this.progressListener);
            }
            this.vm.setProperties(this.properties);
            this.vm.setProgramCache((ProgramCache)(this.incremental ? this.programCache : EmptyProgramCache.INSTANCE));
            this.vm.setCacheStatus((CacheStatus)cacheStatus);
            this.vm.setOptimizationLevel(!this.fastDependencyAnalysis && !this.incremental ? this.optimizationLevel : MyJavaOptimizationLevel.SIMPLE);
            if (this.incremental) {
                this.vm.addVirtualMethods(m -> true);
            }
            this.vm.installPlugins();
            for (ClassHolderTransformer transformer : this.resolveTransformers(this.classLoader)) {
                this.vm.add(transformer);
            }
            if (this.mainClass != null) {
                this.vm.entryPoint(this.mainClass, this.entryPointName != null ? this.entryPointName : "main");
            }
            for (String className : this.classesToPreserve) {
                this.vm.preserveType(className);
            }
            this.targetDirectory.mkdirs();
            DirectoryBuildTarget buildTarget = new DirectoryBuildTarget(this.targetDirectory);
            String outputName = this.getResolvedTargetFileName();
            this.vm.build((BuildTarget)buildTarget, outputName);
            if (this.vm.wasCancelled()) {
                this.log.info("Build cancelled");
                this.cancelled = true;
                return;
            }
            ProblemProvider problemProvider = this.vm.getProblemProvider();
            if (problemProvider.getProblems().isEmpty()) {
                this.log.info("Output file successfully built");
            } else if (problemProvider.getSevereProblems().isEmpty()) {
                this.log.info("Output file built with warnings");
            } else {
                this.log.info("Output file built with errors");
            }
            File outputFile = new File(this.targetDirectory, outputName);
            this.generatedFiles.add(outputFile);
            if (this.incremental) {
                this.programCache.flush();
                if (this.astCache != null) {
                    this.astCache.flush();
                }
                this.cachedClassSource.flush();
                this.symbolTable.flush();
                this.fileTable.flush();
                this.variableTable.flush();
                this.log.info("Cache updated");
            }
            this.printStats();
        }
        catch (IOException e) {
            throw new MyJavaToolException("IO error occurred", e);
        }
    }

    private String getResolvedTargetFileName() {
        if (this.targetFileName.isEmpty()) {
            switch (this.targetType) {
                case WEBASSEMBLY: {
                    return "classes.wasm";
                }
            }
            return "classes";
        }
        return this.targetFileName + ".wasm";
    }

    private void additionalJavaScriptOutput(Writer writer) throws IOException {
        DebugInformation debugInfo;
        if (this.debugInformationGenerated) {
            assert (this.debugEmitter != null);
            debugInfo = this.debugEmitter.getDebugInformation();
            File debugSymbolFile = new File(this.targetDirectory, this.getResolvedTargetFileName() + ".teavmdbg");
            try (BufferedOutputStream debugInfoOut = new BufferedOutputStream(new FileOutputStream(debugSymbolFile));){
                debugInfo.write((OutputStream)debugInfoOut);
            }
            this.generatedFiles.add(debugSymbolFile);
            this.log.info("Debug information successfully written");
        }
        if (this.sourceMapsFileGenerated) {
            assert (this.debugEmitter != null);
            debugInfo = this.debugEmitter.getDebugInformation();
            String sourceMapsFileName = this.getResolvedTargetFileName() + ".map";
            writer.append("\n//# sourceMappingURL=").append(sourceMapsFileName);
            File sourceMapsFile = new File(this.targetDirectory, sourceMapsFileName);
            try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapsFile), StandardCharsets.UTF_8);){
                debugInfo.writeAsSourceMaps((Writer)sourceMapsOut, "src", this.getResolvedTargetFileName());
            }
            this.generatedFiles.add(sourceMapsFile);
            this.log.info("Source maps successfully written");
        }
        if (this.sourceFilesCopied) {
            this.copySourceFiles();
            this.log.info("Source files successfully written");
        }
    }

    private void printStats() {
        if (this.vm == null || this.vm.getWrittenClasses() == null) {
            return;
        }
        int classCount = this.vm.getWrittenClasses().getClassNames().size();
        int methodCount = 0;
        for (String className : this.vm.getWrittenClasses().getClassNames()) {
            ClassReader cls = this.vm.getWrittenClasses().get(className);
            methodCount += cls.getMethods().size();
        }
        this.log.info("Classes compiled: " + classCount);
        this.log.info("Methods compiled: " + methodCount);
    }

    private void copySourceFiles() {
        if (this.vm.getWrittenClasses() == null) {
            return;
        }
        SourceFilesCopier copier = new SourceFilesCopier(this.sourceFileProviders, this.generatedFiles::add);
        copier.addClasses(this.vm.getWrittenClasses());
        copier.setLog(this.log);
        copier.copy(new File(this.targetDirectory, "src"));
    }

    private List<ClassHolderTransformer> resolveTransformers(ClassLoader classLoader) {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                this.log.error("Transformer not found: " + transformerName, e);
                continue;
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                this.log.error("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
                continue;
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.log.error("Transformer " + transformerName + " has no default constructor");
                continue;
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.log.error("Error instantiating transformer " + transformerName, e);
            }
        }
        return transformerInstances;
    }
}

