/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling.sources;

import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ListableClassReaderSource;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.tooling.EmptyMyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.MyJavaToolLog;
import com.antgroup.antchain.myjava.tooling.sources.ProgramSourceAggregator;
import com.antgroup.antchain.myjava.tooling.sources.SourceFileInfo;
import com.antgroup.antchain.myjava.tooling.sources.SourceFileProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.teavm.apachecommons.io.IOUtils;

public class SourceFilesCopier {
    private MyJavaToolLog log = new EmptyMyJavaToolLog();
    private List<SourceFileProvider> sourceFileProviders;
    private Set<String> sourceFiles = new HashSet<String>();
    private Consumer<File> copiesConsumer;

    public SourceFilesCopier(List<SourceFileProvider> sourceFileProviders, Consumer<File> copiesConsumer) {
        this.sourceFileProviders = sourceFileProviders;
        this.copiesConsumer = copiesConsumer;
    }

    public void setLog(MyJavaToolLog log) {
        this.log = log;
    }

    public void addClasses(ListableClassReaderSource classReader) {
        ProgramSourceAggregator sourceAggregator = new ProgramSourceAggregator(this.sourceFiles);
        for (String className : classReader.getClassNames()) {
            ClassReader cls = classReader.get(className);
            for (MethodReader method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                sourceAggregator.addLocationsOfProgram(method.getProgram());
            }
        }
    }

    public void copy(File targetDirectory) {
        for (SourceFileProvider provider : this.sourceFileProviders) {
            try {
                provider.open();
            }
            catch (IOException e) {
                this.log.warning("Error opening source file provider", e);
            }
        }
        targetDirectory.mkdirs();
        for (String fileName : this.sourceFiles) {
            try {
                SourceFileInfo sourceFile = this.findSourceFile(fileName);
                if (sourceFile == null) {
                    this.log.info("Missing source file: " + fileName);
                    continue;
                }
                File outputFile = new File(targetDirectory, fileName);
                if (outputFile.exists() && outputFile.lastModified() > sourceFile.lastModified() && sourceFile.lastModified() > 0L) continue;
                try (InputStream input = sourceFile.open();){
                    outputFile.getParentFile().mkdirs();
                    try (FileOutputStream output = new FileOutputStream(outputFile);){
                        IOUtils.copy((InputStream)input, (OutputStream)output);
                    }
                }
                this.copiesConsumer.accept(outputFile);
            }
            catch (IOException e) {
                this.log.warning("Could not copy source file " + fileName, e);
            }
        }
        for (SourceFileProvider provider : this.sourceFileProviders) {
            try {
                provider.close();
            }
            catch (IOException e) {
                this.log.warning("Error closing source file provider", e);
            }
        }
    }

    private SourceFileInfo findSourceFile(String fileName) throws IOException {
        for (SourceFileProvider provider : this.sourceFileProviders) {
            SourceFileInfo sourceFile = provider.getSourceFile(fileName);
            if (sourceFile == null) continue;
            return sourceFile;
        }
        return null;
    }
}

