/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.batch.model.ComputeResource;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ComputeResourceMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<Integer> MINVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minvCpus").build();
    private static final MarshallingInfo<Integer> MAXVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxvCpus").build();
    private static final MarshallingInfo<Integer> DESIREDVCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredvCpus").build();
    private static final MarshallingInfo<List> INSTANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceTypes").build();
    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageId").build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroupIds").build();
    private static final MarshallingInfo<String> EC2KEYPAIR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2KeyPair").build();
    private static final MarshallingInfo<String> INSTANCEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceRole").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<Integer> BIDPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bidPercentage").build();
    private static final MarshallingInfo<String> SPOTIAMFLEETROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spotIamFleetRole").build();
    private static final ComputeResourceMarshaller instance = new ComputeResourceMarshaller();

    public static ComputeResourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ComputeResource computeResource, ProtocolMarshaller protocolMarshaller) {
        if (computeResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)computeResource.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getMinvCpus(), MINVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getMaxvCpus(), MAXVCPUS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getDesiredvCpus(), DESIREDVCPUS_BINDING);
            protocolMarshaller.marshall(computeResource.getInstanceTypes(), INSTANCETYPES_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getImageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall(computeResource.getSubnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(computeResource.getSecurityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getEc2KeyPair(), EC2KEYPAIR_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getInstanceRole(), INSTANCEROLE_BINDING);
            protocolMarshaller.marshall(computeResource.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getBidPercentage(), BIDPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)computeResource.getSpotIamFleetRole(), SPOTIAMFLEETROLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

