/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.ContainerOverrides;
import com.amazonaws.services.batch.model.EcsPropertiesOverride;
import com.amazonaws.services.batch.model.transform.NodePropertyOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodePropertyOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private String targetNodes;
    private ContainerOverrides containerOverrides;
    private EcsPropertiesOverride ecsPropertiesOverride;
    private List<String> instanceTypes;

    public void setTargetNodes(String targetNodes) {
        this.targetNodes = targetNodes;
    }

    public String getTargetNodes() {
        return this.targetNodes;
    }

    public NodePropertyOverride withTargetNodes(String targetNodes) {
        this.setTargetNodes(targetNodes);
        return this;
    }

    public void setContainerOverrides(ContainerOverrides containerOverrides) {
        this.containerOverrides = containerOverrides;
    }

    public ContainerOverrides getContainerOverrides() {
        return this.containerOverrides;
    }

    public NodePropertyOverride withContainerOverrides(ContainerOverrides containerOverrides) {
        this.setContainerOverrides(containerOverrides);
        return this;
    }

    public void setEcsPropertiesOverride(EcsPropertiesOverride ecsPropertiesOverride) {
        this.ecsPropertiesOverride = ecsPropertiesOverride;
    }

    public EcsPropertiesOverride getEcsPropertiesOverride() {
        return this.ecsPropertiesOverride;
    }

    public NodePropertyOverride withEcsPropertiesOverride(EcsPropertiesOverride ecsPropertiesOverride) {
        this.setEcsPropertiesOverride(ecsPropertiesOverride);
        return this;
    }

    public List<String> getInstanceTypes() {
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new ArrayList<String>(instanceTypes);
    }

    public NodePropertyOverride withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes(new ArrayList<String>(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add(ele);
        }
        return this;
    }

    public NodePropertyOverride withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetNodes() != null) {
            sb.append("TargetNodes: ").append(this.getTargetNodes()).append(",");
        }
        if (this.getContainerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(this.getContainerOverrides()).append(",");
        }
        if (this.getEcsPropertiesOverride() != null) {
            sb.append("EcsPropertiesOverride: ").append(this.getEcsPropertiesOverride()).append(",");
        }
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodePropertyOverride)) {
            return false;
        }
        NodePropertyOverride other = (NodePropertyOverride)obj;
        if (other.getTargetNodes() == null ^ this.getTargetNodes() == null) {
            return false;
        }
        if (other.getTargetNodes() != null && !other.getTargetNodes().equals(this.getTargetNodes())) {
            return false;
        }
        if (other.getContainerOverrides() == null ^ this.getContainerOverrides() == null) {
            return false;
        }
        if (other.getContainerOverrides() != null && !other.getContainerOverrides().equals(this.getContainerOverrides())) {
            return false;
        }
        if (other.getEcsPropertiesOverride() == null ^ this.getEcsPropertiesOverride() == null) {
            return false;
        }
        if (other.getEcsPropertiesOverride() != null && !other.getEcsPropertiesOverride().equals(this.getEcsPropertiesOverride())) {
            return false;
        }
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        return other.getInstanceTypes() == null || other.getInstanceTypes().equals(this.getInstanceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetNodes() == null ? 0 : this.getTargetNodes().hashCode());
        hashCode = 31 * hashCode + (this.getContainerOverrides() == null ? 0 : this.getContainerOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getEcsPropertiesOverride() == null ? 0 : this.getEcsPropertiesOverride().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        return hashCode;
    }

    public NodePropertyOverride clone() {
        try {
            return (NodePropertyOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodePropertyOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

