/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.S3Config;
import com.amazonaws.services.bedrock.model.transform.CloudWatchConfigMarshaller;
import java.io.Serializable;

public class CloudWatchConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String logGroupName;
    private String roleArn;
    private S3Config largeDataDeliveryS3Config;

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public CloudWatchConfig withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CloudWatchConfig withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setLargeDataDeliveryS3Config(S3Config largeDataDeliveryS3Config) {
        this.largeDataDeliveryS3Config = largeDataDeliveryS3Config;
    }

    public S3Config getLargeDataDeliveryS3Config() {
        return this.largeDataDeliveryS3Config;
    }

    public CloudWatchConfig withLargeDataDeliveryS3Config(S3Config largeDataDeliveryS3Config) {
        this.setLargeDataDeliveryS3Config(largeDataDeliveryS3Config);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getLargeDataDeliveryS3Config() != null) {
            sb.append("LargeDataDeliveryS3Config: ").append(this.getLargeDataDeliveryS3Config());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchConfig)) {
            return false;
        }
        CloudWatchConfig other = (CloudWatchConfig)obj;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getLargeDataDeliveryS3Config() == null ^ this.getLargeDataDeliveryS3Config() == null) {
            return false;
        }
        return other.getLargeDataDeliveryS3Config() == null || other.getLargeDataDeliveryS3Config().equals(this.getLargeDataDeliveryS3Config());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getLargeDataDeliveryS3Config() == null ? 0 : this.getLargeDataDeliveryS3Config().hashCode());
        return hashCode;
    }

    public CloudWatchConfig clone() {
        try {
            return (CloudWatchConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

