/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bedrock.model.EvaluationConfig;
import com.amazonaws.services.bedrock.model.EvaluationInferenceConfig;
import com.amazonaws.services.bedrock.model.EvaluationOutputDataConfig;
import com.amazonaws.services.bedrock.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateEvaluationJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String jobName;
    private String jobDescription;
    private String clientRequestToken;
    private String roleArn;
    private String customerEncryptionKeyId;
    private List<Tag> jobTags;
    private EvaluationConfig evaluationConfig;
    private EvaluationInferenceConfig inferenceConfig;
    private EvaluationOutputDataConfig outputDataConfig;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public CreateEvaluationJobRequest withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public CreateEvaluationJobRequest withJobDescription(String jobDescription) {
        this.setJobDescription(jobDescription);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateEvaluationJobRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateEvaluationJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setCustomerEncryptionKeyId(String customerEncryptionKeyId) {
        this.customerEncryptionKeyId = customerEncryptionKeyId;
    }

    public String getCustomerEncryptionKeyId() {
        return this.customerEncryptionKeyId;
    }

    public CreateEvaluationJobRequest withCustomerEncryptionKeyId(String customerEncryptionKeyId) {
        this.setCustomerEncryptionKeyId(customerEncryptionKeyId);
        return this;
    }

    public List<Tag> getJobTags() {
        return this.jobTags;
    }

    public void setJobTags(Collection<Tag> jobTags) {
        if (jobTags == null) {
            this.jobTags = null;
            return;
        }
        this.jobTags = new ArrayList<Tag>(jobTags);
    }

    public CreateEvaluationJobRequest withJobTags(Tag ... jobTags) {
        if (this.jobTags == null) {
            this.setJobTags(new ArrayList<Tag>(jobTags.length));
        }
        for (Tag ele : jobTags) {
            this.jobTags.add(ele);
        }
        return this;
    }

    public CreateEvaluationJobRequest withJobTags(Collection<Tag> jobTags) {
        this.setJobTags(jobTags);
        return this;
    }

    public void setEvaluationConfig(EvaluationConfig evaluationConfig) {
        this.evaluationConfig = evaluationConfig;
    }

    public EvaluationConfig getEvaluationConfig() {
        return this.evaluationConfig;
    }

    public CreateEvaluationJobRequest withEvaluationConfig(EvaluationConfig evaluationConfig) {
        this.setEvaluationConfig(evaluationConfig);
        return this;
    }

    public void setInferenceConfig(EvaluationInferenceConfig inferenceConfig) {
        this.inferenceConfig = inferenceConfig;
    }

    public EvaluationInferenceConfig getInferenceConfig() {
        return this.inferenceConfig;
    }

    public CreateEvaluationJobRequest withInferenceConfig(EvaluationInferenceConfig inferenceConfig) {
        this.setInferenceConfig(inferenceConfig);
        return this;
    }

    public void setOutputDataConfig(EvaluationOutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public EvaluationOutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public CreateEvaluationJobRequest withOutputDataConfig(EvaluationOutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getJobDescription() != null) {
            sb.append("JobDescription: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getCustomerEncryptionKeyId() != null) {
            sb.append("CustomerEncryptionKeyId: ").append(this.getCustomerEncryptionKeyId()).append(",");
        }
        if (this.getJobTags() != null) {
            sb.append("JobTags: ").append(this.getJobTags()).append(",");
        }
        if (this.getEvaluationConfig() != null) {
            sb.append("EvaluationConfig: ").append(this.getEvaluationConfig()).append(",");
        }
        if (this.getInferenceConfig() != null) {
            sb.append("InferenceConfig: ").append(this.getInferenceConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationJobRequest)) {
            return false;
        }
        CreateEvaluationJobRequest other = (CreateEvaluationJobRequest)obj;
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getJobDescription() == null ^ this.getJobDescription() == null) {
            return false;
        }
        if (other.getJobDescription() != null && !other.getJobDescription().equals(this.getJobDescription())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getCustomerEncryptionKeyId() == null ^ this.getCustomerEncryptionKeyId() == null) {
            return false;
        }
        if (other.getCustomerEncryptionKeyId() != null && !other.getCustomerEncryptionKeyId().equals(this.getCustomerEncryptionKeyId())) {
            return false;
        }
        if (other.getJobTags() == null ^ this.getJobTags() == null) {
            return false;
        }
        if (other.getJobTags() != null && !other.getJobTags().equals(this.getJobTags())) {
            return false;
        }
        if (other.getEvaluationConfig() == null ^ this.getEvaluationConfig() == null) {
            return false;
        }
        if (other.getEvaluationConfig() != null && !other.getEvaluationConfig().equals(this.getEvaluationConfig())) {
            return false;
        }
        if (other.getInferenceConfig() == null ^ this.getInferenceConfig() == null) {
            return false;
        }
        if (other.getInferenceConfig() != null && !other.getInferenceConfig().equals(this.getInferenceConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        return other.getOutputDataConfig() == null || other.getOutputDataConfig().equals(this.getOutputDataConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getJobDescription() == null ? 0 : this.getJobDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerEncryptionKeyId() == null ? 0 : this.getCustomerEncryptionKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getJobTags() == null ? 0 : this.getJobTags().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationConfig() == null ? 0 : this.getEvaluationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceConfig() == null ? 0 : this.getInferenceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        return hashCode;
    }

    public CreateEvaluationJobRequest clone() {
        return (CreateEvaluationJobRequest)super.clone();
    }
}

